/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dialog;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SelectCategoryDialog
extends Dialog {
    private static final Rectangle dialogShellSize = new Rectangle(0, 0, 280, 280);
    private String catPath;
    private boolean readonly;
    private String title;
    Tree categoryTree;
    TreeItem rootItem;

    public SelectCategoryDialog(Shell shell, String string) {
        super(shell);
        this.title = string;
    }

    public String getCatPath() {
        return this.catPath;
    }

    public void setCatPath(String string) {
        this.catPath = string;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    private void buildCatTree(TreeItem treeItem, Category category) {
        Hashtable hashtable = category.getSubCategories();
        Iterator iterator = category.getSortedSubCatTitles().iterator();
        while (iterator.hasNext()) {
            Category category2 = (Category)hashtable.get(iterator.next());
            if (!this.readonly && category2.isBlogroll()) continue;
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            treeItem2.setImage(this.getImage(category2));
            treeItem2.setText(category2.getName());
            this.buildCatTree(treeItem2, category2);
        }
    }

    private String getCatPath(TreeItem treeItem) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(treeItem.getText());
        TreeItem treeItem2 = treeItem;
        while ((treeItem2 = treeItem2.getParentItem()) != null && treeItem2 != this.rootItem) {
            arrayList.add(treeItem2.getText());
        }
        String string = (String)arrayList.get(arrayList.size() - 1);
        for (int i = arrayList.size() - 2; i >= 0; --i) {
            string = string + "=;=" + arrayList.get(i);
        }
        return string;
    }

    private Image getImage(Category category) {
        boolean bl = false;
        Hashtable hashtable = category.getFavorites();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Favorite favorite = (Favorite)enumeration.nextElement();
            if (favorite == null || favorite.getUnreadNewsCount() <= 0) continue;
            bl = true;
            break;
        }
        if (category.isBlogroll()) {
            return bl ? PaintShop.iconFolderSubscribeUnread : PaintShop.iconFolderSubscribe;
        }
        return bl ? PaintShop.iconFolderUnread : PaintShop.iconFolder;
    }

    private void selectCategory(String string) {
        String[] stringArray = string.split("=;=");
        TreeItem[] treeItemArray = this.rootItem.getItems();
        TreeItem treeItem = this.rootItem;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            for (int j = 0; j < treeItemArray.length; ++j) {
                TreeItem treeItem2 = treeItemArray[j];
                if (!treeItem2.getText().equals(string2)) continue;
                treeItem = treeItem2;
                treeItem.setExpanded(true);
                treeItemArray = treeItem.getItems();
                continue block0;
            }
        }
        this.categoryTree.setSelection(new TreeItem[]{treeItem});
        this.categoryTree.showSelection();
    }

    @Override
    protected void buttonPressed(int n) {
        if (n == 0 && this.categoryTree.getSelectionCount() > 0) {
            this.catPath = this.getCatPath(this.categoryTree.getSelection()[0]);
        }
        super.buttonPressed(n);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!GlobalSettings.isMac()) {
            shell.setImages(PaintShop.iconOwl);
        }
        shell.setText(this.title);
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        if (GUI.display.getDismissalAlignment() == 131072) {
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
            this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true).setFont(FontShop.dialogFont);
        } else {
            this.createButton(composite, 0, GUI.i18n.getTranslation("BUTTON_OK"), true).setFont(FontShop.dialogFont);
            this.createButton(composite, 1, GUI.i18n.getTranslation("BUTTON_CANCLE"), false).setFont(FontShop.dialogFont);
        }
        this.onSelection();
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Widget widget;
        Widget widget2;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout(LayoutShop.createGridLayout(1, 5, 10));
        this.categoryTree = new Tree(composite2, 2052);
        this.categoryTree.setLayoutData(new GridData(1808));
        this.categoryTree.setFont(FontShop.dialogFont);
        this.categoryTree.addListener(8, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (SelectCategoryDialog.this.categoryTree.getSelectionCount() <= 0) {
                    return;
                }
                TreeItem treeItem = SelectCategoryDialog.this.categoryTree.getSelection()[0];
                Rectangle rectangle = treeItem.getBounds();
                Rectangle rectangle2 = treeItem.getImageBounds(0);
                if (rectangle2 != null) {
                    rectangle.add(rectangle2);
                }
                if (!rectangle.contains(event.x, event.y)) {
                    return;
                }
                if (treeItem.getItems().length > 0) {
                    treeItem.setExpanded(!treeItem.getExpanded());
                } else if (treeItem != SelectCategoryDialog.this.rootItem) {
                    SelectCategoryDialog.this.buttonPressed(0);
                }
            }
        });
        this.categoryTree.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectCategoryDialog.this.onSelection();
            }
        });
        if (!this.readonly) {
            widget2 = new Menu(this.categoryTree);
            widget = new MenuItem((Menu)widget2, 8);
            ((MenuItem)widget).setText(GUI.i18n.getTranslation("DIALOG_ADD_CATEGORY_TITLE") + "...");
            ((MenuItem)widget).addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    SelectCategoryDialog.this.createNewCategory();
                }
            });
            this.categoryTree.setMenu((Menu)widget2);
            MenuManager.initMnemonics((Menu)widget2);
        }
        this.buildCatTree();
        if (!this.readonly) {
            widget2 = new Button(composite2, 0);
            ((Button)widget2).setText(GUI.i18n.getTranslation("DIALOG_ADD_CATEGORY_TITLE") + "...");
            ((Control)widget2).setLayoutData(new GridData(32));
            ((Control)widget2).setFont(FontShop.dialogFont);
            ((Button)widget2).addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    SelectCategoryDialog.this.createNewCategory();
                }
            });
            if (this.rootItem.getItemCount() <= 0) {
                ((Control)widget2).setFocus();
            }
            WidgetShop.initMnemonics(new Button[]{widget2});
        }
        widget2 = new Composite(composite, 0);
        ((Control)widget2).setLayoutData(LayoutDataShop.createGridData(768, 2));
        ((Composite)widget2).setLayout(LayoutShop.createGridLayout(1, 0, 0));
        widget = new Label((Composite)widget2, 258);
        ((Control)widget).setLayoutData(new GridData(768));
        if (StringShop.isset(this.catPath)) {
            this.selectCategory(this.catPath);
        }
        return composite2;
    }

    @Override
    protected Button getButton(int n) {
        return super.getButton(n);
    }

    @Override
    protected Point getInitialSize() {
        return new Point(this.convertHorizontalDLUsToPixels(SelectCategoryDialog.dialogShellSize.width), this.convertVerticalDLUsToPixels(SelectCategoryDialog.dialogShellSize.height));
    }

    @Override
    protected int getShellStyle() {
        int n = 0x10830 | SelectCategoryDialog.getDefaultOrientation();
        if (!GlobalSettings.isMac()) {
            n |= 0x40;
        }
        return n;
    }

    @Override
    protected void initializeBounds() {
        super.initializeBounds();
        Point point = this.getShell().getSize();
        this.getShell().setMinimumSize(point.x, point.y);
    }

    @Override
    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData(gridData);
    }

    void buildCatTree() {
        Category category = Category.getRootCategory();
        Hashtable hashtable = category.getSubCategories();
        Iterator iterator = category.getSortedSubCatTitles().iterator();
        this.rootItem = new TreeItem(this.categoryTree, 0);
        this.rootItem.setText(GUI.i18n.getTranslation("HEADER_RSS_FAVORITES"));
        this.rootItem.setImage(PaintShop.loadImage("/img/icons/root_category.gif"));
        this.rootItem.setData(Boolean.TRUE);
        this.rootItem.setFont(FontShop.dialogBoldFont);
        this.rootItem.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                SelectCategoryDialog.this.rootItem.getImage().dispose();
            }
        });
        while (iterator.hasNext()) {
            Category category2 = (Category)hashtable.get(iterator.next());
            if (!this.readonly && category2.isBlogroll()) continue;
            TreeItem treeItem = new TreeItem(this.rootItem, 0);
            treeItem.setImage(this.getImage(category2));
            treeItem.setText(category2.getName());
            this.buildCatTree(treeItem, category2);
        }
        if (this.rootItem.getItemCount() > 0) {
            this.categoryTree.setSelection(new TreeItem[]{this.rootItem.getItems()[0]});
        } else {
            this.categoryTree.setSelection(new TreeItem[]{this.rootItem});
        }
        this.rootItem.setExpanded(true);
        int n = this.rootItem.getItemCount();
        for (int i = 0; i < n; ++i) {
            this.rootItem.getItems()[i].setExpanded(true);
        }
    }

    void createNewCategory() {
        String string = GUI.rssOwlGui.getEventManager().actionNewCategory(this.getShell(), this.getSelectedCategory());
        if (string != null) {
            TreeItem treeItem;
            int n;
            TreeItem treeItem2 = this.categoryTree.getSelectionCount() > 0 ? this.categoryTree.getSelection()[0] : this.rootItem;
            Collator collator = Collator.getInstance();
            TreeItem[] treeItemArray = treeItem2.getItems();
            for (n = 0; n < treeItemArray.length && collator.compare((treeItem = treeItemArray[n]).getText(), string) <= 0; ++n) {
            }
            TreeItem treeItem3 = new TreeItem(treeItem2, 0, n);
            treeItem3.setText(string);
            treeItem3.setImage(PaintShop.iconFolder);
            this.categoryTree.setSelection(new TreeItem[]{treeItem3});
            this.categoryTree.showSelection();
            this.categoryTree.setFocus();
            this.onSelection();
        }
    }

    Category getSelectedCategory() {
        Category category = Category.getRootCategory();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (this.categoryTree.getSelectionCount() == 0 || this.categoryTree.getSelection()[0] == this.rootItem) {
            return category;
        }
        TreeItem treeItem = this.categoryTree.getSelection()[0];
        arrayList.add(treeItem.getText());
        while ((treeItem = treeItem.getParentItem()) != this.rootItem) {
            arrayList.add(treeItem.getText());
        }
        if (arrayList.size() > 0) {
            string = (String)arrayList.get(arrayList.size() - 1);
            for (int i = arrayList.size() - 2; i >= 0; --i) {
                string = string + "=;=" + arrayList.get(i);
            }
        }
        if (StringShop.isset(string)) {
            String[] stringArray = string.split("=;=");
            for (int i = 0; i < stringArray.length; ++i) {
                category = (Category)category.getSubCategories().get(stringArray[i]);
            }
        }
        return category;
    }

    void onSelection() {
        TreeItem treeItem;
        TreeItem treeItem2 = treeItem = this.categoryTree.getSelection().length > 0 ? this.categoryTree.getSelection()[0] : null;
        if (WidgetShop.isset(treeItem) && Boolean.TRUE.equals(treeItem.getData())) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }
}

