/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.dnd;

import java.util.ArrayList;
import net.sourceforge.rssowl.controller.dnd.FavoritesTreeDND;
import net.sourceforge.rssowl.model.TabItemData;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class NewsTabFolderDND {
    private static final int operations = 3;
    private static final Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
    private DragSource source;
    private DropTarget target;
    FavoritesTreeDND rssOwlFavoritesTreeDND;
    CTabFolder tabFolder;

    public NewsTabFolderDND(CTabFolder cTabFolder, FavoritesTreeDND favoritesTreeDND) {
        this.tabFolder = cTabFolder;
        this.rssOwlFavoritesTreeDND = favoritesTreeDND;
        this.initDragAndDrop();
    }

    public void dispose() {
        this.source.dispose();
        this.target.dispose();
    }

    private void createDragSource() {
        this.source = new DragSource(this.tabFolder, 3);
        this.source.setTransfer(types);
        this.source.addDragListener(new DragSourceAdapter(){

            @Override
            public void dragFinished(DragSourceEvent dragSourceEvent) {
                NewsTabFolderDND.this.rssOwlFavoritesTreeDND.setDragSourceItem(null);
            }

            @Override
            public void dragSetData(DragSourceEvent dragSourceEvent) {
                TabItemData tabItemData = (TabItemData)NewsTabFolderDND.this.rssOwlFavoritesTreeDND.getDragSourceItem().getData();
                String string = "";
                String string2 = "";
                if (tabItemData.isFeed()) {
                    string2 = tabItemData.getTitle();
                    string = tabItemData.getUrl();
                } else if (tabItemData.isBrowser()) {
                    string2 = NewsTabFolderDND.this.rssOwlFavoritesTreeDND.getDragSourceItem().getText();
                    if (tabItemData.getRSSOwlBrowserPanel() != null && WidgetShop.isset(tabItemData.getRSSOwlBrowserPanel().getBrowser())) {
                        string = tabItemData.getRSSOwlBrowserPanel().getBrowser().getUrl();
                    }
                }
                dragSourceEvent.data = string + System.getProperty("line.separator") + string2;
            }

            @Override
            public void dragStart(DragSourceEvent dragSourceEvent) {
                CTabItem cTabItem = NewsTabFolderDND.this.getValidDragSourceTabItem();
                if (cTabItem != null) {
                    dragSourceEvent.doit = true;
                    NewsTabFolderDND.this.rssOwlFavoritesTreeDND.setDragSourceItem(cTabItem);
                } else {
                    dragSourceEvent.doit = false;
                }
            }
        });
    }

    private void createDropTarget() {
        this.target = new DropTarget(this.tabFolder, 2);
        this.target.setTransfer(types);
        this.target.addDropListener(new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetEvent dropTargetEvent) {
                Item item = NewsTabFolderDND.this.rssOwlFavoritesTreeDND.getDragSourceItem();
                if (!WidgetShop.isset(NewsTabFolderDND.this.tabFolder)) {
                    dropTargetEvent.detail = 0;
                    return;
                }
                if (!WidgetShop.isset(item) || !(item instanceof CTabItem)) {
                    dropTargetEvent.detail = 0;
                    return;
                }
                CTabItem cTabItem = NewsTabFolderDND.this.tabFolder.getItem(NewsTabFolderDND.this.tabFolder.toControl(new Point(dropTargetEvent.x, dropTargetEvent.y)));
                dropTargetEvent.detail = WidgetShop.isset(cTabItem) && cTabItem != item ? 2 : 0;
            }

            @Override
            public void drop(DropTargetEvent dropTargetEvent) {
                Item item = NewsTabFolderDND.this.rssOwlFavoritesTreeDND.getDragSourceItem();
                if (!WidgetShop.isset(NewsTabFolderDND.this.tabFolder)) {
                    dropTargetEvent.detail = 0;
                    return;
                }
                if (!WidgetShop.isset(item) || !(item instanceof CTabItem)) {
                    dropTargetEvent.detail = 0;
                    return;
                }
                CTabItem cTabItem = NewsTabFolderDND.this.tabFolder.getItem(NewsTabFolderDND.this.tabFolder.toControl(new Point(dropTargetEvent.x, dropTargetEvent.y)));
                if (WidgetShop.isset(cTabItem)) {
                    NewsTabFolderDND.this.move((CTabItem)item, cTabItem);
                }
            }
        });
    }

    private void initDragAndDrop() {
        this.createDragSource();
        this.createDropTarget();
    }

    CTabItem getValidDragSourceTabItem() {
        CTabItem cTabItem = this.tabFolder.getSelection();
        if (cTabItem == null) {
            return null;
        }
        return cTabItem;
    }

    void move(CTabItem cTabItem, CTabItem cTabItem2) {
        Object object;
        int n;
        int n2 = this.tabFolder.indexOf(cTabItem);
        int n3 = this.tabFolder.indexOf(cTabItem2);
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        ArrayList<CTabItem> arrayList = new ArrayList<CTabItem>();
        for (int i = 0; i < cTabItemArray.length; ++i) {
            arrayList.add(cTabItemArray[i]);
        }
        arrayList.remove(n2);
        arrayList.add(n3, cTabItem);
        String[] stringArray = new String[cTabItemArray.length];
        String[] stringArray2 = new String[cTabItemArray.length];
        Font[] fontArray = new Font[cTabItemArray.length];
        Image[] imageArray = new Image[cTabItemArray.length];
        Control[] controlArray = new Control[cTabItemArray.length];
        Object[] objectArray = new Object[cTabItemArray.length];
        for (n = 0; n < arrayList.size(); ++n) {
            object = (CTabItem)arrayList.get(n);
            stringArray[n] = ((Item)object).getText();
            stringArray2[n] = ((CTabItem)object).getToolTipText();
            fontArray[n] = ((CTabItem)object).getFont();
            imageArray[n] = ((Item)object).getImage();
            controlArray[n] = ((CTabItem)object).getControl();
            objectArray[n] = ((Widget)object).getData();
        }
        for (n = 0; n < cTabItemArray.length; ++n) {
            cTabItemArray[n].setText(stringArray[n]);
            cTabItemArray[n].setToolTipText(stringArray2[n]);
            cTabItemArray[n].setFont(fontArray[n]);
            cTabItemArray[n].setImage(imageArray[n]);
            cTabItemArray[n].setControl(controlArray[n]);
            cTabItemArray[n].setData(objectArray[n]);
            if (!(objectArray[n] instanceof TabItemData)) continue;
            object = (TabItemData)objectArray[n];
            if (((TabItemData)object).getNewsTable() != null) {
                ((TabItemData)object).getNewsTable().setTabItem(cTabItemArray[n]);
                continue;
            }
            if (((TabItemData)object).getRSSOwlBrowserPanel() == null) continue;
            if (WidgetShop.isset(((TabItemData)object).getRSSOwlBrowserPanel().getBrowser())) {
                ((TabItemData)object).getRSSOwlBrowserPanel().getBrowser().setData(cTabItemArray[n]);
            }
            ((TabItemData)object).getRSSOwlBrowserPanel().setTabItem(cTabItemArray[n]);
        }
        this.tabFolder.setSelection(cTabItem2);
    }
}

