/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.forms;

import java.util.Vector;
import net.sourceforge.rssowl.controller.forms.FormsResources;
import net.sourceforge.rssowl.controller.forms.HyperlinkEvent;
import net.sourceforge.rssowl.controller.forms.IHyperlinkListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractHyperlink
extends Canvas {
    boolean hasFocus;
    private Vector listeners;
    protected int marginWidth = 1;
    protected int marginHeight = 1;

    public AbstractHyperlink(Composite composite, int n) {
        super(composite, n);
        this.addListener(1, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    AbstractHyperlink.this.handleActivate(event);
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent paintEvent) {
                AbstractHyperlink.this.paint(paintEvent);
            }
        });
        this.addListener(31, new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        event.doit = false;
                        return;
                    }
                }
                event.doit = true;
            }
        });
        Listener listener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 15: {
                        AbstractHyperlink.this.hasFocus = true;
                        AbstractHyperlink.this.handleEnter(event);
                        break;
                    }
                    case 16: {
                        AbstractHyperlink.this.hasFocus = false;
                        AbstractHyperlink.this.handleExit(event);
                        break;
                    }
                    case 14: {
                        AbstractHyperlink.this.handleActivate(event);
                        break;
                    }
                    case 6: {
                        AbstractHyperlink.this.handleEnter(event);
                        break;
                    }
                    case 7: {
                        AbstractHyperlink.this.handleExit(event);
                        break;
                    }
                    case 4: {
                        AbstractHyperlink.this.handleMouseUp(event);
                    }
                }
            }
        };
        this.addListener(6, listener);
        this.addListener(7, listener);
        this.addListener(4, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
        this.setCursor(FormsResources.getHandCursor());
    }

    public void addHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(iHyperlinkListener)) {
            this.listeners.add(iHyperlinkListener);
        }
    }

    public void removeHyperlinkListener(IHyperlinkListener iHyperlinkListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(iHyperlinkListener);
    }

    public boolean getSelection() {
        return this.hasFocus;
    }

    protected void handleEnter(Event event) {
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, this.getHref(), this.getText(), event.stateMask);
        for (int i = 0; i < n; ++i) {
            IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)this.listeners.get(i);
            iHyperlinkListener.linkEntered(hyperlinkEvent);
        }
    }

    protected void handleExit(Event event) {
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, this.getHref(), this.getText(), event.stateMask);
        for (int i = 0; i < n; ++i) {
            IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)this.listeners.get(i);
            iHyperlinkListener.linkExited(hyperlinkEvent);
        }
    }

    protected void handleActivate(Event event) {
        this.getAccessible().setFocus(-1);
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        this.setCursor(FormsResources.getBusyCursor());
        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, this.getHref(), this.getText(), event.stateMask);
        for (int i = 0; i < n; ++i) {
            IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)this.listeners.get(i);
            iHyperlinkListener.linkActivated(hyperlinkEvent);
        }
        if (!this.isDisposed()) {
            this.setCursor(FormsResources.getHandCursor());
        }
    }

    public void setHref(Object object) {
        this.setData("href", object);
    }

    public Object getHref() {
        return this.getData("href");
    }

    public String getText() {
        return this.getToolTipText();
    }

    protected abstract void paintHyperlink(GC var1);

    protected void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Image image = new Image((Device)this.getDisplay(), rectangle.width, rectangle.height);
        image.setBackground(this.getBackground());
        GC gC2 = new GC(image, gC.getStyle());
        gC2.setBackground(this.getBackground());
        gC2.fillRectangle(0, 0, rectangle.width, rectangle.height);
        this.paintHyperlink(gC2);
        if (this.hasFocus) {
            Rectangle rectangle2 = this.getClientArea();
            gC2.setForeground(this.getForeground());
            gC2.drawFocus(0, 0, rectangle2.width, rectangle2.height);
        }
        gC.drawImage(image, 0, 0);
        gC2.dispose();
        image.dispose();
    }

    void handleMouseUp(Event event) {
        if (event.button != 1) {
            return;
        }
        Point point = this.getSize();
        if (event.x < 0) {
            return;
        }
        if (event.y < 0) {
            return;
        }
        if (event.x >= point.x) {
            return;
        }
        if (event.y >= point.y) {
            return;
        }
        this.handleActivate(event);
    }
}

