/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.panel;

import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.ViewForm;
import net.sourceforge.rssowl.controller.forms.Hyperlink;
import net.sourceforge.rssowl.controller.forms.HyperlinkAdapter;
import net.sourceforge.rssowl.controller.forms.HyperlinkEvent;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class WelcomePanel {
    private Color bannerColor;
    private Image bannerImage;
    private Display display;
    private ViewForm messageViewForm;
    private Composite parent;
    Image arrowHotImage;
    Image arrowImage;
    EventManager eventManager;

    public WelcomePanel(Display display, EventManager eventManager, Composite composite) {
        this.parent = composite;
        this.display = display;
        this.eventManager = eventManager;
        this.bannerImage = PaintShop.loadImage("/img/aboutbanner.png");
        this.arrowImage = PaintShop.loadImage("/img/arrow.gif");
        this.arrowHotImage = PaintShop.loadImage("/img/arrow_hot.gif");
        this.bannerColor = new Color(display, 216, 216, 216);
        this.initComponents();
    }

    public void dispose() {
        this.bannerColor.dispose();
        this.bannerImage.dispose();
        this.arrowImage.dispose();
        this.arrowHotImage.dispose();
    }

    public Composite getPanel() {
        return this.messageViewForm;
    }

    private void initComponents() {
        this.messageViewForm = new ViewForm(this.parent, 0x800800);
        this.messageViewForm.setBackground(this.bannerColor);
        this.messageViewForm.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                WelcomePanel.this.dispose();
            }
        });
        Composite composite = new Composite(this.messageViewForm, 0);
        composite.setLayout(LayoutShop.createGridLayout(1, 0));
        composite.setBackground(this.bannerColor);
        this.messageViewForm.setTopLeft(composite, false);
        Label label = new Label(composite, 0);
        label.setImage(this.bannerImage);
        label.setLayoutData(new GridData(0x1000000, 1, true, false));
        label.setCursor(this.display.getSystemCursor(21));
        label.setToolTipText(URLShop.RSSOWL_WEBPAGE);
        label.setBackground(this.bannerColor);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
                BrowserShop.openLink(URLShop.RSSOWL_WEBPAGE);
            }
        });
        Label label2 = new Label(composite, 0x1000000);
        label2.setText(GUI.i18n.getTranslation("LABEL_WELCOME_TITLE"));
        label2.setLayoutData(new GridData(0x1000000, 1, true, false));
        label2.setBackground(this.bannerColor);
        label2.setFont(FontShop.textBoldFont);
        Composite composite2 = new Composite(this.messageViewForm, 0);
        composite2.setLayout(new GridLayout(1, false));
        composite2.setBackground(this.display.getSystemColor(1));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout(LayoutShop.createGridLayout(3, 10, 10, -1, -1, true));
        composite3.setLayoutData(new GridData(0x1000000, 1, true, true));
        composite3.setBackground(this.display.getSystemColor(1));
        this.messageViewForm.setContent(composite2, true);
        Composite composite4 = new Composite(composite3, 0);
        composite4.setLayoutData(new GridData(66));
        composite4.setLayout(LayoutShop.createGridLayout(1, 0, 0, 1, 2, false));
        composite4.setBackground(this.display.getSystemColor(1));
        Composite composite5 = new Composite(composite4, 0);
        composite5.setLayoutData(new GridData(2));
        composite5.setLayout(LayoutShop.createGridLayout(1, 0, 10, 1));
        composite5.setBackground(this.display.getSystemColor(1));
        CLabel cLabel = new CLabel(composite5, 0);
        cLabel.setImage(PaintShop.iconMail);
        cLabel.setText(GUI.i18n.getTranslation("LABEL_FIRST_STEPS"));
        cLabel.setFont(FontShop.textBoldFont);
        cLabel.setLayoutData(new GridData(1, 1, true, false));
        cLabel.setBackground(this.display.getSystemColor(1));
        Composite composite6 = new Composite(composite5, 0);
        composite6.setLayout(LayoutShop.createGridLayout(1, 24, 0));
        composite6.setBackground(this.display.getSystemColor(1));
        Hyperlink hyperlink = new Hyperlink(composite6, 0);
        hyperlink.setUnderlined(true);
        hyperlink.setText(GUI.i18n.getTranslation("MENU_TUTORIAL"));
        hyperlink.setFont(FontShop.textFont);
        hyperlink.setForeground(this.display.getSystemColor(9));
        hyperlink.setBackground(this.display.getSystemColor(1));
        hyperlink.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                WelcomePanel.this.eventManager.actionOpenTutorial();
            }
        });
        Hyperlink hyperlink2 = new Hyperlink(composite6, 0);
        hyperlink2.setUnderlined(true);
        hyperlink2.setText("FAQ");
        hyperlink2.setFont(FontShop.textFont);
        hyperlink2.setForeground(this.display.getSystemColor(9));
        hyperlink2.setBackground(this.display.getSystemColor(1));
        hyperlink2.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                WelcomePanel.this.restoreView();
                WelcomePanel.this.eventManager.actionOpenFAQ();
            }
        });
        Composite composite7 = new Composite(composite4, 0);
        composite7.setLayoutData(new GridData(2));
        composite7.setLayout(LayoutShop.createGridLayout(1, 0, 10, 1));
        composite7.setBackground(this.display.getSystemColor(1));
        CLabel cLabel2 = new CLabel(composite7, 0);
        cLabel2.setImage(PaintShop.iconMail);
        cLabel2.setText(GUI.i18n.getTranslation("LABEL_NEWS"));
        cLabel2.setFont(FontShop.textBoldFont);
        cLabel2.setLayoutData(new GridData(1, 1, true, false));
        cLabel2.setBackground(this.display.getSystemColor(1));
        Composite composite8 = new Composite(composite7, 0);
        composite8.setLayout(LayoutShop.createGridLayout(1, 24, 0));
        composite8.setBackground(this.display.getSystemColor(1));
        Hyperlink hyperlink3 = new Hyperlink(composite8, 0);
        hyperlink3.setUnderlined(true);
        hyperlink3.setText(GUI.i18n.getTranslation("LABEL_RSSOWL_NEWSFEED"));
        hyperlink3.setFont(FontShop.textFont);
        hyperlink3.setToolTipText(URLShop.RSSOWL_FEED);
        hyperlink3.setForeground(this.display.getSystemColor(9));
        hyperlink3.setBackground(this.display.getSystemColor(1));
        hyperlink3.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                WelcomePanel.this.restoreView();
                WelcomePanel.this.eventManager.actionOpenFeed(URLShop.RSSOWL_FEED);
            }
        });
        Composite composite9 = new Composite(composite3, 0);
        composite9.setLayoutData(new GridData(66));
        composite9.setLayout(LayoutShop.createGridLayout(1, 0, 0, 1, 2, false));
        composite9.setBackground(this.display.getSystemColor(1));
        Composite composite10 = new Composite(composite9, 0);
        composite10.setLayoutData(new GridData(2));
        composite10.setLayout(LayoutShop.createGridLayout(1, 0, 10, 1));
        composite10.setBackground(this.display.getSystemColor(1));
        CLabel cLabel3 = new CLabel(composite10, 0);
        cLabel3.setImage(PaintShop.iconMail);
        cLabel3.setText(GUI.i18n.getTranslation("LABEL_SUPPORT"));
        cLabel3.setFont(FontShop.textBoldFont);
        cLabel3.setLayoutData(new GridData(1, 1, true, false));
        cLabel3.setBackground(this.display.getSystemColor(1));
        Composite composite11 = new Composite(composite10, 0);
        composite11.setLayout(LayoutShop.createGridLayout(1, 24, 0));
        composite11.setBackground(this.display.getSystemColor(1));
        Hyperlink hyperlink4 = new Hyperlink(composite11, 0);
        hyperlink4.setUnderlined(true);
        hyperlink4.setText(GUI.i18n.getTranslation("LABEL_DISCUSSION_FORUM"));
        hyperlink4.setFont(FontShop.textFont);
        hyperlink4.setToolTipText(URLShop.RSSOWL_FORUM);
        hyperlink4.setForeground(this.display.getSystemColor(9));
        hyperlink4.setBackground(this.display.getSystemColor(1));
        hyperlink4.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BrowserShop.openLink(URLShop.RSSOWL_FORUM);
            }
        });
        Hyperlink hyperlink5 = new Hyperlink(composite11, 0);
        hyperlink5.setUnderlined(true);
        hyperlink5.setText(GUI.i18n.getTranslation("MENU_MAILING_LIST"));
        hyperlink5.setFont(FontShop.textFont);
        hyperlink5.setToolTipText(URLShop.RSSOWL_LIST);
        hyperlink5.setForeground(this.display.getSystemColor(9));
        hyperlink5.setBackground(this.display.getSystemColor(1));
        hyperlink5.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BrowserShop.openLink(URLShop.RSSOWL_LIST);
            }
        });
        Composite composite12 = new Composite(composite9, 0);
        composite12.setLayoutData(new GridData(2));
        composite12.setLayout(LayoutShop.createGridLayout(1, 0, 10, 1));
        composite12.setBackground(this.display.getSystemColor(1));
        CLabel cLabel4 = new CLabel(composite12, 0);
        cLabel4.setImage(PaintShop.iconMail);
        cLabel4.setText(GUI.i18n.getTranslation("MENU_MISC"));
        cLabel4.setFont(FontShop.textBoldFont);
        cLabel4.setLayoutData(new GridData(1, 1, true, false));
        cLabel4.setBackground(this.display.getSystemColor(1));
        Composite composite13 = new Composite(composite12, 0);
        composite13.setLayout(LayoutShop.createGridLayout(1, 24, 0));
        composite13.setBackground(this.display.getSystemColor(1));
        Hyperlink hyperlink6 = new Hyperlink(composite13, 0);
        hyperlink6.setUnderlined(true);
        hyperlink6.setText(GUI.i18n.getTranslation("MENU_DONATE"));
        hyperlink6.setFont(FontShop.textFont);
        hyperlink6.setToolTipText(URLShop.RSSOWL_DONATE);
        hyperlink6.setForeground(this.display.getSystemColor(9));
        hyperlink6.setBackground(this.display.getSystemColor(1));
        hyperlink6.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BrowserShop.openLink(URLShop.RSSOWL_DONATE);
            }
        });
        Hyperlink hyperlink7 = new Hyperlink(composite13, 0);
        hyperlink7.setUnderlined(true);
        hyperlink7.setText(GUI.i18n.getTranslation("LABEL_PROMOTION"));
        hyperlink7.setFont(FontShop.textFont);
        hyperlink7.setToolTipText(URLShop.RSSOWL_PROMOTION);
        hyperlink7.setForeground(this.display.getSystemColor(9));
        hyperlink7.setBackground(this.display.getSystemColor(1));
        hyperlink7.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BrowserShop.openLink(URLShop.RSSOWL_PROMOTION);
            }
        });
        Composite composite14 = new Composite(composite3, 0);
        composite14.setLayoutData(new GridData(66));
        composite14.setLayout(LayoutShop.createGridLayout(1, 0, 0, 1, 2, false));
        composite14.setBackground(this.display.getSystemColor(1));
        Composite composite15 = new Composite(composite14, 0);
        composite15.setLayoutData(new GridData(2));
        composite15.setLayout(LayoutShop.createGridLayout(1, 0, 10, 1));
        composite15.setBackground(this.display.getSystemColor(1));
        CLabel cLabel5 = new CLabel(composite15, 0);
        cLabel5.setImage(PaintShop.iconMail);
        cLabel5.setText(GUI.i18n.getTranslation("LABEL_CONTACT"));
        cLabel5.setFont(FontShop.textBoldFont);
        cLabel5.setLayoutData(new GridData(1, 1, true, false));
        cLabel5.setBackground(this.display.getSystemColor(1));
        Composite composite16 = new Composite(composite15, 0);
        composite16.setLayout(LayoutShop.createGridLayout(1, 24, 0));
        composite16.setBackground(this.display.getSystemColor(1));
        Hyperlink hyperlink8 = new Hyperlink(composite16, 0);
        hyperlink8.setUnderlined(true);
        hyperlink8.setText("RSSOwl Team");
        hyperlink8.setToolTipText("contact@rssowl.org");
        hyperlink8.setFont(FontShop.textFont);
        hyperlink8.setForeground(this.display.getSystemColor(9));
        hyperlink8.setBackground(this.display.getSystemColor(1));
        hyperlink8.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BrowserShop.openLink(URLShop.RSSOWL_CONTACT);
            }
        });
        Hyperlink hyperlink9 = new Hyperlink(composite8, 0);
        hyperlink9.setUnderlined(true);
        hyperlink9.setText("RSSOwl.org");
        hyperlink9.setToolTipText(URLShop.RSSOWL_WEBPAGE);
        hyperlink9.setFont(FontShop.textFont);
        hyperlink9.setForeground(this.display.getSystemColor(9));
        hyperlink9.setBackground(this.display.getSystemColor(1));
        hyperlink9.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                BrowserShop.openLink(URLShop.RSSOWL_WEBPAGE);
            }
        });
        Composite composite17 = new Composite(composite3, 0);
        composite17.setLayoutData(new GridData(0x1000000, 1, true, false, 3, 1));
        composite17.setLayout(LayoutShop.createGridLayout(1, 0, 50));
        composite17.setBackground(this.display.getSystemColor(1));
        final Label label3 = new Label(composite17, 0);
        label3.setImage(this.arrowImage);
        label3.setLayoutData(new GridData(66));
        label3.setToolTipText(GUI.i18n.getTranslation("LABEL_START"));
        label3.setCursor(this.display.getSystemCursor(21));
        label3.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseEnter(MouseEvent mouseEvent) {
                if (WidgetShop.isset(label3) && PaintShop.isset(WelcomePanel.this.arrowHotImage)) {
                    label3.setImage(WelcomePanel.this.arrowHotImage);
                }
            }

            @Override
            public void mouseExit(MouseEvent mouseEvent) {
                if (WidgetShop.isset(label3) && PaintShop.isset(WelcomePanel.this.arrowImage)) {
                    label3.setImage(WelcomePanel.this.arrowImage);
                }
            }
        });
        label3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent mouseEvent) {
                WelcomePanel.this.eventManager.actionCloseCurrent();
            }
        });
    }

    void restoreView() {
        GUI.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setMaximized(false);
        GUI.rssOwlGui.setFavoritesMinimized(!GlobalSettings.isFavoritesTreeShown, false);
        GUI.rssOwlGui.getRSSOwlQuickview().setShowQuickview(GlobalSettings.isQuickviewShown, false);
        GUI.rssOwlGui.getRSSOwlQuickview().setShowToolBar(GlobalSettings.isToolBarShown, false);
    }
}

