/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.popup;

import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.TreeItemData;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class BlogrollCategoryPopup {
    private Menu popUpMenu;
    private Shell shell;
    EventManager eventManager;
    GUI rssOwlGui;
    TreeItem selectedTreeItem;

    public BlogrollCategoryPopup(Shell shell, GUI gUI, Menu menu, EventManager eventManager, TreeItem treeItem) {
        this.shell = shell;
        this.rssOwlGui = gUI;
        this.popUpMenu = menu;
        this.eventManager = eventManager;
        this.selectedTreeItem = treeItem;
        this.initBlogrollCategoryMenu();
    }

    private void initBlogrollCategoryMenu() {
        MenuItem menuItem;
        MenuItem menuItem2;
        Widget widget;
        Object object;
        TreeItem treeItem;
        int n;
        Object object2;
        MenuItem menuItem3;
        MenuItem menuItem4 = new MenuItem(this.popUpMenu, 8);
        menuItem4.setText(GUI.i18n.getTranslation("POP_AGGREGATE_FAV"));
        menuItem4.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionAggregateCategory(false);
            }
        });
        if (this.selectedTreeItem.getItemCount() <= 0) {
            menuItem4.setEnabled(false);
        }
        if (!GlobalSettings.displaySingleTab) {
            boolean bl = false;
            menuItem3 = new MenuItem(this.popUpMenu, 8);
            menuItem3.setText(GUI.i18n.getTranslation("BUTTON_OPEN"));
            menuItem3.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    BlogrollCategoryPopup.this.eventManager.actionOpenSelectedCategory();
                }
            });
            object2 = this.selectedTreeItem.getItems();
            for (n = 0; n < ((TreeItem[])object2).length; ++n) {
                treeItem = object2[n];
                if (treeItem.getData() == null || !((TreeItemData)treeItem.getData()).isBlogrollFavorite()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                menuItem3.setEnabled(false);
            }
        }
        new MenuItem(this.popUpMenu, 2);
        MenuItem menuItem5 = new MenuItem(this.popUpMenu, 8);
        menuItem5.setText(GUI.i18n.getTranslation("POP_MARK_CATEGORY_READ"));
        menuItem5.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionMarkCategoryRead();
            }
        });
        if (this.selectedTreeItem.getItemCount() <= 0) {
            menuItem5.setEnabled(false);
        }
        new MenuItem(this.popUpMenu, 2);
        menuItem3 = new MenuItem(this.popUpMenu, 8);
        menuItem3.setText(GUI.i18n.getTranslation("BUTTON_RELOAD_CAT"));
        if (!GlobalSettings.isMac()) {
            menuItem3.setImage(PaintShop.iconReload);
        }
        menuItem3.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionAggregateCategory(true);
            }
        });
        if (this.selectedTreeItem.getItemCount() <= 0) {
            menuItem3.setEnabled(false);
        }
        new MenuItem(this.popUpMenu, 2);
        object2 = new MenuItem(this.popUpMenu, 8);
        ((MenuItem)object2).setText(GUI.i18n.getTranslation("SEARCH_DIALOG_TITLE") + "...");
        if (!GlobalSettings.isMac()) {
            ((MenuItem)object2).setImage(PaintShop.iconFind);
        }
        ((MenuItem)object2).addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionSearchInCategory();
            }
        });
        if (this.selectedTreeItem.getItemCount() <= 0) {
            ((MenuItem)object2).setEnabled(false);
        }
        new MenuItem(this.popUpMenu, 2);
        n = 1;
        treeItem = this.selectedTreeItem.getParentItem();
        if (WidgetShop.isset(treeItem) && treeItem.getData() != null && ((TreeItemData)(object = (TreeItemData)treeItem.getData())).isBlogroll()) {
            n = 0;
        }
        if (n != 0) {
            object = new MenuItem(this.popUpMenu, 64);
            ((MenuItem)object).setText(GUI.i18n.getTranslation("POP_NEW"));
            widget = new Menu(this.shell, 4);
            ((MenuItem)object).setMenu((Menu)widget);
            if (!GlobalSettings.isMac()) {
                ((MenuItem)object).setImage(PaintShop.iconNew);
            }
            menuItem2 = new MenuItem((Menu)widget, 8);
            menuItem2.setText(GUI.i18n.getTranslation("LABEL_CATEGORY") + "...");
            if (!GlobalSettings.isMac()) {
                menuItem2.setImage(PaintShop.iconAddCategory);
            }
            menuItem2.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    BlogrollCategoryPopup.this.eventManager.actionNewCategory(false);
                }
            });
        }
        object = new MenuItem(this.popUpMenu, 8);
        ((MenuItem)object).setText(GUI.i18n.getTranslation("POP_SYNCHRONIZE"));
        ((MenuItem)object).addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionSynchronizeBlogroll();
            }
        });
        widget = new MenuItem(this.popUpMenu, 8);
        ((MenuItem)widget).setText(GUI.i18n.getTranslation("POP_UNSUBSCRIBE"));
        if (!GlobalSettings.isMac()) {
            ((MenuItem)widget).setImage(PaintShop.iconDelete);
        }
        ((MenuItem)widget).addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionDeleteBlogroll();
            }
        });
        new MenuItem(this.popUpMenu, 2);
        menuItem2 = new MenuItem(this.popUpMenu, 8);
        menuItem2.setText(GUI.i18n.getTranslation("POP_COPY_NEWS_URL"));
        menuItem2.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionCopyBlogrollXmlLocation();
            }
        });
        new MenuItem(this.popUpMenu, 2);
        MenuItem menuItem6 = new MenuItem(this.popUpMenu, 64);
        menuItem6.setText(GUI.i18n.getTranslation("POP_IMPORT"));
        if (!GlobalSettings.isMac()) {
            menuItem6.setImage(PaintShop.iconImport);
        }
        Menu menu = new Menu(this.shell, 4);
        menuItem6.setMenu(menu);
        MenuItem menuItem7 = new MenuItem(menu, 8);
        menuItem7.setText(GUI.i18n.getTranslation("POP_FROM_OPML") + "...");
        if (!GlobalSettings.isMac()) {
            menuItem7.setImage(PaintShop.iconImportOpml);
        }
        menuItem7.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionImportOPML();
            }
        });
        MenuItem menuItem8 = new MenuItem(menu, 8);
        menuItem8.setText(GUI.i18n.getTranslation("POP_IMPORT_BLOGROLL") + "...");
        if (!GlobalSettings.isMac()) {
            menuItem8.setImage(PaintShop.iconAddBlogroll);
        }
        menuItem8.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionImportBlogroll();
            }
        });
        MenuItem menuItem9 = new MenuItem(this.popUpMenu, 64);
        menuItem9.setText(GUI.i18n.getTranslation("BUTTON_EXPORT"));
        if (!GlobalSettings.isMac()) {
            menuItem9.setImage(PaintShop.iconExport);
        }
        if (this.selectedTreeItem.getItemCount() <= 0) {
            menuItem9.setEnabled(false);
        }
        Menu menu2 = new Menu(this.shell, 4);
        menuItem9.setMenu(menu2);
        MenuItem menuItem10 = new MenuItem(menu2, 8);
        menuItem10.setText(GUI.i18n.getTranslation("POP_EXPORT_OPML") + "...");
        if (!GlobalSettings.isMac()) {
            menuItem10.setImage(PaintShop.iconExportOpml);
        }
        menuItem10.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionCategoryToOPML();
            }
        });
        if (ProxyShop.isUseProxy()) {
            new MenuItem(this.popUpMenu, 2);
            menuItem = new MenuItem(this.popUpMenu, 64);
            menuItem.setText(GUI.i18n.getTranslation("MENU_PROXY"));
            Menu menu3 = new Menu(this.shell, 4);
            menuItem.setMenu(menu3);
            final MenuItem menuItem11 = new MenuItem(menu3, 32);
            menuItem11.setText(GUI.i18n.getTranslation("POP_USEPROXY"));
            menuItem11.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (menuItem11.isEnabled()) {
                        BlogrollCategoryPopup.this.eventManager.actionSetProxyOnTreeItem(menuItem11.getSelection());
                    }
                }
            });
            menu3.addMenuListener(new MenuAdapter(){

                @Override
                public void menuShown(MenuEvent menuEvent) {
                    Category category = BlogrollCategoryPopup.this.rssOwlGui.getRSSOwlFavoritesTree().getSelectedCat();
                    if (category != null) {
                        menuItem11.setSelection(category.isUseProxy());
                    }
                }
            });
        }
        new MenuItem(this.popUpMenu, 2);
        menuItem = new MenuItem(this.popUpMenu, 8);
        menuItem.setText(GUI.i18n.getTranslation("POP_PROPERTIES"));
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                BlogrollCategoryPopup.this.eventManager.actionEditBlogroll();
            }
        });
    }
}

