/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.popup;

import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.TreeItemData;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class CategoryPopup {
    private Menu popUpMenu;
    private Shell shell;
    EventManager eventManager;
    GUI rssOwlGui;
    TreeItem selectedTreeItem;

    public CategoryPopup(Shell shell, GUI gUI, Menu menu, EventManager eventManager, TreeItem treeItem) {
        this.shell = shell;
        this.rssOwlGui = gUI;
        this.popUpMenu = menu;
        this.eventManager = eventManager;
        this.selectedTreeItem = treeItem;
        this.initCatMenu();
    }

    private void initCatMenu() {
        MenuItem menuItem;
        Widget widget;
        Object object;
        MenuItem menuItem2;
        MenuItem menuItem3 = new MenuItem(this.popUpMenu, 8);
        menuItem3.setText(GUI.i18n.getTranslation("POP_AGGREGATE_FAV"));
        menuItem3.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionAggregateCategory(false);
            }
        });
        if (this.selectedTreeItem.getItemCount() <= 0) {
            menuItem3.setEnabled(false);
        }
        if (!GlobalSettings.displaySingleTab) {
            boolean bl = false;
            menuItem2 = new MenuItem(this.popUpMenu, 8);
            menuItem2.setText(GUI.i18n.getTranslation("BUTTON_OPEN"));
            menuItem2.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    CategoryPopup.this.eventManager.actionOpenSelectedCategory();
                }
            });
            object = this.selectedTreeItem.getItems();
            for (int i = 0; i < ((TreeItem[])object).length; ++i) {
                widget = object[i];
                if (widget.getData() == null || !((TreeItemData)widget.getData()).isFavorite()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                menuItem2.setEnabled(false);
            }
        }
        new MenuItem(this.popUpMenu, 2);
        MenuItem menuItem4 = new MenuItem(this.popUpMenu, 8);
        menuItem4.setText(GUI.i18n.getTranslation("POP_MARK_CATEGORY_READ"));
        menuItem4.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionMarkCategoryRead();
            }
        });
        if (this.selectedTreeItem.getItemCount() <= 0) {
            menuItem4.setEnabled(false);
        }
        new MenuItem(this.popUpMenu, 2);
        menuItem2 = new MenuItem(this.popUpMenu, 8);
        menuItem2.setText(GUI.i18n.getTranslation("BUTTON_RELOAD_CAT"));
        if (!GlobalSettings.isMac()) {
            menuItem2.setImage(PaintShop.iconReload);
        }
        menuItem2.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionAggregateCategory(true);
            }
        });
        if (this.selectedTreeItem.getItemCount() <= 0) {
            menuItem2.setEnabled(false);
        }
        new MenuItem(this.popUpMenu, 2);
        object = new MenuItem(this.popUpMenu, 8);
        ((MenuItem)object).setText(GUI.i18n.getTranslation("SEARCH_DIALOG_TITLE") + "...");
        if (!GlobalSettings.isMac()) {
            ((MenuItem)object).setImage(PaintShop.iconFind);
        }
        ((MenuItem)object).addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionSearchInCategory();
            }
        });
        if (this.selectedTreeItem.getItemCount() <= 0) {
            ((MenuItem)object).setEnabled(false);
        }
        new MenuItem(this.popUpMenu, 2);
        MenuItem menuItem5 = new MenuItem(this.popUpMenu, 64);
        menuItem5.setText(GUI.i18n.getTranslation("POP_NEW"));
        if (!GlobalSettings.isMac()) {
            menuItem5.setImage(PaintShop.iconNew);
        }
        widget = new Menu(this.shell, 4);
        menuItem5.setMenu((Menu)widget);
        MenuItem menuItem6 = new MenuItem((Menu)widget, 8);
        menuItem6.setText(GUI.i18n.getTranslation("LABEL_FAVORITE") + "...");
        if (!GlobalSettings.isMac()) {
            menuItem6.setImage(PaintShop.iconAddToFavorites);
        }
        menuItem6.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionNewFavorite();
            }
        });
        new MenuItem((Menu)widget, 2);
        MenuItem menuItem7 = new MenuItem((Menu)widget, 8);
        menuItem7.setText(GUI.i18n.getTranslation("LABEL_CATEGORY") + "...");
        if (!GlobalSettings.isMac()) {
            menuItem7.setImage(PaintShop.iconAddCategory);
        }
        menuItem7.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionNewCategory(false);
            }
        });
        MenuItem menuItem8 = new MenuItem((Menu)widget, 8);
        menuItem8.setText(GUI.i18n.getTranslation("POP_SUB_CATEGORY") + "...");
        if (!GlobalSettings.isMac()) {
            menuItem8.setImage(PaintShop.iconSubCategory);
        }
        menuItem8.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionNewCategory(true);
            }
        });
        MenuItem menuItem9 = new MenuItem(this.popUpMenu, 8);
        menuItem9.setText(GUI.i18n.getTranslation("MENU_EDIT_RENAME"));
        menuItem9.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionRenameSelectedItem();
            }
        });
        MenuItem menuItem10 = new MenuItem(this.popUpMenu, 8);
        menuItem10.setText(GUI.i18n.getTranslation("MENU_EDIT_DELETE"));
        if (!GlobalSettings.isMac()) {
            menuItem10.setImage(PaintShop.iconDelete);
        }
        menuItem10.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionDeleteCategory();
            }
        });
        new MenuItem(this.popUpMenu, 2);
        MenuItem menuItem11 = new MenuItem(this.popUpMenu, 64);
        menuItem11.setText(GUI.i18n.getTranslation("POP_IMPORT"));
        if (!GlobalSettings.isMac()) {
            menuItem11.setImage(PaintShop.iconImport);
        }
        Menu menu = new Menu(this.shell, 4);
        menuItem11.setMenu(menu);
        MenuItem menuItem12 = new MenuItem(menu, 8);
        menuItem12.setText(GUI.i18n.getTranslation("POP_FROM_OPML") + "...");
        if (!GlobalSettings.isMac()) {
            menuItem12.setImage(PaintShop.iconImportOpml);
        }
        menuItem12.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionImportOPML();
            }
        });
        MenuItem menuItem13 = new MenuItem(menu, 8);
        menuItem13.setText(GUI.i18n.getTranslation("POP_IMPORT_BLOGROLL") + "...");
        if (!GlobalSettings.isMac()) {
            menuItem13.setImage(PaintShop.iconAddBlogroll);
        }
        menuItem13.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionImportBlogroll();
            }
        });
        MenuItem menuItem14 = new MenuItem(this.popUpMenu, 64);
        menuItem14.setText(GUI.i18n.getTranslation("BUTTON_EXPORT"));
        if (!GlobalSettings.isMac()) {
            menuItem14.setImage(PaintShop.iconExport);
        }
        if (this.selectedTreeItem.getItemCount() <= 0) {
            menuItem14.setEnabled(false);
        }
        Menu menu2 = new Menu(this.shell, 4);
        menuItem14.setMenu(menu2);
        MenuItem menuItem15 = new MenuItem(menu2, 8);
        menuItem15.setText(GUI.i18n.getTranslation("POP_EXPORT_OPML") + "...");
        if (!GlobalSettings.isMac()) {
            menuItem15.setImage(PaintShop.iconExportOpml);
        }
        menuItem15.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionCategoryToOPML();
            }
        });
        if (ProxyShop.isUseProxy()) {
            new MenuItem(this.popUpMenu, 2);
            menuItem = new MenuItem(this.popUpMenu, 64);
            menuItem.setText(GUI.i18n.getTranslation("MENU_PROXY"));
            Menu menu3 = new Menu(this.shell, 4);
            menuItem.setMenu(menu3);
            final MenuItem menuItem16 = new MenuItem(menu3, 32);
            menuItem16.setText(GUI.i18n.getTranslation("POP_USEPROXY"));
            menuItem16.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (menuItem16.isEnabled()) {
                        CategoryPopup.this.eventManager.actionSetProxyOnTreeItem(menuItem16.getSelection());
                    }
                }
            });
            menu3.addMenuListener(new MenuAdapter(){

                @Override
                public void menuShown(MenuEvent menuEvent) {
                    Category category = CategoryPopup.this.rssOwlGui.getRSSOwlFavoritesTree().getSelectedCat();
                    if (category != null) {
                        menuItem16.setSelection(category.isUseProxy());
                    }
                }
            });
        }
        new MenuItem(this.popUpMenu, 2);
        menuItem = new MenuItem(this.popUpMenu, 8);
        menuItem.setText(GUI.i18n.getTranslation("POP_PROPERTIES"));
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                CategoryPopup.this.eventManager.actionEditCategory();
            }
        });
    }
}

