/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.popup;

import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.FavoritesTree;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.popup.BlogrollCategoryPopup;
import net.sourceforge.rssowl.controller.popup.BlogrollFavoritePopup;
import net.sourceforge.rssowl.controller.popup.CategoryPopup;
import net.sourceforge.rssowl.controller.popup.EmptyTreePopup;
import net.sourceforge.rssowl.controller.popup.FavoritePopup;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class FavoritesTreePopup {
    public static final int BLOGROLL_CAT_MENU = 3;
    public static final int BLOGROLL_FAV_MENU = 4;
    public static final int CAT_MENU = 1;
    public static final int EMPTY_TREE_MENU = 5;
    public static final int FAV_MENU = 2;
    private int currentMenu;
    private EventManager eventManager;
    private boolean requiresUpdate;
    private Menu treePopUpMenu;
    FavoritesTree rssOwlFavoritesTree;
    GUI rssOwlGui;
    Shell shell;

    public FavoritesTreePopup(Shell shell, FavoritesTree favoritesTree, GUI gUI, EventManager eventManager) {
        this.shell = shell;
        this.rssOwlFavoritesTree = favoritesTree;
        this.rssOwlGui = gUI;
        this.eventManager = eventManager;
        this.currentMenu = -1;
        this.requiresUpdate = false;
        this.initComponents();
    }

    public Menu getTreePopUpMenu() {
        return this.treePopUpMenu;
    }

    public void setRequiresUpdate() {
        this.requiresUpdate = true;
    }

    public boolean updateMenu(int n, TreeItem treeItem) {
        if (n == this.currentMenu && n != 3 && n != 1 && !this.requiresUpdate) {
            return false;
        }
        if (n != -1) {
            this.resetPopup();
        }
        this.currentMenu = n;
        this.requiresUpdate = false;
        switch (n) {
            case 1: {
                new CategoryPopup(this.shell, this.rssOwlGui, this.treePopUpMenu, this.eventManager, treeItem);
                break;
            }
            case 2: {
                new FavoritePopup(this.shell, this.treePopUpMenu, this.eventManager);
                break;
            }
            case 3: {
                new BlogrollCategoryPopup(this.shell, this.rssOwlGui, this.treePopUpMenu, this.eventManager, treeItem);
                break;
            }
            case 4: {
                new BlogrollFavoritePopup(this.shell, this.treePopUpMenu, this.eventManager);
                break;
            }
            case 5: {
                new EmptyTreePopup(this.shell, this.treePopUpMenu, this.eventManager);
            }
        }
        this.rssOwlFavoritesTree.getFavoritesTree().setMenu(this.treePopUpMenu);
        return true;
    }

    private void initComponents() {
        this.treePopUpMenu = new Menu(this.shell, 8);
    }

    private void resetPopup() {
        MenuItem[] menuItemArray = this.treePopUpMenu.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.dispose();
        }
    }
}

