/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class BloggerProperties
extends PropertyPage {
    Text bloggerArguments;
    Text bloggerPath;

    public BloggerProperties(Composite composite) {
        super(composite);
        this.setRestoreButtonState(false);
    }

    @Override
    public void applyButtonPressed() {
        GlobalSettings.bloggerArguments = this.bloggerArguments.getText();
        GlobalSettings.bloggerPath = this.bloggerPath.getText();
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        propertyChangeManager.setBloggerArguments(this.bloggerArguments.getText());
        propertyChangeManager.setBloggerPath(this.bloggerPath.getText());
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group.setText(GUI.i18n.getTranslation("LABEL_SELECT_BLOGGER"));
        group.setLayout(new GridLayout(2, false));
        group.setFont(FontShop.dialogFont);
        Label label = new Label(group, 64);
        label.setText(GUI.i18n.getTranslation("DIALOG_SELECT_EXTERNAL_BROWSER") + ": ");
        label.setLayoutData(LayoutDataShop.createGridData(768, 2));
        label.setFont(this.dialogFont);
        this.bloggerPath = new Text(group, 2052);
        this.bloggerPath.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.bloggerPath.setFont(this.dialogFont);
        this.bloggerPath.setText(propertyChangeManager.getBloggerPath());
        this.bloggerPath.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                BloggerProperties.this.bloggerArguments.setEnabled(!BloggerProperties.this.bloggerPath.getText().equals(""));
                if (StringShop.isset(BloggerProperties.this.bloggerPath.getText())) {
                    BloggerProperties.this.setErrorMessage(FileShop.exists(BloggerProperties.this.bloggerPath.getText()) ? null : GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND"));
                } else {
                    BloggerProperties.this.setErrorMessage(null);
                }
            }
        });
        WidgetShop.tweakTextWidget(this.bloggerPath);
        Button button = new Button(group, 8);
        button.setText(GUI.i18n.getTranslation("BUTTON_SEARCH") + "...");
        button.setFont(this.dialogFont);
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = FileShop.getFilePath(BloggerProperties.this.composite.getShell(), null, null, 4096, BloggerProperties.this.bloggerPath.getText(), GUI.i18n.getTranslation("MENU_BLOGGER"));
                if (string != null) {
                    BloggerProperties.this.bloggerPath.setText(string);
                }
            }
        });
        this.setButtonLayoutData(button);
        this.errorMessageLabel = new CLabel(group, 0);
        this.errorMessageLabel.setFont(this.dialogFont);
        this.errorMessageLabel.setLayoutData(new GridData(1, 0x1000000, false, false));
        if (StringShop.isset(this.bloggerPath.getText())) {
            this.setErrorMessage(FileShop.exists(this.bloggerPath.getText()) ? null : GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND"));
        }
        Group group2 = new Group(this.composite, 0);
        group2.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group2.setText(GUI.i18n.getTranslation("GROUP_ARGUMENTS"));
        group2.setLayout(new GridLayout(2, false));
        group2.setFont(FontShop.dialogFont);
        this.bloggerArguments = new Text(group2, 2052);
        this.bloggerArguments.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.bloggerArguments.setFont(this.dialogFont);
        this.bloggerArguments.setText(propertyChangeManager.getBloggerArguments());
        WidgetShop.tweakTextWidget(this.bloggerArguments);
        this.bloggerArguments.setEnabled(!this.bloggerPath.getText().equals(""));
        WidgetShop.createWildCardMenu(this.bloggerArguments, new String[]{"[NEWSLINK]", "[FEEDLINK]", "[TITLE]", "[AUTHOR]", "[CATEGORY]", "[DESCRIPTION]", "[PUBDATE]", "[PUBLISHER]", "[SOURCE]"});
        Label label2 = new Label(group2, 64);
        label2.setText(GUI.i18n.getTranslation("LABEL_BLOGGER_USAGE"));
        label2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        label2.setFont(this.dialogFont);
        LayoutShop.setDialogSpacer(this.composite, 2, 3);
        WidgetShop.initMnemonics(new Button[]{button});
    }

    @Override
    protected void restoreButtonPressed() {
    }
}

