/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import java.io.IOException;
import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.dialog.FavoriteDialog;
import net.sourceforge.rssowl.controller.dialog.SelectCategoryDialog;
import net.sourceforge.rssowl.controller.properties.FavoritePropertyPage;
import net.sourceforge.rssowl.controller.thread.FeedAutoUpdater;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class EditFavoriteProperties
extends FavoritePropertyPage {
    private Composite errorContainer;
    private Label errorIconLabel;
    private Label errorMessageLabel;
    private Group generalGroup;
    private ToolItem grabTitleButton;
    private boolean isEdit;
    Text inputCategory;
    Text inputTitle;
    Text inputUrl;

    public EditFavoriteProperties(Composite composite, Favorite favorite) {
        super(composite, favorite);
    }

    public Favorite getUpdatedFavorite() {
        Favorite favorite = new Favorite(this.inputUrl.getText(), this.inputTitle.getText(), null);
        this.rssOwlFavorite.clone(favorite);
        favorite.setCatPath((String)this.inputCategory.getData());
        return favorite;
    }

    public void setMessage(String string, boolean bl) {
        this.errorIconLabel.setImage(string == null ? null : (bl ? PaintShop.iconError : PaintShop.iconWarning));
        this.errorIconLabel.redraw();
        this.errorIconLabel.update();
        this.errorMessageLabel.setText(string == null ? "" : string);
    }

    @Override
    protected void initComponents() {
        Object object;
        Object object2;
        Object object3;
        this.isEdit = FavoriteDialog.isEditFavorite;
        this.generalGroup = new Group(this.composite, 0);
        this.generalGroup.setLayoutData(LayoutDataShop.createGridData(770, 2));
        this.generalGroup.setText(GUI.i18n.getTranslation("GROUP_GENERAL"));
        this.generalGroup.setLayout(new GridLayout(3, false));
        this.generalGroup.setFont(FontShop.dialogFont);
        Label label = new Label(this.generalGroup, 0);
        label.setText(GUI.i18n.getTranslation("LABEL_URL_PATH") + ": ");
        label.setLayoutData(LayoutDataShop.createGridData(32, 1));
        label.setFont(this.dialogFont);
        this.inputUrl = new Text(this.generalGroup, 2052);
        this.inputUrl.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.inputUrl.setFont(this.dialogFont);
        this.inputUrl.setText(this.rssOwlFavorite.getUrl());
        this.inputUrl.setFocus();
        if (this.isEdit) {
            this.inputUrl.selectAll();
        } else if (!StringShop.isset(this.rssOwlFavorite.getUrl())) {
            object3 = GUI.rssOwlGui.getEventManager().getClipBoard();
            object = (String)((Clipboard)object3).getContents((Transfer)(object2 = TextTransfer.getInstance()));
            Object object4 = object = object != null ? ((String)object).trim() : null;
            if (StringShop.isset((String)object) && !Category.linkExists((String)object) && RegExShop.isValidURL((String)(object = StringShop.replaceAll((String)object, "feed://", "http://")))) {
                this.inputUrl.setText((String)object);
                this.inputUrl.selectAll();
            }
        }
        WidgetShop.tweakTextWidget(this.inputUrl);
        this.inputUrl.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                EditFavoriteProperties.this.validateInput();
            }
        });
        object3 = new Label(this.generalGroup, 0);
        ((Label)object3).setText(GUI.i18n.getTranslation("LABEL_TITLE") + ": ");
        ((Control)object3).setLayoutData(LayoutDataShop.createGridData(32, 1));
        ((Control)object3).setFont(this.dialogFont);
        object2 = new Composite(this.generalGroup, 0);
        ((Control)object2).setLayoutData(LayoutDataShop.createGridData(768, 2));
        ((Composite)object2).setLayout(LayoutShop.createGridLayout(2, 0, 0));
        this.inputTitle = new Text((Composite)object2, 2052);
        this.inputTitle.setLayoutData(LayoutDataShop.createGridData(768, 1));
        this.inputTitle.setFont(this.dialogFont);
        this.inputTitle.setText(this.rssOwlFavorite.getTitle());
        WidgetShop.tweakTextWidget(this.inputTitle);
        this.inputTitle.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent modifyEvent) {
                EditFavoriteProperties.this.validateInput();
            }
        });
        object = new ToolBar((Composite)object2, 0x800000);
        ((Control)object).setLayoutData(new GridData(128));
        this.grabTitleButton = new ToolItem((ToolBar)object, 8);
        this.grabTitleButton.setImage(PaintShop.loadImage("/img/icons/grab_title.gif"));
        this.grabTitleButton.addDisposeListener(DisposeListenerImpl.getInstance());
        this.grabTitleButton.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_GRAB_TITLE"));
        this.grabTitleButton.addSelectionListener(new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EditFavoriteProperties.this.inputUrl.getText().equals("")) {
                    return;
                }
                EditFavoriteProperties.this.setMessage(null, false);
                try {
                    EditFavoriteProperties.this.composite.getShell().setCursor(GUI.display.getSystemCursor(1));
                    String string = XMLShop.getTitleFromFeed(EditFavoriteProperties.this.inputUrl.getText(), EditFavoriteProperties.this.rssOwlFavorite.isUseProxy());
                    if (string.equals("")) {
                        EditFavoriteProperties.this.setMessage(GUI.i18n.getTranslation("ERROR_GRABTITLE_FAILED"), true);
                    } else {
                        EditFavoriteProperties.this.inputTitle.setText(string);
                        EditFavoriteProperties.this.inputTitle.setFocus();
                        EditFavoriteProperties.this.inputTitle.selectAll();
                    }
                }
                catch (IOException iOException) {
                    EditFavoriteProperties.this.setMessage(GUI.i18n.getTranslation("ERROR_CONNECTION_FAILED"), true);
                }
                finally {
                    EditFavoriteProperties.this.composite.getShell().setCursor(null);
                }
            }
        });
        Label label2 = new Label(this.generalGroup, 0);
        label2.setText(GUI.i18n.getTranslation("LABEL_CATEGORY") + ": ");
        label2.setLayoutData(LayoutDataShop.createGridData(32, 1));
        label2.setFont(this.dialogFont);
        Composite composite = new Composite(this.generalGroup, 0);
        composite.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite.setLayout(LayoutShop.createGridLayout(2, 0, 0));
        this.inputCategory = new Text(composite, 2056);
        this.inputCategory.setLayoutData(LayoutDataShop.createGridData(768, 1));
        this.inputCategory.setFont(this.dialogFont);
        this.inputCategory.setText(this.rssOwlFavorite.getCatPath().replaceAll("=;=", " | "));
        this.inputCategory.setData(this.rssOwlFavorite.getCatPath());
        Button button = new Button(composite, 0);
        button.setFont(this.dialogFont);
        button.setText(GUI.i18n.getTranslation("BUTTON_CHANGE") + "...");
        button.setLayoutData(new GridData(128));
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectCategoryDialog selectCategoryDialog = new SelectCategoryDialog(EditFavoriteProperties.this.parent.getShell(), GUI.i18n.getTranslation("DIALOG_TITLE_CATEGORY"));
                selectCategoryDialog.setCatPath((String)EditFavoriteProperties.this.inputCategory.getData());
                if (selectCategoryDialog.open() == 0) {
                    EditFavoriteProperties.this.inputCategory.setText(selectCategoryDialog.getCatPath() != null ? selectCategoryDialog.getCatPath().replaceAll("=;=", " | ") : "");
                    EditFavoriteProperties.this.inputCategory.setData(selectCategoryDialog.getCatPath() != null ? selectCategoryDialog.getCatPath() : "");
                    EditFavoriteProperties.this.setMessage(null, false);
                }
            }
        });
        this.errorContainer = new Composite(this.generalGroup, 0);
        this.errorContainer.setLayoutData(new GridData(4, 1, true, false, 3, 1));
        this.errorContainer.setLayout(LayoutShop.createGridLayout(2, 0, 0));
        this.errorIconLabel = new Label(this.errorContainer, 0);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        this.errorIconLabel.setLayoutData(gridData);
        this.errorMessageLabel = new Label(this.errorContainer, 0);
        this.errorMessageLabel.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.errorMessageLabel.setFont(FontShop.dialogFont);
        Composite composite2 = new Composite(this.composite, 0);
        composite2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        composite2.setLayout(LayoutShop.createGridLayout(2, 0, 0, 5, 15, false));
        Group group = new Group(composite2, 0);
        group.setLayoutData(LayoutDataShop.createGridData(1072, 1));
        group.setText(GUI.i18n.getTranslation("POP_AUTO_UPDATE"));
        group.setLayout(LayoutShop.createGridLayout(1, 5, 5, 15, 0, false));
        group.setFont(FontShop.dialogFont);
        final Combo combo = new Combo(group, 8);
        combo.setFont(FontShop.dialogFont);
        combo.setVisibleItemCount(FeedAutoUpdater.updateInterval.length);
        combo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                EditFavoriteProperties.this.rssOwlFavorite.setUpdateInterval(FeedAutoUpdater.updateInterval[combo.getSelectionIndex()]);
            }
        });
        int n = 0;
        for (int i = 0; i < FeedAutoUpdater.updateInterval.length; ++i) {
            combo.add(GUI.i18n.getTranslation(FeedAutoUpdater.updateIntervalNames[i]));
            if (FeedAutoUpdater.updateInterval[i] != this.rssOwlFavorite.getUpdateInterval()) continue;
            n = i;
        }
        combo.select(n);
        final Button button2 = new Button(group, 32);
        button2.setText(GUI.i18n.getTranslation("POP_UPDATE_ONSTARTUP"));
        button2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        button2.setFont(this.dialogFont);
        button2.setSelection(this.rssOwlFavorite.isLoadOnStartup());
        button2.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                EditFavoriteProperties.this.rssOwlFavorite.setLoadOnStartup(button2.getSelection());
            }
        });
        Group group2 = new Group(composite2, 0);
        group2.setLayoutData(LayoutDataShop.createGridData(1808, 1));
        group2.setText(GUI.i18n.getTranslation("MENU_MISC"));
        group2.setLayout(new GridLayout());
        group2.setFont(FontShop.dialogFont);
        final Button button3 = new Button(group2, 32);
        button3.setLayoutData(LayoutDataShop.createGridData(768, 1));
        button3.setSelection(this.rssOwlFavorite.isOpenOnStartup());
        button3.setText(GUI.i18n.getTranslation("POP_OPEN_STARTUP"));
        button3.setFont(this.dialogFont);
        button3.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                EditFavoriteProperties.this.rssOwlFavorite.setOpenOnStartup(button3.getSelection());
            }
        });
        final Button button4 = new Button(group2, 32);
        button4.setLayoutData(LayoutDataShop.createGridData(768, 1));
        button4.setText(GUI.i18n.getTranslation("POP_USEPROXY"));
        button4.setFont(this.dialogFont);
        button4.setSelection(this.rssOwlFavorite.isUseProxy());
        button4.setEnabled(ProxyShop.isUseProxy());
        button4.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                EditFavoriteProperties.this.rssOwlFavorite.setUseProxy(button4.getSelection());
            }
        });
        if (!this.rssOwlFavorite.getTitle().equals("") && !this.isEdit) {
            this.validateInput();
        }
        WidgetShop.initMnemonics(new Button[]{button, button2, button3, button4});
    }

    protected void validateInput() {
        String string = null;
        if (!(this.isEdit && this.inputUrl.getText().equalsIgnoreCase(this.rssOwlFavorite.getUrl()) || !Category.linkExists(this.inputUrl.getText()))) {
            string = GUI.i18n.getTranslation("ERROR_FAV_URL_EXISTS");
        } else if (!(this.isEdit && this.inputTitle.getText().equalsIgnoreCase(this.rssOwlFavorite.getTitle()) || !Category.titleExists(this.inputTitle.getText()))) {
            string = GUI.i18n.getTranslation("ERROR_FAV_TITLE_EXISTS");
        }
        if (string == null) {
            this.setMessage(null, false);
        } else {
            this.setMessage(string, false);
        }
    }
}

