/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.FeedAutoUpdater;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.RegExShop;

public class PropertiesFilter {
    private HashMap index = new HashMap();

    public PropertiesFilter() {
        this.createIndex();
    }

    public ArrayList filter(String string) {
        Pattern pattern = this.createPattern(string);
        ArrayList arrayList = new ArrayList();
        Set set = this.index.keySet();
        for (Object k : set) {
            String string2 = (String)this.index.get(k);
            if (!pattern.matcher(string2).matches()) continue;
            arrayList.add(k);
        }
        return arrayList;
    }

    private void addToIndex(StringBuffer stringBuffer, String string) {
        stringBuffer.append(GUI.i18n.getTranslation(string)).append(" ");
    }

    private void createIndex() {
        int n;
        String string = "MENU_WORKBENCH";
        StringBuffer stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_WORKBENCH");
        this.addToIndex(stringBuffer, "GROUP_OPEN_MODE");
        this.addToIndex(stringBuffer, "LABEL_SINGLE_CLICK");
        this.addToIndex(stringBuffer, "LABEL_DOUBLE_CLICK");
        this.addToIndex(stringBuffer, "GROUP_CONFIRM_DIALOG");
        this.addToIndex(stringBuffer, "BUTTON_DELETE_FAVORITE");
        this.addToIndex(stringBuffer, "BUTTON_DELETE_CATEGORY");
        this.addToIndex(stringBuffer, "BUTTON_DELETE_SUBSCRIPTION");
        this.addToIndex(stringBuffer, "LABEL_REOPEN_DISPLAYED_FEEDS");
        this.addToIndex(stringBuffer, "BUTTON_CACHE_FEEDS");
        this.addToIndex(stringBuffer, "BUTTON_READ_ON_CLOSE");
        this.addToIndex(stringBuffer, "BUTTON_READ_ON_MINIMIZE");
        this.addToIndex(stringBuffer, "MENU_DIRECTOPEN");
        this.addToIndex(stringBuffer, "MENU_DIRECTOPENEACH");
        this.addToIndex(stringBuffer, "MENU_CHECK_UPDATE");
        this.index.put(string, stringBuffer.toString());
        string = "MENU_COLORS";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_COLORS");
        this.addToIndex(stringBuffer, "GROUP_LINK_COLOR");
        this.addToIndex(stringBuffer, "GROUP_SYNTAXHIGHLIGHT_COLOR");
        this.addToIndex(stringBuffer, "LABEL_CURRENT_COLOR");
        this.index.put(string, stringBuffer.toString());
        string = "MENU_FONT";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_FONT");
        this.addToIndex(stringBuffer, "FONT_AREA_TEXT");
        this.addToIndex(stringBuffer, "FONT_AREA_DIALOG");
        this.addToIndex(stringBuffer, "FONT_AREA_TREE");
        this.addToIndex(stringBuffer, "FONT_AREA_TABLE");
        this.addToIndex(stringBuffer, "FONT_AREA_HEADER");
        this.addToIndex(stringBuffer, "GROUP_SELECTED_FONT");
        this.addToIndex(stringBuffer, "LABEL_SIZE");
        this.addToIndex(stringBuffer, "LABEL_STYLE");
        this.addToIndex(stringBuffer, "LABEL_USE_SYSTEM_FONT");
        this.addToIndex(stringBuffer, "MENU_ENCODING");
        this.index.put(string, stringBuffer.toString());
        string = "MENU_HOTKEYS";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_HOTKEYS");
        this.addToIndex(stringBuffer, "GROUP_COMMAND");
        this.addToIndex(stringBuffer, "LABEL_KEY_SEQUENCE");
        this.addToIndex(stringBuffer, "BUTTON_ASSIGN");
        this.index.put(string, stringBuffer.toString());
        string = "MENU_LANGUAGE";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_LANGUAGE");
        for (n = 0; n < Dictionary.languages.size(); ++n) {
            Locale locale = (Locale)Dictionary.locales.get(Dictionary.languages.get(n));
            this.addToIndex(stringBuffer, locale.getLanguage());
        }
        this.index.put(string, stringBuffer.toString());
        string = "LABEL_SORT_ORDER";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "LABEL_SORT_ORDER");
        this.addToIndex(stringBuffer, "LABEL_SORT_EXPLANATION");
        this.addToIndex(stringBuffer, "BUTTON_NO_SORT");
        for (n = 0; n < GlobalSettings.sortOrder.size(); ++n) {
            this.addToIndex(stringBuffer, (String)GlobalSettings.sortOrder.get(n));
        }
        this.index.put(string, stringBuffer.toString());
        string = "MENU_WINDOW";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_WINDOW");
        this.addToIndex(stringBuffer, "GROUP_WINDOW_LAYOUT");
        this.addToIndex(stringBuffer, "GROUP_TAB_LAYOUT");
        this.addToIndex(stringBuffer, "LABEL_TRADITIONAL_TABS");
        this.addToIndex(stringBuffer, "LABEL_CURVED_TABS");
        this.addToIndex(stringBuffer, "BUTTON_DISPLAY_TABS");
        this.addToIndex(stringBuffer, "BUTTON_FOCUS_TABS");
        this.addToIndex(stringBuffer, "BUTTON_SHOW_TAB_CLOSE");
        this.addToIndex(stringBuffer, "MENU_CHANNELINFO");
        this.addToIndex(stringBuffer, "BUTTON_SHOW_ERRORS");
        if (GlobalSettings.useInternalBrowser()) {
            this.addToIndex(stringBuffer, "MENU_BROWSER_FOR_NEWSTEXT");
        }
        this.index.put(string, stringBuffer.toString());
        if (GlobalSettings.useSystemTray()) {
            string = "GROUP_TRAY";
            stringBuffer = new StringBuffer();
            this.addToIndex(stringBuffer, "GROUP_TRAY");
            this.addToIndex(stringBuffer, "MENU_SYSTRAY");
            this.addToIndex(stringBuffer, "BUTTON_TRAY_STARTUP");
            this.addToIndex(stringBuffer, "BUTTON_TRAY_EXIT");
            this.addToIndex(stringBuffer, "GROUP_NEWS_POPUP");
            this.addToIndex(stringBuffer, "BUTTON_TRAY_POPUP");
            this.addToIndex(stringBuffer, "BUTTON_ANIMATE_POPUP");
            this.addToIndex(stringBuffer, "BUTTON_AUTOCLOSE_POPUP");
            this.index.put(string, stringBuffer.toString());
        }
        string = "MENU_BLOGGER";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_BLOGGER");
        this.addToIndex(stringBuffer, "LABEL_SELECT_BLOGGER");
        this.addToIndex(stringBuffer, "DIALOG_SELECT_EXTERNAL_BROWSER");
        this.addToIndex(stringBuffer, "GROUP_ARGUMENTS");
        this.index.put(string, stringBuffer.toString());
        string = "MENU_BROWSER";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_BROWSER");
        this.addToIndex(stringBuffer, "MENU_SELECT_EXTERNAL_BROWSER");
        this.addToIndex(stringBuffer, "DIALOG_SELECT_EXTERNAL_BROWSER");
        this.addToIndex(stringBuffer, "GROUP_ARGUMENTS");
        this.addToIndex(stringBuffer, "MENU_OPENNEW_BROWSER");
        this.addToIndex(stringBuffer, "MENU_BROWSER_EXTERN");
        if (!GlobalSettings.isLinux()) {
            this.addToIndex(stringBuffer, "BUTTON_BLOCK_POPUPS");
        }
        this.index.put(string, stringBuffer.toString());
        string = "HEADER_RSS_FAVORITES";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "HEADER_RSS_FAVORITES");
        this.addToIndex(stringBuffer, "LABEL_TEMPLATE_EXPLANATION");
        this.addToIndex(stringBuffer, "POP_AUTO_UPDATE");
        this.addToIndex(stringBuffer, "POP_UPDATE_ONSTARTUP");
        this.addToIndex(stringBuffer, "POP_OPEN_STARTUP");
        for (n = 0; n < FeedAutoUpdater.updateIntervalNames.length; ++n) {
            this.addToIndex(stringBuffer, FeedAutoUpdater.updateIntervalNames[n]);
        }
        this.index.put(string, stringBuffer.toString());
        string = "MENU_NEWSTIP_MAIL";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_NEWSTIP_MAIL");
        this.addToIndex(stringBuffer, "LABEL_MAIL_SUBJECT");
        this.addToIndex(stringBuffer, "LABEL_MAIL_BODY");
        this.addToIndex(stringBuffer, "LABEL_HTML_FORMAT_MAIL");
        this.index.put(string, stringBuffer.toString());
        string = "MENU_CONNECTION";
        stringBuffer = new StringBuffer();
        this.addToIndex(stringBuffer, "MENU_CONNECTION");
        this.addToIndex(stringBuffer, "MENU_PROXY");
        this.addToIndex(stringBuffer, "LABEL_USE_PROXY");
        this.addToIndex(stringBuffer, "LABEL_PROXY_HOST");
        this.addToIndex(stringBuffer, "LABEL_PROXY_PORT");
        this.addToIndex(stringBuffer, "LABEL_PROXY_AUTHENTIFICATION");
        this.addToIndex(stringBuffer, "LABEL_USERNAME");
        this.addToIndex(stringBuffer, "LABEL_PASSWORD");
        this.addToIndex(stringBuffer, "LABEL_DOMAIN");
        this.addToIndex(stringBuffer, "LABEL_USE_PROXY_FOR_ALL");
        this.addToIndex(stringBuffer, "LABEL_MAX_CONNECTIONS");
        this.addToIndex(stringBuffer, "LABEL_CON_TIMEOUT");
        this.index.put(string, stringBuffer.toString());
    }

    private Pattern createPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".*");
        stringBuffer.append(RegExShop.escapeRegEx(string));
        stringBuffer.append(".*");
        return Pattern.compile(stringBuffer.toString(), 2);
    }
}

