/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import java.util.ArrayList;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

public class SortOrderPropertiers
extends PropertyPage {
    Button doNotSortCheck;
    Button downButton;
    List sortOrderList;
    Button upButton;

    public SortOrderPropertiers(Composite composite) {
        super(composite);
    }

    @Override
    public void applyButtonPressed() {
        GlobalSettings.sortOrder = this.listToArrayList();
        GlobalSettings.autoSortNews = !this.doNotSortCheck.getSelection();
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        propertyChangeManager.setSortOrder(this.listToArrayList());
        propertyChangeManager.setAutoSortNews(!this.doNotSortCheck.getSelection());
    }

    private ArrayList listToArrayList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray = this.sortOrderList.getItems();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(this.sortOrderList.getData(stringArray[i]));
        }
        return arrayList;
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setText(GUI.i18n.getTranslation("LABEL_DESCRIPTION"));
        group.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group.setLayout(new GridLayout(1, false));
        group.setFont(FontShop.dialogFont);
        Label label = new Label(group, 64);
        label.setText(GUI.i18n.getTranslation("LABEL_SORT_EXPLANATION"));
        label.setFont(this.dialogFont);
        label.setLayoutData(new GridData(1808));
        this.sortOrderList = new List(this.composite, 2052);
        this.sortOrderList.setFont(this.dialogFont);
        this.sortOrderList.setLayoutData(new GridData(768));
        this.sortOrderList.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SortOrderPropertiers.this.upButton.setEnabled(true);
                SortOrderPropertiers.this.downButton.setEnabled(true);
            }
        });
        ArrayList arrayList = propertyChangeManager.getSortOrder();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            this.sortOrderList.add(GUI.i18n.getTranslation(string));
            this.sortOrderList.setData(GUI.i18n.getTranslation(string), string);
        }
        Composite composite = new Composite(this.composite, 0);
        composite.setLayout(LayoutShop.createGridLayout(1, 0, 0, false));
        composite.setLayoutData(new GridData(2));
        this.upButton = new Button(composite, 0);
        this.upButton.setFont(this.dialogFont);
        this.upButton.setLayoutData(new GridData(2));
        this.upButton.setText(GUI.i18n.getTranslation("BUTTON_UP"));
        this.upButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SortOrderPropertiers.this.moveListElementUp();
            }
        });
        this.downButton = new Button(composite, 0);
        this.downButton.setFont(this.dialogFont);
        this.downButton.setLayoutData(new GridData(2));
        this.downButton.setText(GUI.i18n.getTranslation("BUTTON_DOWN"));
        this.downButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SortOrderPropertiers.this.moveListElementDown();
            }
        });
        this.setButtonLayoutData(this.upButton, new GridData(32));
        this.setButtonLayoutData(this.downButton, new GridData(32));
        this.doNotSortCheck = new Button(this.composite, 32);
        this.doNotSortCheck.setFont(this.dialogFont);
        this.doNotSortCheck.setText(GUI.i18n.getTranslation("BUTTON_NO_SORT"));
        this.doNotSortCheck.setSelection(!propertyChangeManager.isAutoSortNews());
        this.doNotSortCheck.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SortOrderPropertiers.this.setAutoSortControlsState(!SortOrderPropertiers.this.doNotSortCheck.getSelection());
                SortOrderPropertiers.this.sortOrderList.deselectAll();
            }
        });
        this.setAutoSortControlsState(!this.doNotSortCheck.getSelection());
        LayoutShop.setDialogSpacer(this.composite, 2, 4);
        WidgetShop.initMnemonics(new Button[]{this.upButton, this.downButton, this.doNotSortCheck});
    }

    @Override
    protected void restoreButtonPressed() {
        String[] stringArray = GlobalSettings.defaultSortOrder;
        this.sortOrderList.removeAll();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.sortOrderList.add(GUI.i18n.getTranslation(string));
            this.sortOrderList.setData(GUI.i18n.getTranslation(string), string);
        }
        this.doNotSortCheck.setSelection(false);
        this.setAutoSortControlsState(true);
    }

    void moveListElementDown() {
        int[] nArray = this.sortOrderList.getSelectionIndices();
        if (nArray.length == 1 && nArray[0] != this.sortOrderList.getItemCount() - 1) {
            String string = this.sortOrderList.getItem(nArray[0]);
            String string2 = this.sortOrderList.getItem(nArray[0] + 1);
            this.sortOrderList.setItem(nArray[0], string2);
            this.sortOrderList.setItem(nArray[0] + 1, string);
            this.sortOrderList.setSelection(nArray[0] + 1);
        }
    }

    void moveListElementUp() {
        int[] nArray = this.sortOrderList.getSelectionIndices();
        if (nArray.length == 1 && nArray[0] != 0) {
            String string = this.sortOrderList.getItem(nArray[0]);
            String string2 = this.sortOrderList.getItem(nArray[0] - 1);
            this.sortOrderList.setItem(nArray[0], string2);
            this.sortOrderList.setItem(nArray[0] - 1, string);
            this.sortOrderList.setSelection(nArray[0] - 1);
        }
    }

    void setAutoSortControlsState(boolean bl) {
        this.sortOrderList.setEnabled(bl);
        this.upButton.setEnabled(bl && this.sortOrderList.getSelectionCount() != 0);
        this.downButton.setEnabled(bl && this.sortOrderList.getSelectionCount() != 0);
    }
}

