/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import java.util.Date;
import java.util.Locale;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.FavoritePropertyPage;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ViewFavoriteProperties
extends FavoritePropertyPage {
    public ViewFavoriteProperties(Composite composite, Favorite favorite) {
        super(composite, favorite);
    }

    @Override
    protected void initComponents() {
        Label label = new Label(this.composite, 0);
        label.setText(GUI.i18n.getTranslation("LABEL_TITLE") + ": ");
        label.setFont(FontShop.dialogFont);
        Text text = new Text(this.composite, 2056);
        text.setText(this.rssOwlFavorite.getTitle());
        text.setFont(FontShop.dialogFont);
        text.setLayoutData(new GridData(768));
        WidgetShop.tweakTextWidget(text);
        Label label2 = new Label(this.composite, 0);
        label2.setText(GUI.i18n.getTranslation("LABEL_URL_PATH") + ": ");
        label2.setFont(FontShop.dialogFont);
        Text text2 = new Text(this.composite, 2056);
        text2.setText(this.rssOwlFavorite.getUrl());
        text2.setFont(FontShop.dialogFont);
        text2.setLayoutData(new GridData(768));
        WidgetShop.tweakTextWidget(text2);
        Label label3 = new Label(this.composite, 0);
        label3.setText(GUI.i18n.getTranslation("LABEL_DESCRIPTION") + ": ");
        label3.setLayoutData(new GridData(1, 1, false, false));
        label3.setFont(FontShop.dialogFont);
        Text text3 = new Text(this.composite, 2634);
        text3.setText(this.rssOwlFavorite.getDescription());
        text3.setFont(FontShop.dialogFont);
        text3.setLayoutData(LayoutDataShop.createGridData(1808, 1, -1, 50));
        WidgetShop.tweakTextWidget(text3);
        Label label4 = new Label(this.composite, 0);
        label4.setText(GUI.i18n.getTranslation("CHANNEL_INFO_HOMEPAGE") + ": ");
        label4.setFont(FontShop.dialogFont);
        final Text text4 = new Text(this.composite, 2056);
        text4.setText(this.rssOwlFavorite.getHomepage());
        text4.setFont(FontShop.dialogFont);
        text4.setLayoutData(new GridData(768));
        if (StringShop.isset(this.rssOwlFavorite.getHomepage()) && RegExShop.isValidURL(this.rssOwlFavorite.getHomepage())) {
            text4.setCursor(GUI.display.getSystemCursor(21));
            text4.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_URLOPEN"));
            text4.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseUp(MouseEvent mouseEvent) {
                    if (mouseEvent.button == 1 && text4.getSelectionCount() == 0) {
                        GUI.rssOwlGui.getEventManager().actionOpenURL(ViewFavoriteProperties.this.rssOwlFavorite.getHomepage());
                    }
                }
            });
        }
        WidgetShop.tweakTextWidget(text4);
        Label label5 = new Label(this.composite, 0);
        label5.setText(GUI.i18n.getTranslation("MENU_LANGUAGE") + ": ");
        label5.setFont(FontShop.dialogFont);
        Text text5 = new Text(this.composite, 2056);
        text5.setFont(FontShop.dialogFont);
        text5.setLayoutData(new GridData(768));
        WidgetShop.tweakTextWidget(text5);
        if (StringShop.isset(this.rssOwlFavorite.getLanguage())) {
            if (this.rssOwlFavorite.getLanguage().split("-").length == 2) {
                text5.setText(new Locale(this.rssOwlFavorite.getLanguage().split("-")[0]).getDisplayLanguage(Dictionary.selectedLocale));
            } else {
                text5.setText(new Locale(this.rssOwlFavorite.getLanguage()).getDisplayLanguage(Dictionary.selectedLocale));
            }
        }
        Label label6 = new Label(this.composite, 0);
        label6.setText(GUI.i18n.getTranslation("LABEL_CREATED") + ": ");
        label6.setFont(FontShop.dialogFont);
        Text text6 = new Text(this.composite, 2056);
        text6.setFont(FontShop.dialogFont);
        text6.setLayoutData(new GridData(768));
        WidgetShop.tweakTextWidget(text6);
        if (this.rssOwlFavorite.getCreationDate() != 0L) {
            text6.setText(DateParser.formatDate(new Date(this.rssOwlFavorite.getCreationDate()), true, true));
        }
        Label label7 = new Label(this.composite, 0);
        label7.setText(GUI.i18n.getTranslation("LABEL_LAST_VISIT") + ": ");
        label7.setFont(FontShop.dialogFont);
        Text text7 = new Text(this.composite, 2056);
        text7.setFont(FontShop.dialogFont);
        text7.setLayoutData(new GridData(768));
        WidgetShop.tweakTextWidget(text7);
        if (this.rssOwlFavorite.getLastVisitDate() != 0L) {
            text7.setText(DateParser.formatDate(new Date(this.rssOwlFavorite.getLastVisitDate()), true, true));
        }
    }
}

