/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class ViewProperties
extends PropertyPage {
    private Button curvedTabRadio;
    private Button focusNewTabsCheck;
    private Button showChannelInfoCheck;
    private Button showErrorsCheck;
    private Button simpleTabRadio;
    private Button threeColumnGUIRadio;
    private Button twoColumnGUIRadio;
    private Button useBrowserForNewstextCheck;
    Button displayTabsCheck;
    Button showCloseButtonCheck;

    public ViewProperties(Composite composite, GUI gUI) {
        super(composite, gUI);
    }

    @Override
    public void applyButtonPressed() {
        if (GlobalSettings.isThreeColumnGUI != this.threeColumnGUIRadio.getSelection()) {
            GlobalSettings.isThreeColumnGUI = this.threeColumnGUIRadio.getSelection();
            this.rssOwlGui.changeWindowLayout();
        }
        if (GlobalSettings.simpleTabs != this.simpleTabRadio.getSelection()) {
            GlobalSettings.simpleTabs = this.simpleTabRadio.getSelection();
            this.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setSimple(GlobalSettings.simpleTabs);
        }
        if (GlobalSettings.displaySingleTab == this.displayTabsCheck.getSelection()) {
            GlobalSettings.displaySingleTab = !this.displayTabsCheck.getSelection();
            this.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setSelectionBackground(GlobalSettings.displaySingleTab ? PaintShop.grayViewFormColor : GUI.display.getSystemColor(1));
            this.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setTabHeight(GlobalSettings.displaySingleTab ? 0 : -1);
            if (GlobalSettings.displaySingleTab) {
                this.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setTabPosition(1024);
            } else {
                this.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setTabPosition(GlobalSettings.tabPositionIsTop ? 128 : 1024);
            }
            this.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().layout();
        }
        GlobalSettings.showTabCloseButton = this.showCloseButtonCheck.getSelection();
        if (GlobalSettings.useInternalBrowser() && GlobalSettings.useBrowserForNewsText != this.useBrowserForNewstextCheck.getSelection()) {
            GlobalSettings.useBrowserForNewsText = this.useBrowserForNewstextCheck.getSelection();
            this.rssOwlGui.getEventManager().actionSetBrowserView(GlobalSettings.useBrowserForNewsText);
        }
        GlobalSettings.showChannelInfo = this.showChannelInfoCheck.getSelection();
        GlobalSettings.showErrors = propertyChangeManager.isShowErrors();
        GlobalSettings.focusNewTabs = this.focusNewTabsCheck.getSelection();
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        propertyChangeManager.setThreeColumnGUI(this.threeColumnGUIRadio.getSelection());
        propertyChangeManager.setShowChannelInfo(this.showChannelInfoCheck.getSelection());
        propertyChangeManager.setSimpleTabs(this.simpleTabRadio.getSelection());
        propertyChangeManager.setDisplaySingleTab(!this.displayTabsCheck.getSelection());
        propertyChangeManager.setShowTabCloseButton(this.showCloseButtonCheck.getSelection());
        propertyChangeManager.setFocusNewTabs(this.focusNewTabsCheck.getSelection());
        propertyChangeManager.setShowErrors(this.showErrorsCheck.getSelection());
        if (GlobalSettings.useInternalBrowser()) {
            propertyChangeManager.setUseBrowserForNewsText(this.useBrowserForNewstextCheck.getSelection());
        }
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group.setText(GUI.i18n.getTranslation("GROUP_WINDOW_LAYOUT"));
        group.setLayout(LayoutShop.createGridLayout(2, 5, 5, 5, 15, false));
        group.setFont(FontShop.dialogFont);
        Label label = new Label(group, 64);
        label.setFont(this.dialogFont);
        label.setLayoutData(LayoutDataShop.createGridData(768, 2));
        label.setText(GUI.i18n.getTranslation("LABEL_SELECT_WINDOW_LAYOUT") + ": ");
        this.twoColumnGUIRadio = new Button(group, 16);
        this.twoColumnGUIRadio.setFont(this.dialogFont);
        this.twoColumnGUIRadio.setSelection(!propertyChangeManager.isThreeColumnGUI());
        this.twoColumnGUIRadio.setImage(PaintShop.loadImage("/img/icons/twocolumn.gif"));
        this.twoColumnGUIRadio.addDisposeListener(DisposeListenerImpl.getInstance());
        this.threeColumnGUIRadio = new Button(group, 16);
        this.threeColumnGUIRadio.setFont(this.dialogFont);
        this.threeColumnGUIRadio.setSelection(propertyChangeManager.isThreeColumnGUI());
        this.threeColumnGUIRadio.setImage(PaintShop.loadImage("/img/icons/threecolumn.gif"));
        this.threeColumnGUIRadio.addDisposeListener(DisposeListenerImpl.getInstance());
        Group group2 = new Group(this.composite, 0);
        group2.setText(GUI.i18n.getTranslation("GROUP_TAB_LAYOUT"));
        group2.setLayout(new GridLayout(2, false));
        group2.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group2.setFont(FontShop.dialogFont);
        this.simpleTabRadio = new Button(group2, 16);
        this.simpleTabRadio.setText(GUI.i18n.getTranslation("LABEL_TRADITIONAL_TABS"));
        this.simpleTabRadio.setSelection(propertyChangeManager.isSimpleTabs());
        this.simpleTabRadio.setFont(this.dialogFont);
        this.curvedTabRadio = new Button(group2, 16);
        this.curvedTabRadio.setText(GUI.i18n.getTranslation("LABEL_CURVED_TABS"));
        this.curvedTabRadio.setSelection(!propertyChangeManager.isSimpleTabs());
        this.curvedTabRadio.setFont(this.dialogFont);
        this.displayTabsCheck = new Button(group2, 32);
        this.displayTabsCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.displayTabsCheck.setSelection(!propertyChangeManager.isDisplaySingleTab());
        this.displayTabsCheck.setText(GUI.i18n.getTranslation("BUTTON_DISPLAY_TABS"));
        this.displayTabsCheck.setFont(this.dialogFont);
        this.displayTabsCheck.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewProperties.this.setTabControlsEnabled(ViewProperties.this.displayTabsCheck.getSelection());
                ViewProperties.this.setWarningMessage(GlobalSettings.displaySingleTab == ViewProperties.this.displayTabsCheck.getSelection() ? GUI.i18n.getTranslation("LABEL_RESTART") : null);
            }
        });
        this.focusNewTabsCheck = new Button(group2, 32);
        this.focusNewTabsCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.focusNewTabsCheck.setSelection(propertyChangeManager.isFocusNewTabs());
        this.focusNewTabsCheck.setText(GUI.i18n.getTranslation("BUTTON_FOCUS_TABS"));
        this.focusNewTabsCheck.setFont(this.dialogFont);
        this.showCloseButtonCheck = new Button(group2, 32);
        this.showCloseButtonCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.showCloseButtonCheck.setSelection(propertyChangeManager.isShowTabCloseButton());
        this.showCloseButtonCheck.setText(GUI.i18n.getTranslation("BUTTON_SHOW_TAB_CLOSE"));
        this.showCloseButtonCheck.setFont(this.dialogFont);
        this.showCloseButtonCheck.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ViewProperties.this.setWarningMessage(GlobalSettings.showTabCloseButton != ViewProperties.this.showCloseButtonCheck.getSelection() ? GUI.i18n.getTranslation("LABEL_RESTART") : null);
            }
        });
        Group group3 = new Group(this.composite, 0);
        group3.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group3.setText(GUI.i18n.getTranslation("MENU_MISC"));
        group3.setLayout(new GridLayout(2, false));
        group3.setFont(FontShop.dialogFont);
        if (GlobalSettings.useInternalBrowser()) {
            this.useBrowserForNewstextCheck = new Button(group3, 32);
            this.useBrowserForNewstextCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
            this.useBrowserForNewstextCheck.setSelection(propertyChangeManager.isUseBrowserForNewsText());
            this.useBrowserForNewstextCheck.setText(GUI.i18n.getTranslation("MENU_BROWSER_FOR_NEWSTEXT"));
            this.useBrowserForNewstextCheck.setFont(this.dialogFont);
        }
        this.showChannelInfoCheck = new Button(group3, 32);
        this.showChannelInfoCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.showChannelInfoCheck.setSelection(propertyChangeManager.isShowChannelInfo());
        this.showChannelInfoCheck.setText(GUI.i18n.getTranslation("MENU_CHANNELINFO"));
        this.showChannelInfoCheck.setFont(this.dialogFont);
        this.showErrorsCheck = new Button(group3, 32);
        this.showErrorsCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.showErrorsCheck.setSelection(propertyChangeManager.isShowErrors());
        this.showErrorsCheck.setText(GUI.i18n.getTranslation("BUTTON_SHOW_ERRORS"));
        this.showErrorsCheck.setFont(this.dialogFont);
        this.setTabControlsEnabled(this.displayTabsCheck.getSelection());
        if (GlobalSettings.useInternalBrowser()) {
            WidgetShop.initMnemonics(new Button[]{this.simpleTabRadio, this.curvedTabRadio, this.displayTabsCheck, this.focusNewTabsCheck, this.showCloseButtonCheck, this.useBrowserForNewstextCheck, this.showChannelInfoCheck, this.showErrorsCheck});
        } else {
            WidgetShop.initMnemonics(new Button[]{this.simpleTabRadio, this.curvedTabRadio, this.displayTabsCheck, this.focusNewTabsCheck, this.showCloseButtonCheck, this.showChannelInfoCheck, this.showErrorsCheck});
        }
        this.errorMessageLabel = new CLabel(this.composite, 0);
        this.errorMessageLabel.setFont(this.dialogFont);
        this.errorMessageLabel.setLayoutData(new GridData(4, 1, true, false, 2, 1));
        ((GridData)this.errorMessageLabel.getLayoutData()).heightHint = 32;
        if (GlobalSettings.displaySingleTab == this.displayTabsCheck.getSelection()) {
            this.setWarningMessage(GUI.i18n.getTranslation("LABEL_RESTART"));
        }
    }

    @Override
    protected void restoreButtonPressed() {
        this.twoColumnGUIRadio.setSelection(true);
        this.threeColumnGUIRadio.setSelection(false);
        this.showChannelInfoCheck.setSelection(true);
        this.simpleTabRadio.setSelection(true);
        this.displayTabsCheck.setSelection(true);
        this.showCloseButtonCheck.setSelection(true);
        this.curvedTabRadio.setSelection(false);
        this.focusNewTabsCheck.setSelection(true);
        this.showErrorsCheck.setSelection(true);
        if (GlobalSettings.useInternalBrowser()) {
            this.useBrowserForNewstextCheck.setSelection(GlobalSettings.isWindows());
        }
        this.setTabControlsEnabled(this.displayTabsCheck.getSelection());
        this.setWarningMessage(GlobalSettings.displaySingleTab == this.displayTabsCheck.getSelection() ? GUI.i18n.getTranslation("LABEL_RESTART") : null);
    }

    void setTabControlsEnabled(boolean bl) {
        this.focusNewTabsCheck.setEnabled(bl);
        this.simpleTabRadio.setEnabled(bl);
        this.curvedTabRadio.setEnabled(bl);
        this.showCloseButtonCheck.setEnabled(bl);
    }
}

