/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.properties.PropertyPage;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class WorkbenchProperties
extends PropertyPage {
    private Button checkForUpdateCheck;
    private Button confirmCatDeletionCheck;
    private Button confirmFavDeletionCheck;
    private Button confirmSubDeletionCheck;
    private Button directOpenCheck;
    private Button directOpenEachCheck;
    private Button doubleClickRadio;
    private Button localCacheFeedsCheck;
    private Button markAllReadOnMinimizeCheck;
    private Button markFeedReadOnTabCloseCheck;
    private Button reopenFeedsCheck;
    private Button singleClickRadio;

    public WorkbenchProperties(Composite composite, GUI gUI) {
        super(composite, gUI);
    }

    @Override
    public void applyButtonPressed() {
        GlobalSettings.isDoubleClickOpen = this.doubleClickRadio.getSelection();
        GlobalSettings.directOpenNews = this.directOpenCheck.getSelection();
        GlobalSettings.directOpenEachNews = this.directOpenEachCheck.getSelection();
        GlobalSettings.checkUpdate = this.checkForUpdateCheck.getSelection();
        GlobalSettings.reopenFeeds = this.reopenFeedsCheck.getSelection();
        GlobalSettings.markAllReadOnMinimize = this.markAllReadOnMinimizeCheck.getSelection();
        GlobalSettings.markFeedReadOnTabClose = this.markFeedReadOnTabCloseCheck.getSelection();
        GlobalSettings.localCacheFeeds = this.localCacheFeedsCheck.getSelection();
        GlobalSettings.confirmFavoriteDeletion = this.confirmFavDeletionCheck.getSelection();
        GlobalSettings.confirmCategoryDeletion = this.confirmCatDeletionCheck.getSelection();
        GlobalSettings.confirmBlogrollDeletion = this.confirmSubDeletionCheck.getSelection();
        if (GlobalSettings.reopenFeeds) {
            this.rssOwlGui.getRSSOwlNewsTabFolder().updateLastOpenedFeeds();
        }
        this.updatePropertiesChangeManager();
    }

    @Override
    public void updatePropertiesChangeManager() {
        propertyChangeManager.setDoubleClickOpen(this.doubleClickRadio.getSelection());
        propertyChangeManager.setAutoOpenEachNews(this.directOpenEachCheck.getSelection());
        propertyChangeManager.setAutoOpenEmptyNews(this.directOpenCheck.getSelection());
        propertyChangeManager.setCheckForUpdate(this.checkForUpdateCheck.getSelection());
        propertyChangeManager.setReopenFeeds(this.reopenFeedsCheck.getSelection());
        propertyChangeManager.setMarkAllReadOnMinimize(this.markAllReadOnMinimizeCheck.getSelection());
        propertyChangeManager.setMarkFeedReadOnTabClose(this.markFeedReadOnTabCloseCheck.getSelection());
        propertyChangeManager.setLocalCacheFeeds(this.localCacheFeedsCheck.getSelection());
        propertyChangeManager.setConfirmFavoriteDeletion(this.confirmFavDeletionCheck.getSelection());
        propertyChangeManager.setConfirmCategoryDeletion(this.confirmCatDeletionCheck.getSelection());
        propertyChangeManager.setConfirmBlogrollDeletion(this.confirmSubDeletionCheck.getSelection());
    }

    @Override
    protected void initComponents() {
        Group group = new Group(this.composite, 0);
        group.setText(GUI.i18n.getTranslation("GROUP_OPEN_MODE"));
        group.setLayout(new GridLayout(2, false));
        group.setLayoutData(LayoutDataShop.createGridData(768, 2));
        group.setFont(FontShop.dialogFont);
        this.singleClickRadio = new Button(group, 16);
        this.singleClickRadio.setText(GUI.i18n.getTranslation("LABEL_SINGLE_CLICK"));
        this.singleClickRadio.setSelection(!propertyChangeManager.isDoubleClickOpen());
        this.singleClickRadio.setFont(this.dialogFont);
        this.doubleClickRadio = new Button(group, 16);
        this.doubleClickRadio.setText(GUI.i18n.getTranslation("LABEL_DOUBLE_CLICK"));
        this.doubleClickRadio.setSelection(propertyChangeManager.isDoubleClickOpen());
        this.doubleClickRadio.setFont(this.dialogFont);
        Group group2 = new Group(this.composite, 0);
        group2.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group2.setText(GUI.i18n.getTranslation("GROUP_CONFIRM_DIALOG"));
        group2.setLayout(LayoutShop.createGridLayout(2, 5, 5, 10));
        group2.setFont(FontShop.dialogFont);
        this.confirmFavDeletionCheck = new Button(group2, 32);
        this.confirmFavDeletionCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.confirmFavDeletionCheck.setSelection(propertyChangeManager.isConfirmFavoriteDeletion());
        this.confirmFavDeletionCheck.setText(GUI.i18n.getTranslation("BUTTON_DELETE_FAVORITE"));
        this.confirmFavDeletionCheck.setFont(this.dialogFont);
        this.confirmCatDeletionCheck = new Button(group2, 32);
        this.confirmCatDeletionCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.confirmCatDeletionCheck.setSelection(propertyChangeManager.isConfirmCategoryDeletion());
        this.confirmCatDeletionCheck.setText(GUI.i18n.getTranslation("BUTTON_DELETE_CATEGORY"));
        this.confirmCatDeletionCheck.setFont(this.dialogFont);
        this.confirmSubDeletionCheck = new Button(group2, 32);
        this.confirmSubDeletionCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.confirmSubDeletionCheck.setSelection(propertyChangeManager.isConfirmBlogrollDeletion());
        this.confirmSubDeletionCheck.setText(GUI.i18n.getTranslation("BUTTON_DELETE_SUBSCRIPTION"));
        this.confirmSubDeletionCheck.setFont(this.dialogFont);
        Group group3 = new Group(this.composite, 0);
        group3.setLayoutData(LayoutDataShop.createGridData(770, 2));
        group3.setText(GUI.i18n.getTranslation("MENU_MISC"));
        group3.setLayout(LayoutShop.createGridLayout(2, 5, 5, 10));
        group3.setFont(FontShop.dialogFont);
        this.reopenFeedsCheck = new Button(group3, 32);
        this.reopenFeedsCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.reopenFeedsCheck.setSelection(propertyChangeManager.isReopenFeeds());
        this.reopenFeedsCheck.setText(GUI.i18n.getTranslation("LABEL_REOPEN_DISPLAYED_FEEDS"));
        this.reopenFeedsCheck.setFont(this.dialogFont);
        this.localCacheFeedsCheck = new Button(group3, 32);
        this.localCacheFeedsCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.localCacheFeedsCheck.setSelection(propertyChangeManager.isLocalCacheFeeds());
        this.localCacheFeedsCheck.setText(GUI.i18n.getTranslation("BUTTON_CACHE_FEEDS"));
        this.localCacheFeedsCheck.setFont(this.dialogFont);
        this.markFeedReadOnTabCloseCheck = new Button(group3, 32);
        this.markFeedReadOnTabCloseCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.markFeedReadOnTabCloseCheck.setSelection(propertyChangeManager.isMarkFeedReadOnTabClose());
        this.markFeedReadOnTabCloseCheck.setText(GUI.i18n.getTranslation("BUTTON_READ_ON_CLOSE"));
        this.markFeedReadOnTabCloseCheck.setFont(this.dialogFont);
        this.markAllReadOnMinimizeCheck = new Button(group3, 32);
        this.markAllReadOnMinimizeCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.markAllReadOnMinimizeCheck.setSelection(propertyChangeManager.isMarkAllReadOnMinimize());
        this.markAllReadOnMinimizeCheck.setText(GUI.i18n.getTranslation("BUTTON_READ_ON_MINIMIZE"));
        this.markAllReadOnMinimizeCheck.setFont(this.dialogFont);
        this.directOpenCheck = new Button(group3, 32);
        this.directOpenCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.directOpenCheck.setSelection(propertyChangeManager.isAutoOpenEmptyNews());
        this.directOpenCheck.setText(GUI.i18n.getTranslation("MENU_DIRECTOPEN"));
        this.directOpenCheck.setFont(this.dialogFont);
        this.directOpenEachCheck = new Button(group3, 32);
        this.directOpenEachCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.directOpenEachCheck.setSelection(propertyChangeManager.isAutoOpenEachNews());
        this.directOpenEachCheck.setText(GUI.i18n.getTranslation("MENU_DIRECTOPENEACH"));
        this.directOpenEachCheck.setFont(this.dialogFont);
        this.checkForUpdateCheck = new Button(group3, 32);
        this.checkForUpdateCheck.setLayoutData(LayoutDataShop.createGridData(768, 2));
        this.checkForUpdateCheck.setSelection(propertyChangeManager.isCheckForUpdate());
        this.checkForUpdateCheck.setText(GUI.i18n.getTranslation("MENU_CHECK_UPDATE"));
        this.checkForUpdateCheck.setFont(this.dialogFont);
        WidgetShop.initMnemonics(new Button[]{this.singleClickRadio, this.doubleClickRadio, this.confirmFavDeletionCheck, this.confirmCatDeletionCheck, this.confirmSubDeletionCheck, this.reopenFeedsCheck, this.localCacheFeedsCheck, this.markFeedReadOnTabCloseCheck, this.markAllReadOnMinimizeCheck, this.directOpenCheck, this.directOpenEachCheck, this.checkForUpdateCheck});
    }

    @Override
    protected void restoreButtonPressed() {
        this.directOpenCheck.setSelection(false);
        this.directOpenEachCheck.setSelection(false);
        this.checkForUpdateCheck.setSelection(true);
        this.singleClickRadio.setSelection(GlobalSettings.useSingleClickOpen());
        this.doubleClickRadio.setSelection(!GlobalSettings.useSingleClickOpen());
        this.reopenFeedsCheck.setSelection(false);
        this.markAllReadOnMinimizeCheck.setSelection(false);
        this.markFeedReadOnTabCloseCheck.setSelection(false);
        this.localCacheFeedsCheck.setSelection(true);
        this.confirmFavDeletionCheck.setSelection(true);
        this.confirmCatDeletionCheck.setSelection(true);
        this.confirmSubDeletionCheck.setSelection(true);
    }
}

