/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.statusline;

import java.util.Calendar;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.statusline.LoadJob;
import net.sourceforge.rssowl.controller.statusline.StatusLineAnimator;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class StatusLine {
    public static final int LOAD = 0;
    public static final int RELOAD = 2;
    public static final int SEARCH = 1;
    private static String LOAD_LABEL;
    private static String RELOAD_LABEL;
    private static String SEARCH_LABEL;
    private Label dateLabel;
    private Calendar lastStatusDate;
    private Vector loadingJobQueue;
    private Composite parent;
    private Label rateStatusLabel;
    private Label sepA;
    private ToolItem skipFeedButton;
    private Thread statusLineAnimator;
    private Composite statusLineHolder;
    private Label statusTextLabel;
    private ToolItem stopOperationButton;
    private ToolBar stopOperationLoadBar;
    LoadJob currentLoadingJob;
    Display display;
    int entireLoad;
    int finishedLoad;
    GUI rssOwlGui;
    Label statusProgressBar;

    public StatusLine(Display display, Composite composite, GUI gUI) {
        this.display = display;
        this.parent = composite;
        this.rssOwlGui = gUI;
        this.loadingJobQueue = new Vector();
        this.setupDefaults();
        this.initJobLabel();
        this.initComponents();
    }

    public void addEntireLoad(int n) {
        this.entireLoad += n;
    }

    public synchronized void finishJob(LoadJob loadJob) {
        this.loadingJobQueue.remove(loadJob);
        ++this.finishedLoad;
        if (!this.isBusyLoading()) {
            this.resetStatusLine();
        } else {
            LoadJob loadJob2 = (LoadJob)this.loadingJobQueue.firstElement();
            this.displayJob(loadJob2);
            if (this.loadingJobQueue.size() == 1 && !loadJob2.isFromAggregation()) {
                this.setSkipFeedEnabled(false);
            }
        }
    }

    public synchronized void insertJob(LoadJob loadJob) {
        this.loadingJobQueue.add(loadJob);
        this.displayJob(loadJob);
        this.setStatusEnabled(true);
        if (this.loadingJobQueue.size() == 1) {
            this.startStatusAnimatorThread(20);
            this.setSkipFeedEnabled(false);
        } else {
            this.setSkipFeedEnabled(true);
        }
        this.updateDateLabel(false);
    }

    public boolean isBusyLoading() {
        return this.loadingJobQueue.size() > 0;
    }

    public void setAmphetaRateItemsVisible(boolean bl) {
        if (WidgetShop.isset(this.sepA)) {
            this.sepA.setVisible(bl);
        }
        if (WidgetShop.isset(this.rateStatusLabel)) {
            this.rateStatusLabel.setVisible(bl);
        }
    }

    public void updateFonts() {
        this.dateLabel.setFont(FontShop.dialogFont);
        this.statusTextLabel.setFont(FontShop.dialogFont);
        this.statusProgressBar.setFont(FontShop.dialogFont);
    }

    public void updateI18N() {
        this.initJobLabel();
        this.updateDateLabel(true);
        this.stopOperationButton.setToolTipText(GUI.i18n.getTranslation("BUTTON_CANCLE"));
        this.skipFeedButton.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_SKIP"));
        if (!this.isBusyLoading()) {
            this.statusTextLabel.setText(GUI.i18n.getTranslation("LABEL_READY"));
            this.statusTextLabel.update();
        }
    }

    public void updateRateLabel(String string) {
        if (this.rateStatusLabel.getToolTipText().equals(string)) {
            return;
        }
        if (this.rateStatusLabel.getToolTipText().equals("AmphetaRate") || string.equals("")) {
            this.rateStatusLabel.setImage(!string.equals("") ? PaintShop.iconRateSuccess : PaintShop.iconNotRated);
        }
        this.rateStatusLabel.setToolTipText(string.equals("") ? "AmphetaRate" : string);
    }

    private void displayJob(LoadJob loadJob) {
        this.currentLoadingJob = loadJob;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStyleText(loadJob.getStyle()));
        if (loadJob.isFromAggregation()) {
            stringBuffer.append(" (");
            stringBuffer.append(this.loadingJobQueue.size() > 1 ? String.valueOf(this.getLoadingPercentages()) : "100");
            stringBuffer.append("%)");
        }
        stringBuffer.append(": ");
        stringBuffer.append(loadJob.getTitle());
        if (!this.statusLineHolder.isDisposed()) {
            this.setStatusText(new String(stringBuffer));
        }
    }

    private int getLoadingPercentages() {
        if (this.entireLoad == 0) {
            return 0;
        }
        return this.finishedLoad * 100 / this.entireLoad;
    }

    private String getStyleText(int n) {
        switch (n) {
            case 1: {
                return SEARCH_LABEL;
            }
            case 2: {
                return RELOAD_LABEL;
            }
        }
        return LOAD_LABEL;
    }

    private void initComponents() {
        this.statusLineHolder = new Composite(this.parent, 0);
        this.statusLineHolder.setLayoutData(LayoutDataShop.createGridData(770, 3));
        this.statusLineHolder.setLayout(LayoutShop.createGridLayout(4, 3, 0, 0, 5, false));
        Composite composite = new Composite(this.statusLineHolder, 0);
        composite.setLayoutData(LayoutDataShop.createGridData(32, 1));
        composite.setLayout(LayoutShop.createGridLayout(2, 0, 0, 0, 5, false));
        this.statusProgressBar = new Label(composite, 262144);
        this.statusProgressBar.setFont(FontShop.dialogFont);
        this.statusProgressBar.setImage(PaintShop.getProgressIcon(0));
        this.statusProgressBar.setLayoutData(new GridData(36));
        this.stopOperationLoadBar = new ToolBar(composite, 0x800000);
        this.stopOperationLoadBar.setLayoutData(new GridData(36));
        if (GlobalSettings.isWindows()) {
            this.stopOperationLoadBar.setBackground(composite.getBackground());
        }
        this.stopOperationButton = new ToolItem(this.stopOperationLoadBar, 8);
        this.stopOperationButton.setImage(PaintShop.iconCancelOperation);
        this.stopOperationButton.setDisabledImage(PaintShop.iconCancelOperationDisabled);
        this.stopOperationButton.setToolTipText(GUI.i18n.getTranslation("BUTTON_CANCLE"));
        this.stopOperationButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                StatusLine.this.operationCanceld();
            }
        });
        this.skipFeedButton = new ToolItem(this.stopOperationLoadBar, 8);
        this.skipFeedButton.setImage(PaintShop.iconSkip);
        this.skipFeedButton.setDisabledImage(PaintShop.iconSkipDisabled);
        this.skipFeedButton.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_SKIP"));
        this.skipFeedButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (StatusLine.this.currentLoadingJob != null) {
                    StatusLine.this.currentLoadingJob.cancelJob(false);
                    StatusLine.this.finishJob(StatusLine.this.currentLoadingJob);
                }
            }
        });
        this.statusTextLabel = new Label(this.statusLineHolder, 0);
        this.statusTextLabel.setLayoutData(LayoutDataShop.createGridData(772, 1));
        this.statusTextLabel.setFont(FontShop.dialogFont);
        this.setStatusEnabled(false);
        this.setSkipFeedEnabled(false);
        Composite composite2 = new Composite(this.statusLineHolder, 0);
        composite2.setLayoutData(LayoutDataShop.createGridData(128, 1));
        composite2.setLayout(LayoutShop.createGridLayout(2, 0, 0, 0, 7, false));
        this.sepA = new Label(composite2, 2);
        GridData gridData = new GridData(32);
        gridData.heightHint = this.statusTextLabel.computeSize((int)-1, (int)-1).y;
        this.sepA.setLayoutData(gridData);
        this.rateStatusLabel = new Label(composite2, 0);
        this.rateStatusLabel.setLayoutData(LayoutDataShop.createGridData(128, 1));
        this.rateStatusLabel.setFont(FontShop.dialogFont);
        this.rateStatusLabel.setToolTipText("AmphetaRate");
        this.rateStatusLabel.setImage(PaintShop.iconNotRated);
        this.updateRateLabel("");
        Composite composite3 = new Composite(this.statusLineHolder, 0);
        composite3.setLayoutData(new GridData(128));
        composite3.setLayout(LayoutShop.createGridLayout(2, 3, 0, 0, 5, false));
        ((GridLayout)composite3.getLayout()).marginRight = GlobalSettings.isMac() ? 16 : 0;
        Label label = new Label(composite3, 2);
        GridData gridData2 = new GridData(32);
        gridData2.heightHint = this.statusTextLabel.computeSize((int)-1, (int)-1).y;
        label.setLayoutData(gridData2);
        this.dateLabel = new Label(composite3, 0);
        this.dateLabel.setLayoutData(new GridData(128));
        this.dateLabel.setFont(FontShop.dialogFont);
        this.updateDateLabel(true);
    }

    private void initJobLabel() {
        SEARCH_LABEL = GUI.i18n.getTranslation("SEARCH_FEED");
        RELOAD_LABEL = GUI.i18n.getTranslation("RELOAD_FEED");
        LOAD_LABEL = GUI.i18n.getTranslation("LOAD_FEED");
    }

    private void resetStatusLine() {
        this.loadingJobQueue.clear();
        if (this.statusLineAnimator != null) {
            this.statusLineAnimator.interrupt();
        }
        this.setupDefaults();
        if (GUI.isAlive() && !this.statusLineHolder.isDisposed()) {
            this.setStatusEnabled(false);
            this.setSkipFeedEnabled(false);
        }
    }

    private void setSkipFeedEnabled(boolean bl) {
        if (!this.stopOperationLoadBar.isDisposed() && !this.skipFeedButton.isDisposed()) {
            this.skipFeedButton.setEnabled(bl);
            this.skipFeedButton.setToolTipText(bl ? GUI.i18n.getTranslation("TOOLTIP_SKIP") : null);
        }
    }

    private void setStatusEnabled(boolean bl) {
        if (!this.stopOperationLoadBar.isDisposed() && !this.stopOperationButton.isDisposed()) {
            this.stopOperationButton.setEnabled(bl);
            this.stopOperationButton.setToolTipText(bl ? GUI.i18n.getTranslation("BUTTON_CANCLE") : null);
        }
        if (!this.statusProgressBar.isDisposed() && !bl) {
            this.statusProgressBar.setImage(PaintShop.getProgressIcon(0));
            this.statusProgressBar.update();
        }
        if (!this.statusTextLabel.isDisposed() && !bl) {
            this.statusTextLabel.setText(GUI.i18n.getTranslation("LABEL_READY"));
        }
        if (!this.statusLineHolder.isDisposed()) {
            this.statusLineHolder.layout(true);
        }
    }

    private void setStatusText(String string) {
        if (!this.statusTextLabel.isDisposed()) {
            this.statusTextLabel.setText(StringShop.escapeAmpersands(string));
            this.statusTextLabel.update();
        }
    }

    private void setupDefaults() {
        this.finishedLoad = 0;
        this.entireLoad = 0;
        this.currentLoadingJob = null;
    }

    private void startStatusAnimatorThread(int n) {
        this.statusLineAnimator = new StatusLineAnimator(this.display, this.rssOwlGui, this.statusProgressBar, n);
        this.statusLineAnimator.start();
    }

    private void updateDateLabel(boolean bl) {
        if (bl || Calendar.getInstance().get(5) != this.lastStatusDate.get(5)) {
            this.lastStatusDate = Calendar.getInstance();
            this.dateLabel.setText(DateParser.formatLongDate(this.lastStatusDate.getTime()));
            this.dateLabel.update();
        }
    }

    void operationCanceld() {
        for (int i = 0; i < this.loadingJobQueue.size(); ++i) {
            ((LoadJob)this.loadingJobQueue.get(i)).cancelJob(true);
        }
        if (this.rssOwlGui.getRSSOwlFeedQueueLoader().isRunning()) {
            this.rssOwlGui.getRSSOwlFeedQueueLoader().stopThread();
        }
        this.resetStatusLine();
    }
}

