/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.statusline;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.shop.PaintShop;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class StatusLineAnimator
extends Thread {
    private static final int PROGRESS_UPDATE_INTERVAL = 500;
    private Display display;
    int progress;
    GUI rssOwlGui;
    Label statusProgressBar;

    public StatusLineAnimator(Display display, GUI gUI, Label label, int n) {
        this.display = display;
        this.rssOwlGui = gUI;
        this.statusProgressBar = label;
        this.progress = n;
        this.setName("Status Line Animator Thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.isInterrupted() && GUI.isAlive() && !this.statusProgressBar.isDisposed()) {
            if (this.rssOwlGui.isBusyLoading()) {
                this.updateProgressBar(this.progress);
            }
            try {
                StatusLineAnimator.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            this.progress += this.progress == 100 ? -80 : 20;
        }
    }

    void updateProgressBar(final int n) {
        if (GUI.isAlive() && !this.isInterrupted()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!StatusLineAnimator.this.statusProgressBar.isDisposed() && StatusLineAnimator.this.rssOwlGui.isBusyLoading()) {
                        StatusLineAnimator.this.statusProgressBar.setImage(PaintShop.getProgressIcon(n));
                        if (!StatusLineAnimator.this.statusProgressBar.getParent().isDisposed()) {
                            StatusLineAnimator.this.statusProgressBar.getParent().layout();
                        }
                    }
                }
            });
        }
    }
}

