/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.statusline.LoadJob;
import net.sourceforge.rssowl.controller.thread.ExtendedThread;
import net.sourceforge.rssowl.dao.NewsfeedFactory;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.custom.CTabItem;

public class AggregationLoader {
    private static final int WAIT_CYCLE = 300;
    private boolean performSearch;
    private SearchDefinition searchDefinition;
    Category aggregatedCategory;
    Channel aggregatedRSSChannel;
    TreeSet favorites;
    boolean generateUniqueTitles;
    Vector innerFeedLoadThreads;
    boolean isReload;
    ExtendedThread outerNewsFeedLoader;
    Vector rssChannels;
    GUI rssOwlGui;
    int runningThreadCounter;
    int style;
    String title;

    public AggregationLoader(TreeSet treeSet, Category category, GUI gUI, String string) {
        this(treeSet, category, gUI, string, SearchDefinition.NO_SEARCH);
    }

    public AggregationLoader(TreeSet treeSet, Category category, GUI gUI, String string, SearchDefinition searchDefinition) {
        this.favorites = treeSet;
        this.aggregatedCategory = category;
        this.rssOwlGui = gUI;
        this.title = string;
        this.searchDefinition = searchDefinition;
        this.performSearch = StringShop.isset(searchDefinition.getPattern());
        this.rssChannels = new Vector();
        this.generateUniqueTitles = true;
        this.isReload = false;
        this.innerFeedLoadThreads = new Vector();
        this.runningThreadCounter = 0;
    }

    public void loadFavorites(boolean bl) {
        this.generateUniqueTitles = bl;
        this.createOuterFeedLoader(bl);
        this.style = 0;
        this.style = !bl ? 2 : (this.performSearch ? 1 : 0);
        this.rssOwlGui.getRSSOwlStatusLine().addEntireLoad(this.favorites.size());
        this.outerNewsFeedLoader.setName("Outer Multi Feed Load Thread");
        this.outerNewsFeedLoader.start();
    }

    public void setReload(boolean bl) {
        this.isReload = bl;
    }

    private void createOuterFeedLoader(final boolean bl) {
        this.outerNewsFeedLoader = new ExtendedThread(){

            @Override
            public void run() {
                Iterator iterator = AggregationLoader.this.favorites.iterator();
                while (iterator.hasNext() && !this.isStopped() && GUI.isAlive()) {
                    if (AggregationLoader.this.runningThreadCounter == GlobalSettings.maxConnectionCount) {
                        try {
                            1.sleep(300L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    String string = Category.getLinkForTitle((String)iterator.next());
                    ExtendedThread extendedThread = AggregationLoader.this.createInnerFeedLoader(string);
                    AggregationLoader.this.innerFeedLoadThreads.add(extendedThread);
                    extendedThread.start();
                    ++AggregationLoader.this.runningThreadCounter;
                }
                while (!AggregationLoader.this.isLoadingDone() && !this.isStopped()) {
                    try {
                        1.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                if (!this.isStopped() && GUI.isAlive()) {
                    GUI.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (GUI.isAlive() && (bl || AggregationLoader.this.rssOwlGui.getRSSOwlNewsTabFolder().isAggregationOpened(AggregationLoader.this.title))) {
                                if (!this.isStopped()) {
                                    AggregationLoader.this.createAggregatedRSSChannel();
                                }
                                if (!this.isStopped()) {
                                    AggregationLoader.this.displayRSSChannels();
                                }
                            }
                        }
                    });
                }
            }
        };
        this.outerNewsFeedLoader.setDaemon(true);
    }

    void createAggregatedRSSChannel() {
        this.aggregatedRSSChannel = new Channel(this.title, this.aggregatedCategory, this.rssChannels, this.favorites, this.generateUniqueTitles);
    }

    void createErrorChannel(String string, NewsfeedFactoryException newsfeedFactoryException) {
        this.rssChannels.add(Channel.createErrorChannel(string, newsfeedFactoryException));
        if (Category.getFavPool().containsKey(string)) {
            ((Favorite)Category.getFavPool().get(string)).updateErrorState(true);
        }
    }

    ExtendedThread createInnerFeedLoader(final String string) {
        ExtendedThread extendedThread = new ExtendedThread(){
            Channel currentRSSChannel;

            @Override
            public void run() {
                if (!StringShop.isset(string)) {
                    return;
                }
                final LoadJob loadJob = new LoadJob(string, Category.getTitleForLink(string), true, AggregationLoader.this.style, this);
                loadJob.setAggregationThread(AggregationLoader.this.outerNewsFeedLoader);
                boolean bl = false;
                if (AggregationLoader.this.isReload) {
                    AggregationLoader.this.rssOwlGui.getFeedCacheManager().unCacheNewsfeed(string, false);
                }
                if (GUI.isAlive() && !this.isStopped()) {
                    GUI.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AggregationLoader.this.rssOwlGui.getRSSOwlStatusLine().insertJob(loadJob);
                        }
                    });
                }
                if (string != null) {
                    block21: {
                        this.currentRSSChannel = null;
                        if (AggregationLoader.this.rssOwlGui.getFeedCacheManager().isNewsfeedCached(string, false) && !FileShop.exists(string)) {
                            this.currentRSSChannel = AggregationLoader.this.rssOwlGui.getFeedCacheManager().getCachedNewsfeed(string);
                            if (!this.isStopped() && this.currentRSSChannel != null) {
                                this.currentRSSChannel.updateReadStatusOnNews();
                            }
                        } else if (GlobalSettings.workOffline && AggregationLoader.this.rssOwlGui.getFeedCacheManager().isNewsfeedCached(string, true) && !FileShop.exists(string)) {
                            this.currentRSSChannel = AggregationLoader.this.rssOwlGui.getFeedCacheManager().getCachedNewsfeed(string);
                            if (!this.isStopped() && this.currentRSSChannel != null) {
                                this.currentRSSChannel.updateReadStatusOnNews();
                            }
                            AggregationLoader.this.rssOwlGui.getFeedCacheManager().cacheNewsfeed(string, this.currentRSSChannel);
                        } else if (GlobalSettings.workOffline && !FileShop.exists(string)) {
                            AggregationLoader.this.createErrorChannel(string, new NewsfeedFactoryException(string, null, null, 4));
                        } else if (!this.isStopped()) {
                            try {
                                this.currentRSSChannel = new NewsfeedFactory((Favorite)Category.getFavPool().get(string)).getRSSChannel();
                                bl = true;
                            }
                            catch (NewsfeedFactoryException newsfeedFactoryException) {
                                if (this.isStopped()) break block21;
                                AggregationLoader.this.createErrorChannel(string, newsfeedFactoryException);
                            }
                        }
                    }
                    if (GUI.isAlive() && !this.isStopped()) {
                        GUI.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                AggregationLoader.this.rssOwlGui.getRSSOwlStatusLine().finishJob(loadJob);
                            }
                        });
                    }
                    if (this.currentRSSChannel != null) {
                        if (!this.isStopped()) {
                            AggregationLoader.this.rssChannels.add(this.currentRSSChannel);
                        }
                        if (Category.getFavPool().containsKey(string) && !this.isStopped()) {
                            Favorite favorite = (Favorite)Category.getFavPool().get(string);
                            favorite.updateErrorState(false);
                            favorite.updateReadStatus(this.currentRSSChannel.getUnreadNewsCount());
                            favorite.syncMetaData(this.currentRSSChannel);
                        }
                        if (!this.isStopped() && bl) {
                            AggregationLoader.this.rssOwlGui.getFeedCacheManager().cacheNewsfeed(string, this.currentRSSChannel);
                        }
                        if (!this.isStopped() && GUI.isAlive()) {
                            GUI.display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CTabItem cTabItem = AggregationLoader.this.rssOwlGui.getRSSOwlNewsTabFolder().getFeedTabItem(string);
                                    if (WidgetShop.isset(cTabItem)) {
                                        AggregationLoader.this.rssOwlGui.getRSSOwlNewsTabFolder().displayNewsfeed(currentRSSChannel, string, SearchDefinition.NO_SEARCH, true, 1);
                                    }
                                }
                            });
                        }
                    }
                }
                --AggregationLoader.this.runningThreadCounter;
            }
        };
        extendedThread.setName("Inner Feed Loader Thread");
        extendedThread.setDaemon(true);
        return extendedThread;
    }

    void displayRSSChannels() {
        if (!GUI.isAlive()) {
            return;
        }
        this.rssOwlGui.getFeedCacheManager().cacheNewsfeed(this.title, this.aggregatedRSSChannel);
        this.rssOwlGui.displayNewsfeed(this.aggregatedRSSChannel, this.title, this.searchDefinition, true, 0);
    }

    boolean isLoadingDone() {
        for (int i = 0; i < this.innerFeedLoadThreads.size(); ++i) {
            ExtendedThread extendedThread = (ExtendedThread)this.innerFeedLoadThreads.get(i);
            if (extendedThread.isStopped() || !extendedThread.isAlive()) continue;
            return false;
        }
        return true;
    }
}

