/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.URLShop;

public class AmphetaRateThread
extends Thread {
    public static final int RATE_BAD = 2;
    public static final int RATE_FANTASTIC = 10;
    public static final int RATE_GOOD = 8;
    public static final int RATE_MODERATE = 5;
    public static final int RATE_VERY_BAD = 0;
    public static Hashtable ratedNews = new Hashtable();
    public static final String STATUS_OK = "OK";
    private static final String PARAM_CLIENT = "&client=rssowl";
    private static final String PARAM_HTML = "&html=0";
    private static final String PARAM_LINKINDESC = "&linkindesc=0";
    private static final String PARAM_ORIGURL = "&origurltag=1";
    public static final String PARAM_LIST = "&client=rssowl&html=0&origurltag=1&linkindesc=0&appname=RSSOwl1.2.3";
    private static final Hashtable ratings = new Hashtable();
    private static final String STATUS_ERROR = "error! abort!";
    private static final int SUBMIT_INTERVAL = 900000;
    private boolean isSubmitting;
    private boolean keepRunning;

    public AmphetaRateThread() {
        this.setName("AmphetaRate Submission Thread");
        this.keepRunning = true;
        this.isSubmitting = false;
        this.setDaemon(true);
    }

    public static Hashtable getRatings() {
        return ratings;
    }

    public static String getTranslatedRatingLevel(int n) {
        String string = GUI.i18n.getTranslation("RATE_MODERATE");
        if (n == 10) {
            string = GUI.i18n.getTranslation("RATE_FANTASTIC");
        } else if (n == 8) {
            string = GUI.i18n.getTranslation("RATE_GOOD");
        } else if (n == 2) {
            string = GUI.i18n.getTranslation("RATE_BAD");
        } else if (n == 0) {
            string = GUI.i18n.getTranslation("RATE_VERY_BAD");
        }
        return string;
    }

    public static boolean isOldUser() {
        return !GlobalSettings.amphetaRateUserID.equals("");
    }

    public static boolean rate(NewsItem newsItem, int n) {
        if (newsItem == null) {
            return false;
        }
        String string = newsItem.toAmphetaRateURL();
        if (string == null) {
            return false;
        }
        ratings.put(string, string + "&rating=" + n + "&appname=RSSOwl" + "1.2.3");
        ratedNews.put(string, new Integer(n));
        return true;
    }

    public static String register(String string, String string2, String string3) throws IOException {
        return FileShop.getContent(new URL(URLShop.AMPHETARATE_REGISTRATION_URL + "&alias=" + string + "&password=" + string2 + "&prevuid=" + string3));
    }

    private static boolean submitRating(String string) throws IOException {
        String string2 = FileShop.getContent(new URL(string));
        if (string2.indexOf(STATUS_OK) >= 0) {
            return true;
        }
        if (string2.equalsIgnoreCase(STATUS_ERROR)) {
            GUI.logger.log("AmphetaRate Status: " + string2 + " (URL: " + string + " / User: " + GlobalSettings.amphetaRateUsername + " / User ID: " + GlobalSettings.amphetaRateUserID + ")");
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            this.isSubmitting = true;
            Enumeration enumeration = ratings.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    if (this.isInterrupted() || !AmphetaRateThread.submitRating((String)ratings.get(string))) continue;
                    ratings.remove(string);
                }
                catch (IOException iOException) {
                    break;
                }
            }
            try {
                this.isSubmitting = false;
                AmphetaRateThread.sleep(900000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stopThread() {
        this.keepRunning = false;
        this.interrupt();
    }

    public void wakeUp() {
        if (!this.isSubmitting) {
            this.interrupt();
        }
    }
}

