/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.Favorite;

public class FeedAutoUpdater
extends Thread {
    public static int[] updateInterval = new int[]{0, 1, 5, 15, 30, 60, 180, 360, 720, 1440};
    public static String[] updateIntervalNames = new String[]{"UPDATE_INTERVAL_NO", "UPDATE_INTERVAL_ONE", "UPDATE_INTERVAL_FIVE", "UPDATE_INTERVAL_FIFTEEN", "UPDATE_INTERVAL_THIRTY", "UPDATE_INTERVAL_ONEHOUR", "UPDATE_INTERVAL_THREEHOURS", "UPDATE_INTERVAL_SIXHOURS", "UPDATE_INTERVAL_TWELVEHOURS", "UPDATE_INTERVAL_ONEDAY"};
    private static TreeSet dateList = new TreeSet();
    private static Hashtable feedList = new Hashtable();
    private static long uniqueCounter;
    private static final int UPDATE_INTERVAL = 5000;
    Favorite currentRSSOwlFavorite;
    GUI rssOwlGui;

    public FeedAutoUpdater(GUI gUI) {
        this.rssOwlGui = gUI;
        uniqueCounter = 0L;
        this.setDaemon(true);
        this.setName("Feed Update Thread");
    }

    public static synchronized void removeFavorite(Favorite favorite) {
        Enumeration enumeration = feedList.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!favorite.getUrl().equals(((Favorite)feedList.get(k)).getUrl())) continue;
            feedList.remove(k);
            dateList.remove(k);
            return;
        }
    }

    public static synchronized void updateFeedList(Favorite favorite) {
        FeedAutoUpdater.removeFavorite(favorite);
        if (favorite.getUpdateInterval() > 0) {
            long l = (long)(favorite.getUpdateInterval() * 1000 * 60) + System.currentTimeMillis() + ++uniqueCounter;
            feedList.put(new Date(l), favorite);
            dateList.add(new Date(l));
        }
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            if (!this.rssOwlGui.isBusyLoading() && dateList.iterator().hasNext()) {
                Date date = (Date)dateList.iterator().next();
                this.currentRSSOwlFavorite = null;
                if (date.before(new Date())) {
                    this.currentRSSOwlFavorite = (Favorite)feedList.get(date);
                }
                if (this.currentRSSOwlFavorite != null && !this.rssOwlGui.isBusyLoading() && GUI.isAlive()) {
                    GUI.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            FeedAutoUpdater.this.rssOwlGui.reloadNewsFeed(FeedAutoUpdater.this.currentRSSOwlFavorite.getUrl());
                        }
                    });
                    FeedAutoUpdater.updateFeedList(this.currentRSSOwlFavorite);
                }
            }
            try {
                FeedAutoUpdater.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

