/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.dialog.FeedDiscoveryDialog;
import net.sourceforge.rssowl.controller.thread.ExtendedThread;
import net.sourceforge.rssowl.dao.ConnectionManager;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.dao.feedparser.FeedParser;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FeedDiscoveryManager {
    private static final int COLLECTOR_THREAD_COUNT = 7;
    private ExtendedThread[] collectorThreads;
    private Thread discoveryThread;
    private Vector links;
    private int resultCounter;
    private URL webSiteURL;
    int collectorsDone;
    Vector normalUrlObjects;
    SAXBuilder[] parser = new SAXBuilder[7];
    Vector preferredUrlObjects;
    Random randomNumberGenerator;
    FeedDiscoveryDialog rssOwlFeedDiscoveryDialog;
    boolean running;
    boolean searchDone;

    public FeedDiscoveryManager(String string, FeedDiscoveryDialog feedDiscoveryDialog) throws MalformedURLException {
        this.webSiteURL = new URL(URLShop.canonicalize(string));
        this.rssOwlFeedDiscoveryDialog = feedDiscoveryDialog;
        this.searchDone = false;
        this.running = false;
        this.collectorsDone = 0;
        this.resultCounter = 0;
        this.links = new Vector();
        this.collectorThreads = new ExtendedThread[7];
        this.randomNumberGenerator = new Random();
        this.preferredUrlObjects = new Vector();
        this.normalUrlObjects = new Vector();
        this.initXMLParsers();
        this.filterLink(string);
        this.createSearchThread();
        this.createCollectorThreads();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startSearch() {
        this.running = true;
        for (int i = 0; i < 7; ++i) {
            this.collectorThreads[i].start();
        }
        this.discoveryThread.start();
    }

    public void stopSearch() {
        this.running = false;
        for (int i = 0; i < 7; ++i) {
            this.collectorThreads[i].stopThread();
            this.collectorThreads[i].interrupt();
        }
        this.discoveryThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildDocument(URL uRL, boolean bl, int n) {
        Object object;
        Document document = null;
        ConnectionManager connectionManager = new ConnectionManager(uRL.toExternalForm());
        try {
            connectionManager.setShowLoginDialogIfRequired(false);
            connectionManager.connect();
            InputStream inputStream = connectionManager.getInputStream();
            if (inputStream == null || !this.running) {
                Document document2 = null;
                return document2;
            }
            object = URLConnection.guessContentTypeFromStream(inputStream);
            if (object != null && !((String)object).equals("application/xml")) {
                Document document3 = document;
                return document3;
            }
            document = !bl ? this.parser[n].build(inputStream) : this.parser[n].build(new InputStreamReader(inputStream));
        }
        catch (JDOMException jDOMException) {
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            if (!bl) {
                object = this.buildDocument(uRL, true, n);
                return object;
            }
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            connectionManager.closeConnection();
        }
        return document;
    }

    private void createCollectorThreads() {
        for (int i = 0; i < 7; ++i) {
            final int n = i;
            this.collectorThreads[i] = new ExtendedThread("Feed Discovery Collector Thread #" + n){

                @Override
                public void run() {
                    block2: while (!this.isStopped() && !this.isInterrupted()) {
                        while (FeedDiscoveryManager.this.preferredUrlObjects.size() == 0 && FeedDiscoveryManager.this.normalUrlObjects.size() == 0 && !FeedDiscoveryManager.this.searchDone && !this.isStopped()) {
                            try {
                                1.sleep(500 + FeedDiscoveryManager.this.randomNumberGenerator.nextInt(500));
                            }
                            catch (InterruptedException interruptedException) {
                                break block2;
                            }
                        }
                        if (FeedDiscoveryManager.this.preferredUrlObjects.size() == 0 && FeedDiscoveryManager.this.normalUrlObjects.size() == 0 && FeedDiscoveryManager.this.searchDone) {
                            this.stopThread();
                            this.interrupt();
                        }
                        if (FeedDiscoveryManager.this.preferredUrlObjects.size() > 0 && FeedDiscoveryManager.this.running) {
                            FeedDiscoveryManager.this.buildChannel((URL)FeedDiscoveryManager.this.preferredUrlObjects.remove(0), n);
                            continue;
                        }
                        if (FeedDiscoveryManager.this.normalUrlObjects.size() <= 0 || !FeedDiscoveryManager.this.running) continue;
                        FeedDiscoveryManager.this.buildChannel((URL)FeedDiscoveryManager.this.normalUrlObjects.remove(0), n);
                    }
                    ++FeedDiscoveryManager.this.collectorsDone;
                }
            };
            this.collectorThreads[i].setDaemon(true);
        }
    }

    private void createSearchThread() {
        this.discoveryThread = new Thread("Feed Discovery Thread"){

            @Override
            public void run() {
                block6: {
                    try {
                        FeedDiscoveryManager.this.performSearch();
                        FeedDiscoveryManager.this.searchDone = true;
                        while (FeedDiscoveryManager.this.collectorsDone != 7) {
                            try {
                                2.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                                break;
                            }
                        }
                        FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.setSearching(false);
                        if (GUI.isAlive() && !FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.isSearching()) {
                            GUI.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.setButtonState(false);
                                    FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.stopStatusMessageAnimate();
                                    FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.setMessage(GUI.i18n.getTranslation("LABEL_SEARCH_FINISHED"));
                                }
                            });
                        }
                        FeedDiscoveryManager.this.running = false;
                    }
                    catch (IOException iOException) {
                        FeedDiscoveryManager.this.searchDone = true;
                        FeedDiscoveryManager.this.running = false;
                        if (this.isInterrupted() || !GUI.isAlive()) break block6;
                        GUI.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.stopStatusMessageAnimate();
                                FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.setErrorMessage(GUI.i18n.getTranslation("ERROR_CONNECTION_FAILED"));
                                FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.setButtonState(false);
                                FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.setSearching(false);
                            }
                        });
                    }
                }
            }
        };
        this.discoveryThread.setDaemon(true);
    }

    private void filterLink(String string) throws MalformedURLException {
        if (string.equals("http://www")) {
            return;
        }
        if (URLShop.looksLikeBinary(string)) {
            return;
        }
        if (!RegExShop.isValidURL(string)) {
            string = new URL(this.webSiteURL, string).toExternalForm();
        }
        string = URLShop.canonicalize(string);
        if (!this.links.contains(string = StringShop.replaceAll(string, "&amp;", "&")) && !this.rssOwlFeedDiscoveryDialog.getResults().containsKey(string)) {
            URL uRL = new URL(string);
            if (URLShop.looksLikeNewsfeed(uRL, false)) {
                this.preferredUrlObjects.add(uRL);
            } else {
                this.normalUrlObjects.add(uRL);
            }
            this.links.add(string);
        }
    }

    private void initXMLParsers() {
        for (int i = 0; i < 7; ++i) {
            this.parser[i] = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            this.parser[i].setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            XMLShop.setDefaultEntityResolver(this.parser[i]);
        }
    }

    void buildChannel(URL uRL, int n) {
        Document document = this.buildDocument(uRL, false, n);
        if (document == null) {
            return;
        }
        try {
            FeedParser feedParser = new FeedParser(document, uRL.toExternalForm());
            feedParser.parse();
            final Channel channel = feedParser.getChannel();
            if (channel == null) {
                return;
            }
            ++this.resultCounter;
            if (StringShop.isset(channel.getLink()) && !Category.linkExists(channel.getLink())) {
                GUI.rssOwlGui.getFeedCacheManager().cacheNewsfeed(channel.getLink(), channel);
            }
            if (GUI.isAlive()) {
                GUI.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FeedDiscoveryManager.this.running) {
                            FeedDiscoveryManager.this.rssOwlFeedDiscoveryDialog.addResultElement(channel.getLink(), channel.getTitle(), channel.getFormat());
                        }
                    }
                });
            }
        }
        catch (NewsfeedFactoryException newsfeedFactoryException) {
            // empty catch block
        }
    }

    void performSearch() throws IOException {
        Vector vector = URLShop.crawlUrls(this.webSiteURL.toExternalForm());
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            try {
                this.filterLink((String)iterator.next());
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }
}

