/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.io.File;
import java.io.IOException;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.ExtendedThread;
import net.sourceforge.rssowl.dao.SettingsSaver;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.SimpleFileShop;

public class SettingsManager
extends ExtendedThread {
    private static SettingsManager instance;
    private static final int SLEEP_INTERVAL = 20000;
    private boolean isSaveRequested;
    GUI rssOwlGui;

    private SettingsManager(GUI gUI) {
        this.rssOwlGui = gUI;
        this.setName("Settings Manager Thread");
        this.setDaemon(true);
    }

    public static SettingsManager getInstance() {
        if (instance == null) {
            instance = new SettingsManager(GUI.rssOwlGui);
        }
        return instance;
    }

    public void requestSave() {
        this.isSaveRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isStopped() && GUI.isAlive() && !this.isInterrupted()) {
            try {
                SettingsManager.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            if (this.isSaveRequested && !this.isStopped() && GUI.isAlive() && !this.isInterrupted()) {
                try {
                    this.internalSaveSettings();
                }
                catch (Exception exception) {
                    GUI.logger.log("SettingsManager#run()", exception);
                }
                finally {
                    this.isSaveRequested = false;
                }
            }
            if (this.isStopped() || !GUI.isAlive() || this.isInterrupted()) continue;
            try {
                this.rssOwlGui.getArchiveManager().flush();
            }
            catch (Exception exception) {
                GUI.logger.log("SettingsManager#run()", exception);
            }
        }
    }

    private void internalSaveSettings() {
        GUI.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                File file = new File(GlobalSettings.RSSOWL_SETTINGS_FILE);
                File file2 = new File(GlobalSettings.RSSOWL_SETTINGS_BACKUP_FILE);
                new SettingsSaver(SettingsManager.this.rssOwlGui).saveUserSettings(false);
                try {
                    SimpleFileShop.copy(file, file2);
                }
                catch (IOException iOException) {
                    GUI.logger.log("SettingsManager#run()", iOException);
                }
            }
        });
    }

    @Override
    public synchronized void stopThread() {
        super.stopThread();
        this.interrupt();
    }
}

