/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.RSSOwlLoader;
import net.sourceforge.rssowl.controller.thread.ExtendedThread;
import net.sourceforge.rssowl.util.shop.StringShop;

public class StartupManager {
    private static final String LOCALHOST = "127.0.0.1";
    private static final int RSSOWL_SOCKET_PORT = 8794;
    private static ExtendedThread server;
    private static final String DEFAULT_MESSAGE = "RSSOwl Startup Attempt";
    static ServerSocket applLockSocket;

    public static boolean isRSSOwlRunning(String string) {
        try {
            applLockSocket = new ServerSocket(8794, 50, InetAddress.getByName(LOCALHOST));
            StartupManager.handleSocketUnBound();
            return false;
        }
        catch (BindException bindException) {
            GUI.logger.log("StartupManager#run()", bindException);
            StartupManager.handleSocketBound(string);
            return true;
        }
        catch (IOException iOException) {
            GUI.logger.log("StartupManager#run()", iOException);
            return false;
        }
    }

    public static void stopServer() {
        if (server != null) {
            server.stopThread();
            server.interrupt();
            try {
                applLockSocket.close();
            }
            catch (IOException iOException) {
                GUI.logger.log("stopServer()", iOException);
            }
        }
    }

    private static void handleSocketBound(String string) {
        try {
            Socket socket = new Socket(InetAddress.getByName(LOCALHOST), 8794);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            printWriter.println(StringShop.isset(string) ? string : DEFAULT_MESSAGE);
            printWriter.flush();
        }
        catch (UnknownHostException unknownHostException) {
            GUI.logger.log("handleSocketBound()", unknownHostException);
        }
        catch (IOException iOException) {
            GUI.logger.log("handleSocketBound()", iOException);
        }
    }

    private static void handleSocketUnBound() {
        StartupManager.listen();
    }

    private static void listen() {
        server = new ExtendedThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!this.isStopped() && !this.isInterrupted()) {
                    BufferedReader bufferedReader = null;
                    try {
                        Socket socket = applLockSocket.accept();
                        bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        final String string = bufferedReader.readLine();
                        socket.close();
                        if (!StringShop.isset(string) || GUI.display == null || GUI.display.isDisposed()) continue;
                        GUI.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (GUI.isAlive()) {
                                    GUI.rssOwlGui.restoreWindow();
                                    if (RSSOwlLoader.isValidArgument(string)) {
                                        GUI.rssOwlGui.getEventManager().actionHandleSuppliedLink(string);
                                    }
                                }
                            }
                        });
                    }
                    catch (IOException iOException) {}
                    continue;
                    finally {
                        try {
                            if (bufferedReader == null) continue;
                            bufferedReader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        };
        server.setDaemon(true);
        server.setName("Startup Manager Thread");
        server.start();
    }
}

