/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.thread;

import java.io.IOException;
import java.net.URL;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.URLShop;

public class UpdateManager
extends Thread {
    public static final String MAJOR_VERSION = "1.2.3";
    public static final String MINOR_VERSION = "2006-11-26";
    private String changelog;
    private boolean displayNoNewVersionInfo;
    private String onlineVersion;
    private GUI rssOwlGui;
    private boolean showErrorMessage;

    public UpdateManager(GUI gUI) {
        this(gUI, true);
    }

    public UpdateManager(GUI gUI, boolean bl) {
        this.rssOwlGui = gUI;
        this.showErrorMessage = bl;
        this.displayNoNewVersionInfo = false;
        this.changelog = "";
        this.onlineVersion = UpdateManager.getPublicVersion();
        this.setName("Update Manager Thread");
        this.setDaemon(true);
    }

    public static String getPublicVersion() {
        return "1.2.3 2006-11-26";
    }

    @Override
    public void run() {
        block6: {
            try {
                this.getVersion();
                if (this.onlineVersion.indexOf(UpdateManager.getPublicVersion()) < 0 && this.onlineVersion.length() < 20) {
                    this.getChangelog();
                    if (GUI.isAlive()) {
                        GUI.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                UpdateManager.this.createInfoTab();
                            }
                        });
                    }
                } else if (this.displayNoNewVersionInfo && GUI.isAlive()) {
                    GUI.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            UpdateManager.this.createNoNewVersionInfo();
                        }
                    });
                }
            }
            catch (IOException iOException) {
                if (!this.showErrorMessage || !GUI.isAlive()) break block6;
                GUI.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UpdateManager.this.createErrorConnectInfo();
                    }
                });
            }
        }
    }

    public void setDisplayNoNewVersionInfo(boolean bl) {
        this.displayNoNewVersionInfo = bl;
    }

    private void getChangelog() throws IOException {
        this.changelog = FileShop.getContent(new URL(URLShop.RSSOWL_CHANGELOG_URL));
    }

    private void getVersion() throws IOException {
        this.onlineVersion = FileShop.getContent(new URL(URLShop.RSSOWL_UPDATE_URL));
    }

    void createErrorConnectInfo() {
        MessageBoxFactory.showError(GUI.shell, GUI.i18n.getTranslation("MESSAGEBOX_MESSAGE_CON_ERROR"));
    }

    void createInfoTab() {
        String string = GUI.i18n.getTranslation("DIALOG_TITLE_UPDATE") + ": RSSOwl " + this.onlineVersion.trim();
        this.rssOwlGui.getRSSOwlNewsTabFolder().showUpdateAvailableTab(string, this.changelog);
    }

    void createNoNewVersionInfo() {
        MessageBoxFactory.showMessage(GUI.shell, 2, GUI.i18n.getTranslation("MENU_UPDATE"), GUI.i18n.getTranslation("MESSAGEBOX_MESSAGE_UPDATE"));
    }
}

