/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.controller.tray;

import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.controller.tray.SystemTrayAlert;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class SystemTray {
    public static boolean trayIsTeasing = false;
    private static final int MIN_POPUP_GAP = 10000;
    private static final int RESTORE_DELAY = 100;
    private Display display;
    private MenuItem exitItem;
    private MenuItem markAllReadItem;
    private MenuItem openItem;
    private long popupTimeLock;
    private MenuItem reloadAllItem;
    private SystemTrayAlert rssOwlTrayPopup;
    private Listener shellIconifyListener;
    private Tray systemTray;
    boolean isMinimizedToTray;
    GUI rssOwlGui;
    Shell shell;
    TrayItem systemTrayItem;
    Menu systemTrayItemMenu;

    public SystemTray(Display display, Shell shell, GUI gUI) {
        this.rssOwlGui = gUI;
        this.display = display;
        this.shell = shell;
        this.isMinimizedToTray = false;
        this.initComponents();
        if (GlobalSettings.showTrayPopup) {
            SystemTrayAlert.getInstance(display, this);
        }
    }

    public void disable() {
        if (WidgetShop.isset(this.shell)) {
            this.shell.removeListener(19, this.shellIconifyListener);
        }
    }

    public boolean isMinimizedToTray() {
        return this.isMinimizedToTray;
    }

    public void resetPopupTimeLock() {
        this.popupTimeLock = 0L;
    }

    public void restoreWindow() {
        if (this.rssOwlTrayPopup != null && !this.rssOwlTrayPopup.isPopupClosed()) {
            this.rssOwlTrayPopup.hide();
        }
        if (GlobalSettings.isWindows()) {
            this.systemTrayItem.setVisible(false);
        }
        if (WidgetShop.isset(this.shell)) {
            this.shell.setVisible(true);
            this.shell.setActive();
            this.shell.setMinimized(false);
        }
        this.isMinimizedToTray = false;
    }

    public void setTrayItemState(boolean bl) {
        if (bl) {
            long l = System.currentTimeMillis();
            if (trayIsTeasing != bl || l - this.popupTimeLock > 10000L) {
                this.showTrayPopup();
                this.popupTimeLock = l;
            }
        }
        if (trayIsTeasing == bl && this.systemTrayItem.getImage() != null) {
            return;
        }
        trayIsTeasing = bl;
        if (this.systemTrayItem.getImage() != null) {
            this.systemTrayItem.getImage().dispose();
        }
        this.systemTrayItem.setImage(PaintShop.loadImage(bl ? "/img/trayowl_tease.gif" : "/img/trayowl.gif"));
        this.systemTrayItem.setToolTipText(bl ? "RSSOwl - " + GUI.i18n.getTranslation("TOOLTIP_UNREAD_AVAILABLE") : "RSSOwl");
    }

    public void updateI18N() {
        if (this.openItem != null) {
            this.openItem.setText(GUI.i18n.getTranslation("SYSTRAY_SHOW"));
        }
        if (this.reloadAllItem != null) {
            this.reloadAllItem.setText(GUI.i18n.getTranslation("BUTTON_RELOAD_ALL"));
        }
        if (this.markAllReadItem != null) {
            this.markAllReadItem.setText(GUI.i18n.getTranslation("BUTTON_MARK_ALL_READ"));
        }
        if (this.exitItem != null) {
            this.exitItem.setText(GUI.i18n.getTranslation("MENU_EXIT"));
        }
        this.systemTrayItem.setToolTipText(trayIsTeasing ? "RSSOwl - " + GUI.i18n.getTranslation("TOOLTIP_UNREAD_AVAILABLE") : "RSSOwl");
        if (WidgetShop.isset(this.systemTrayItemMenu)) {
            MenuManager.initMnemonics(this.systemTrayItemMenu);
        }
    }

    private void initComponents() {
        this.systemTray = this.display.getSystemTray();
        this.systemTrayItem = new TrayItem(this.systemTray, 0);
        this.setTrayItemState(trayIsTeasing);
        if (GlobalSettings.isWindows()) {
            this.systemTrayItem.setVisible(false);
        }
        this.systemTrayItem.addListener(35, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (WidgetShop.isset(SystemTray.this.systemTrayItemMenu)) {
                    SystemTray.this.systemTrayItemMenu.setVisible(true);
                }
            }
        });
        this.systemTrayItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                if (SystemTray.this.isMinimizedToTray) {
                    GUI.display.timerExec(100, new Runnable(){

                        @Override
                        public void run() {
                            SystemTray.this.restoreWindow();
                        }
                    });
                } else if (GlobalSettings.isLinux()) {
                    SystemTray.this.minimizeWindow();
                }
            }
        });
        this.systemTrayItemMenu = new Menu(this.shell, 8);
        this.reloadAllItem = new MenuItem(this.systemTrayItemMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.reloadAllItem.setImage(PaintShop.loadImage("/img/icons/reload_all.gif"));
            this.reloadAllItem.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.reloadAllItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SystemTray.this.rssOwlGui.getEventManager().actionReloadAllCategories();
            }
        });
        new MenuItem(this.systemTrayItemMenu, 2);
        this.markAllReadItem = new MenuItem(this.systemTrayItemMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.markAllReadItem.setImage(PaintShop.loadImage("/img/icons/mark_read.gif"));
            this.markAllReadItem.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.markAllReadItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SystemTray.this.rssOwlGui.getEventManager().actionMarkAllCategoriesRead();
            }
        });
        new MenuItem(this.systemTrayItemMenu, 2);
        this.openItem = new MenuItem(this.systemTrayItemMenu, 0);
        if (!GlobalSettings.isMac()) {
            this.openItem.setImage(PaintShop.loadImage("/img/icons/maximize.gif"));
            this.openItem.addDisposeListener(DisposeListenerImpl.getInstance());
        }
        this.openItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                SystemTray.this.restoreWindow();
            }
        });
        this.systemTrayItemMenu.setDefaultItem(this.openItem);
        new MenuItem(this.systemTrayItemMenu, 2);
        this.exitItem = new MenuItem(this.systemTrayItemMenu, 0);
        this.exitItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (GlobalSettings.isLinux() && !SystemTray.this.isMinimizedToTray) {
                    GlobalSettings.shellBounds = SystemTray.this.shell.getBounds();
                    GlobalSettings.isShellMaximized = SystemTray.this.shell.getMaximized();
                }
                GUI.isClosing = true;
                SystemTray.this.shell.dispose();
            }
        });
        this.updateI18N();
        this.shellIconifyListener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                SystemTray.this.minimizeWindow();
            }
        };
        this.shell.addListener(19, this.shellIconifyListener);
    }

    private void showTrayPopup() {
        if (GlobalSettings.showTrayPopup && this.isMinimizedToTray && (this.rssOwlTrayPopup == null || this.rssOwlTrayPopup.isPopupClosed())) {
            this.rssOwlTrayPopup = SystemTrayAlert.getInstance(this.display, this);
            this.rssOwlTrayPopup.show();
        }
    }

    void minimizeWindow() {
        if (GlobalSettings.isWindows()) {
            this.systemTrayItem.setVisible(true);
        }
        this.shell.setVisible(false);
        this.isMinimizedToTray = true;
    }
}

