/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.dialog.LoginDialog;
import net.sourceforge.rssowl.controller.thread.ExtendedThread;
import net.sourceforge.rssowl.dao.ssl.EasySSLProtocolSocketFactory;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.CryptoManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class ConnectionManager {
    private static final int HTTP_AUTH_REQUIRED = 401;
    private static final int HTTP_ERRORS = 400;
    private HttpClient client;
    private InputStream inputStream;
    private boolean showLoginDialogIfRequired;
    String domain;
    GetMethod getMethod;
    String password;
    String url;
    String userAgent;
    String username;

    public ConnectionManager(String string) {
        this.url = URLShop.canonicalize(string);
        this.username = null;
        this.password = null;
        this.showLoginDialogIfRequired = true;
        this.userAgent = BrowserShop.getOwlAgent();
        if (CryptoManager.getInstance().hasItem(string)) {
            String[] stringArray = CryptoManager.getInstance().getItem(string).split(" =;;= ");
            if (stringArray.length == 2) {
                this.username = stringArray[0];
                this.password = stringArray[1];
            } else if (stringArray.length == 3) {
                this.username = stringArray[0];
                this.password = stringArray[1];
                this.domain = stringArray[2];
            }
        }
    }

    public static void initSSLProtocol() {
        Protocol protocol = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
        Protocol.registerProtocol("https", protocol);
    }

    public void closeConnection() {
        if (this.getMethod != null) {
            this.getMethod.releaseConnection();
        }
    }

    public void connect() throws HttpException, IOException {
        boolean bl = ProxyShop.isUseProxy();
        if (Category.getFavPool().containsKey(this.url)) {
            Favorite favorite = (Favorite)Category.getFavPool().get(this.url);
            bl = ProxyShop.isUseProxy() && favorite.isUseProxy();
        }
        this.connect(bl);
    }

    public void connect(boolean bl) throws HttpException, IOException {
        this.initConnection();
        if (bl && this.proceed()) {
            ProxyShop.setUpProxy(this.client);
        }
        this.openConnection();
        this.pipeConnection();
        if (this.proceed() && this.getMethod.getStatusCode() >= 400) {
            throw new IOException(String.valueOf(this.getMethod.getStatusCode()));
        }
        if (this.proceed() && this.inputStream == null) {
            throw new IOException();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getStatusLine() {
        if (this.getMethod != null && this.getMethod.getStatusLine() != null) {
            return this.getMethod.getStatusLine().toString();
        }
        return null;
    }

    public void setShowLoginDialogIfRequired(boolean bl) {
        this.showLoginDialogIfRequired = bl;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    private void authenticate() throws URIException {
        if (this.username == null && this.showLoginDialogIfRequired && this.proceed()) {
            GUI.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    LoginDialog loginDialog;
                    int n;
                    boolean bl = false;
                    if (ConnectionManager.this.getMethod != null && ConnectionManager.this.getMethod.getHostAuthState().getAuthScheme() != null) {
                        bl = "ntlm".equals(ConnectionManager.this.getMethod.getHostAuthState().getAuthScheme().getSchemeName());
                    }
                    if ((n = (loginDialog = new LoginDialog(GUI.shell, GUI.i18n.getTranslation("BASE_AUTH_TITLE"), GUI.i18n.getTranslation("BASE_AUTH_MESSAGE"), ConnectionManager.this.url, bl)).open()) == 0) {
                        ConnectionManager.this.username = loginDialog.getUsername();
                        ConnectionManager.this.password = loginDialog.getPassword();
                        ConnectionManager.this.domain = loginDialog.getDomain();
                    }
                }
            });
        }
        if (this.username == null) {
            return;
        }
        String string = this.getMethod.getURI().getHost();
        NTCredentials nTCredentials = new NTCredentials(this.username, this.password, string, this.domain != null ? this.domain : "");
        this.client.getState().setCredentials(AuthScope.ANY, nTCredentials);
        this.getMethod.setDoAuthentication(true);
    }

    private void initConnection() throws IOException {
        this.client = new HttpClient();
        this.client.getHttpConnectionManager().getParams().setSoTimeout(GlobalSettings.connectionTimeout * 1000);
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(GlobalSettings.connectionTimeout * 1000);
        try {
            this.getMethod = new GetMethod(this.url);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException(runtimeException.getMessage());
        }
        this.getMethod.getParams().setCookiePolicy("ignoreCookies");
        this.setHeaders();
        this.getMethod.setFollowRedirects(true);
    }

    private void openConnection() throws HttpException, IOException {
        if (this.username != null) {
            this.client.getParams().setAuthenticationPreemptive(true);
            this.authenticate();
        }
        if (this.proceed()) {
            this.client.executeMethod(this.getMethod);
        }
        if (this.username != null && this.getMethod.getStatusCode() == 401) {
            this.client.getParams().setAuthenticationPreemptive(false);
            this.username = null;
        }
        if (!this.client.getParams().isAuthenticationPreemptive() && this.getMethod.getHostAuthState().isAuthRequested() && this.proceed()) {
            this.authenticate();
            this.client.executeMethod(this.getMethod);
        }
        if (this.proceed()) {
            this.inputStream = this.getMethod.getResponseBodyAsStream();
        }
    }

    private void pipeConnection() throws IOException {
        String string = this.getMethod.getResponseHeader("Content-Encoding") != null ? this.getMethod.getResponseHeader("Content-Encoding").getValue() : null;
        boolean bl = false;
        if (!(string != null && string.equals("gzip") || this.inputStream != null && this.inputStream.markSupported())) {
            return;
        }
        if (string != null && string.equals("gzip")) {
            bl = true;
        } else if (this.inputStream != null && this.inputStream.markSupported()) {
            this.inputStream.mark(2);
            int n = this.inputStream.read();
            int n2 = this.inputStream.read();
            this.inputStream.reset();
            if (n == 31 && n2 == 139) {
                bl = true;
            }
        }
        if (bl && this.proceed()) {
            this.inputStream = new GZIPInputStream(this.inputStream);
        }
    }

    private boolean proceed() {
        if (Thread.currentThread() instanceof ExtendedThread) {
            return !((ExtendedThread)Thread.currentThread()).isStopped();
        }
        return !Thread.currentThread().isInterrupted();
    }

    private void setHeaders() {
        this.getMethod.setRequestHeader("Accept-Encoding", "gzip, *");
        this.getMethod.setRequestHeader("User-Agent", this.userAgent);
    }

    static {
        ConnectionManager.initSSLProtocol();
    }
}

