/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Exporter {
    private Document document;

    public Exporter() {
        this.document = this.initExportToFile("opml version=\"1.1\"", "opml");
    }

    public Exporter(String string, String string2) {
        this.document = this.initExportToFile(string, string, string2);
    }

    public void exportCategoryToOPML(Category category) {
        if (this.document == null) {
            return;
        }
        Element element = this.prepareOPMLDocument(this.document);
        if (category == Category.getRootCategory()) {
            this.exportCategoryToOPML(category, element);
        } else {
            Element element2 = new Element("outline");
            element2.setAttribute("text", category.getName());
            element.addContent(element2);
            this.exportCategoryToOPML(category, element2);
        }
        XMLShop.writeXML(this.document, GlobalSettings.TEMP_EXPORT_FILE, true);
    }

    public void exportFavoriteToOPML(Favorite favorite, Category category) {
        if (this.document == null) {
            return;
        }
        Element element = this.prepareOPMLDocument(this.document);
        Element element2 = new Element("outline");
        element2.setAttribute("text", category.getName());
        element.addContent(element2);
        Element element3 = new Element("outline");
        element3.setAttribute("text", favorite.getTitle());
        element3.setAttribute("title", favorite.getTitle());
        element3.setAttribute("type", "rss");
        element3.setAttribute("xmlUrl", favorite.getUrl());
        if (favorite.getHomepage() != null) {
            element3.setAttribute("htmlUrl", favorite.getHomepage());
        }
        if (StringShop.isset(favorite.getLanguage())) {
            element3.setAttribute("language", favorite.getLanguage());
        }
        if (favorite.getDescription() != null) {
            element3.setAttribute("description", favorite.getDescription());
        }
        if (favorite.isOpenOnStartup()) {
            element3.setAttribute("openOnStartup", String.valueOf(true));
        }
        if (favorite.isLoadOnStartup()) {
            element3.setAttribute("loadOnStartup", String.valueOf(true));
        }
        if (favorite.isUseProxy()) {
            element3.setAttribute("useproxy", String.valueOf(true));
        }
        if (favorite.getUpdateInterval() != 0) {
            element3.setAttribute("rssOwlUpdateInterval", String.valueOf(favorite.getUpdateInterval()));
        }
        element2.addContent(element3);
        XMLShop.writeXML(this.document, GlobalSettings.TEMP_EXPORT_FILE, true);
    }

    public void exportResultsToOPML(Hashtable hashtable, String string) {
        if (this.document == null) {
            return;
        }
        Element element = this.prepareOPMLDocument(this.document);
        Element element2 = new Element("outline");
        element2.setAttribute("text", string);
        element.addContent(element2);
        Set set = hashtable.entrySet();
        for (Map.Entry entry : set) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            Element element3 = new Element("outline");
            element3.setAttribute("text", string3);
            element3.setAttribute("title", string3);
            element3.setAttribute("type", "rss");
            element3.setAttribute("xmlUrl", string2);
            element2.addContent(element3);
        }
        XMLShop.writeXML(this.document, GlobalSettings.TEMP_EXPORT_FILE, true);
    }

    public Document getDocument() {
        return this.document;
    }

    private void exportCategoryToOPML(Category category, Element element) {
        Favorite favorite;
        Object object;
        Object object2;
        TreeSet treeSet = category.getSortedSubCatTitles();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            object2 = (Category)category.getSubCategories().get(iterator.next());
            object = new Element("outline");
            ((Element)object).setAttribute("text", ((Category)object2).getName());
            element.addContent((Content)object);
            this.exportCategoryToOPML((Category)object2, (Element)object);
        }
        object2 = category.getFavorites();
        object = ((Hashtable)object2).elements();
        while (object.hasMoreElements() && !(favorite = (Favorite)object.nextElement()).isSynchronizer()) {
            Element element2 = new Element("outline");
            element2.setAttribute("text", favorite.getTitle());
            element2.setAttribute("title", favorite.getTitle());
            element2.setAttribute("type", "rss");
            element2.setAttribute("xmlUrl", favorite.getUrl());
            if (favorite.isOpenOnStartup()) {
                element2.setAttribute("openOnStartup", String.valueOf(true));
            }
            if (favorite.isLoadOnStartup()) {
                element2.setAttribute("loadOnStartup", String.valueOf(true));
            }
            if (favorite.isUseProxy()) {
                element2.setAttribute("useproxy", String.valueOf(true));
            }
            if (favorite.getUpdateInterval() != 0) {
                element2.setAttribute("rssOwlUpdateInterval", String.valueOf(favorite.getUpdateInterval()));
            }
            if (favorite.getHomepage() != null) {
                element2.setAttribute("htmlUrl", favorite.getHomepage());
            }
            if (StringShop.isset(favorite.getLanguage())) {
                element2.setAttribute("language", favorite.getLanguage());
            }
            if (favorite.getDescription() != null) {
                element2.setAttribute("description", favorite.getDescription());
            }
            element.addContent(element2);
        }
    }

    private Document initExportToFile(String string, String string2) {
        return this.initExportToFile(string, string2, GlobalSettings.TEMP_EXPORT_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document initExportToFile(String string, String string2, File file) {
        SAXBuilder sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        XMLShop.setDefaultEntityResolver(sAXBuilder);
        Document document = null;
        FileWriter fileWriter = null;
        String string3 = XMLShop.isEncodingSupported(GlobalSettings.charEncoding) ? GlobalSettings.charEncoding : "UTF-8";
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"" + string3 + "\"?>\n");
            fileWriter.write('<' + string + '>');
            fileWriter.write("</" + string2 + '>');
            fileWriter.close();
        }
        catch (IOException iOException) {
            GUI.logger.log("initExportToFile()", iOException);
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {
                GUI.logger.log("initExportToFile()", iOException);
            }
        }
        try {
            document = sAXBuilder.build(file);
            Comment comment = new Comment("XML generated by RSSOwl (http://www.rssowl.org) on " + DateParser.formatDate(new Date(), true));
            document.getContent().add(0, comment);
        }
        catch (JDOMException jDOMException) {
            GUI.logger.log("initExportToFile()", jDOMException);
        }
        catch (IOException iOException) {
            GUI.logger.log("initExportToFile()", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUI.logger.log("initExportToFile()", illegalArgumentException);
        }
        return document;
    }

    private Element prepareOPMLDocument(Document document) {
        Element element = document.getRootElement();
        Element element2 = new Element("head");
        element.addContent(element2);
        Element element3 = new Element("title");
        element3.setText("OPML generated by RSSOwl (http://www.rssowl.org)");
        element2.addContent(element3);
        Element element4 = new Element("dateCreated");
        element4.setText(DateParser.formatDate(new Date(), true));
        element2.addContent(element4);
        Element element5 = new Element("ownerName");
        String string = System.getProperty("user.name");
        element5.setText(string != null ? string : "RSSOwl");
        element2.addContent(element5);
        Element element6 = new Element("body");
        element.addContent(element6);
        return element6;
    }

    Document initExportToFile(String string, String string2, String string3) {
        return this.initExportToFile(string, string2, new File(string3));
    }
}

