/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.dao;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.AmphetaRateThread;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.CryptoManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.HotkeyShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;
import net.sourceforge.rssowl.util.shop.SimpleFileShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SettingsLoader {
    private Element root;
    private GUI rssOwlGui;

    public SettingsLoader(GUI gUI) {
        this(gUI, null);
    }

    public SettingsLoader(GUI gUI, Document document) {
        this.rssOwlGui = gUI;
        if (document == null) {
            document = this.buildSettingsDocument();
        }
        this.root = document.getRootElement();
    }

    public boolean getBoolean(String string, boolean bl) {
        Element element = this.root.getChild(string);
        if (element != null) {
            return Boolean.valueOf(element.getAttributeValue("value"));
        }
        return bl;
    }

    public String getValue(String string, String string2) {
        return this.getValue(string, string2, "", true);
    }

    public String getValue(String string, String string2, String string3) {
        return this.getValue(string, string2, string3, true);
    }

    public String getValue(String string, String string2, String string3, boolean bl) {
        Element element = this.root.getChild(string);
        String string4 = string3;
        if (element != null) {
            string4 = string2 != null ? element.getAttributeValue(string2) : element.getText();
        }
        if (string4 == null) {
            string4 = string3;
        }
        if (bl) {
            return string4.trim();
        }
        return string4;
    }

    public RGB loadColor(String string, RGB rGB) {
        Element element = this.root.getChild(string);
        if (element != null) {
            int n = Integer.parseInt(element.getAttributeValue("red"));
            int n2 = Integer.parseInt(element.getAttributeValue("green"));
            int n3 = Integer.parseInt(element.getAttributeValue("blue"));
            return new RGB(n, n2, n3);
        }
        return rGB;
    }

    public void loadFavorites() {
        Element element = this.root.getChild("favorites");
        if (element != null) {
            this.loadFavorites(Category.getRootCategory(), element);
        }
    }

    public Font loadFont(Font font, String string, boolean bl) {
        Font font2;
        Element element = this.root.getChild(string);
        if (element != null && FontShop.isset(font2 = FontShop.createFont(element.getAttributeValue("name"), Integer.parseInt(element.getAttributeValue("height")), Integer.parseInt(element.getAttributeValue("style"))))) {
            if (!bl && FontShop.isset(font)) {
                font.dispose();
            }
            return font2;
        }
        return font;
    }

    public void loadHotKeys() {
        Element element = this.root.getChild("hotkeys");
        if (element != null) {
            List list = element.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                HotkeyShop.setHotkey(element2.getName(), element2.getAttributeValue("keyName"), element2.getAttributeValue("keyInt"));
            }
        }
    }

    public void loadProxySettings() {
        String string = "false";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Element element = this.root.getChild("proxy");
        if (element != null) {
            string = element.getChild("proxySet").getText();
            string2 = element.getChild("proxyHost").getText();
            string3 = element.getChild("proxyPort").getText();
            string4 = CryptoManager.getInstance().loadProxyUser();
            string5 = CryptoManager.getInstance().loadProxyPassword();
            string6 = CryptoManager.getInstance().loadProxyDomain();
        }
        ProxyShop.setUseProxy(string);
        ProxyShop.setHost(string2);
        ProxyShop.setPort(string3);
        ProxyShop.setUsername(string4);
        ProxyShop.setPassword(string5);
        ProxyShop.setDomain(string6);
    }

    public void loadRatings() {
        List list = this.root.getChildren("rating");
        if (list != null) {
            for (Element element : list) {
                AmphetaRateThread.getRatings().put(element.getAttributeValue("key"), element.getText());
            }
        }
    }

    public void loadReopenFeeds() {
        Element element = this.root.getChild("reopenFeedsList");
        if (element != null) {
            List list = element.getChildren("feed");
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                if (element2.getAttributeValue("url") == null) continue;
                this.rssOwlGui.getRSSOwlFeedQueueLoader().addFeed(element2.getAttributeValue("url"));
                if (!GlobalSettings.displaySingleTab) continue;
                return;
            }
        }
    }

    public void loadSashWeights() {
        List list = this.root.getChildren("sashweight");
        if (list != null) {
            for (Element element : list) {
                int n;
                String string = element.getAttributeValue("name");
                String[] stringArray = element.getAttributeValue("weight").split(",");
                if ("holdContentSash".equals(string)) {
                    GlobalSettings.contentSashWeights = new int[stringArray.length];
                    for (n = 0; n < stringArray.length; ++n) {
                        GlobalSettings.contentSashWeights[n] = Integer.parseInt(stringArray[n]);
                    }
                    continue;
                }
                if (!"holdNewsSash".equals(string)) continue;
                GlobalSettings.newsSashWeights = new int[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    GlobalSettings.newsSashWeights[n] = Integer.parseInt(stringArray[n]);
                }
            }
        }
    }

    public void loadShellBounds() {
        Element element = this.root.getChild("shell");
        if (element != null) {
            if (element.getAttribute("height") != null) {
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                rectangle.height = Integer.parseInt(element.getAttributeValue("height"));
                rectangle.width = Integer.parseInt(element.getAttributeValue("width"));
                rectangle.x = Integer.parseInt(element.getAttributeValue("x"));
                rectangle.y = Integer.parseInt(element.getAttributeValue("y"));
                GlobalSettings.shellBounds = rectangle;
            }
            if (element.getAttribute("maximized") != null && !GlobalSettings.isMac()) {
                GlobalSettings.isShellMaximized = Boolean.valueOf(element.getAttributeValue("maximized"));
            }
        } else {
            GlobalSettings.isShellMaximized = true;
        }
    }

    public ArrayList loadSortOrder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.root.getChild("sortOrder") != null) {
            Element element = this.root.getChild("sortOrder");
            List list = element.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                int n = Integer.parseInt(element2.getAttributeValue("level"));
                arrayList.add(n, element2.getName());
            }
        } else {
            for (int i = 0; i < GlobalSettings.defaultSortOrder.length; ++i) {
                arrayList.add(GlobalSettings.defaultSortOrder[i]);
            }
        }
        return arrayList;
    }

    private Document buildSettingsDocument() {
        SAXBuilder sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        XMLShop.setDefaultEntityResolver(sAXBuilder);
        File file = new File(GlobalSettings.RSSOWL_SETTINGS_FILE);
        File file2 = new File(GlobalSettings.RSSOWL_SETTINGS_BACKUP_FILE);
        String string = XMLShop.isEncodingSupported(GlobalSettings.charEncoding) ? GlobalSettings.charEncoding : "UTF-8";
        try {
            if (file.exists()) {
                Document document = sAXBuilder.build(file);
                SimpleFileShop.copy(file, file2);
                return document;
            }
        }
        catch (JDOMException jDOMException) {
            GUI.logger.log("buildSettingsDocument()", jDOMException);
        }
        catch (IOException iOException) {
            GUI.logger.log("buildSettingsDocument()", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUI.logger.log("buildSettingsDocument()", illegalArgumentException);
        }
        try {
            if (file2.exists()) {
                return sAXBuilder.build(file2);
            }
        }
        catch (JDOMException jDOMException) {
            GUI.logger.log("buildSettingsDocument()", jDOMException);
        }
        catch (IOException iOException) {
            GUI.logger.log("buildSettingsDocument()", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUI.logger.log("buildSettingsDocument()", illegalArgumentException);
        }
        try {
            return sAXBuilder.build(this.getClass().getResourceAsStream("/usr/user.xml"), string);
        }
        catch (JDOMException jDOMException) {
            GUI.logger.log("buildSettingsDocument()", jDOMException);
        }
        catch (IOException iOException) {
            GUI.logger.log("buildSettingsDocument()", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUI.logger.log("buildSettingsDocument()", illegalArgumentException);
        }
        return null;
    }

    private Category loadCategory(Category category, Element element) {
        String string = element.getAttributeValue("name");
        Category category2 = new Category(string, category, false);
        String string2 = element.getAttributeValue("isExpanded");
        if (StringShop.isset(string2)) {
            category2.setExpanded(Boolean.valueOf(string2));
        }
        return category2;
    }

    private Favorite loadFavorite(Category category, Element element) {
        String string = "";
        String string2 = "";
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (element.getText() != null) {
            string = element.getText();
        }
        string = Category.createUniqueLink(string);
        if (element.getAttributeValue("title") != null) {
            string2 = element.getAttributeValue("title");
        }
        string2 = Category.createUniqueTitle(string2);
        String string3 = element.getAttributeValue("useproxy");
        if (StringShop.isset(string3)) {
            bl = Boolean.valueOf(string3);
        }
        if (StringShop.isset(string3 = element.getAttributeValue("errorLoading"))) {
            bl2 = Boolean.valueOf(string3);
        }
        if (StringShop.isset(string3 = element.getAttributeValue("loadOnStartup"))) {
            bl3 = Boolean.valueOf(string3);
        }
        if (StringShop.isset(string3 = element.getAttributeValue("openOnStartup")) && (bl4 = Boolean.valueOf(string3).booleanValue())) {
            this.rssOwlGui.getRSSOwlFeedQueueLoader().addFeed(string);
        }
        if (StringShop.isset(string3 = element.getAttributeValue("updateInterval"))) {
            n = Integer.parseInt(string3);
        }
        Favorite favorite = new Favorite(string, string2, category);
        favorite.setUseProxy(bl);
        favorite.setErrorLoading(bl2);
        favorite.setLoadOnStartup(bl3);
        favorite.setOpenOnStartup(bl4);
        favorite.setUpdateInterval(n);
        string3 = element.getAttributeValue("new");
        if (StringShop.isset(string3)) {
            favorite.setUnreadNewsCount(Integer.parseInt(string3));
        }
        if (StringShop.isset(string3 = element.getAttributeValue("description"))) {
            favorite.setDescription(string3);
        }
        if (StringShop.isset(string3 = element.getAttributeValue("homepage"))) {
            favorite.setHomepage(string3);
        }
        if (StringShop.isset(string3 = element.getAttributeValue("language"))) {
            favorite.setLanguage(string3);
        }
        if (StringShop.isset(string3 = element.getAttributeValue("creationDate"))) {
            favorite.setCreationDate(Long.parseLong(string3));
        } else {
            favorite.setCreationDate(new Date().getTime());
        }
        string3 = element.getAttributeValue("lastVisitDate");
        if (StringShop.isset(string3)) {
            favorite.setLastVisitDate(Long.parseLong(string3));
        }
        return favorite;
    }

    private void loadFavorites(Category category, Element element) {
        List list = element.getChildren();
        for (Element element2 : list) {
            if (element2.getName().equals("category")) {
                Category category2 = this.loadCategory(category, element2);
                category.addCategory(category2);
                if (element2.getAttribute("url") != null) {
                    category2.setBlogroll(true);
                    category2.setUseProxy(Boolean.valueOf(element2.getAttributeValue("useproxy")));
                    category2.setPathToBlogroll(element2.getAttributeValue("url"));
                    category2.setUnSynchronized(true);
                    Favorite favorite = new Favorite(category2.getPathToBlogroll(), GUI.i18n.getTranslation("LOAD_FEED") + " (" + category2.getPathToBlogroll() + ")", category2);
                    favorite.setSynchronizer(true);
                    category2.addFavorite(favorite);
                    continue;
                }
                this.loadFavorites(category2, element2);
                continue;
            }
            if (!element2.getName().equals("link")) continue;
            category.addFavorite(this.loadFavorite(category, element2));
        }
    }
}

