/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.AmphetaRateThread;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Enclosure;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.URLShop;
import org.eclipse.swt.graphics.FontData;
import org.jdom.Text;

public class NewsItem {
    private static final int MAX_TITLE_LENGTH = 80;
    private String author;
    private String baseUri;
    private String category;
    private Vector comments;
    private String description;
    private Vector enclosures;
    private String guid;
    private Vector highlightWords;
    private boolean isPartOfAggregation;
    private boolean isRead = false;
    private boolean isSearchCaseSensitive;
    private String link;
    private Vector linkList;
    private String newsFeedHomepage;
    private String newsfeedTitle;
    private String newsfeedXmlUrl;
    private String origurl;
    private String pubDate;
    private Date pubDateParsed;
    private String publisher;
    private String source;
    private String title;
    private boolean updateNewsView = false;

    public NewsItem() {
        this(false);
    }

    public NewsItem(boolean bl) {
        this.isPartOfAggregation = bl;
        if (!GlobalSettings.useBrowserForNewsText) {
            this.linkList = new Vector();
        }
    }

    public void addComment(String string) {
        if (this.comments == null) {
            this.comments = new Vector();
        }
        this.comments.add(string);
        if (this.linkList != null && !GlobalSettings.useBrowserForNewsText && URLShop.looksLikeURL(string)) {
            this.linkList.add(string);
        }
    }

    public void clearHighlightWords() {
        if (this.highlightWords != null) {
            this.highlightWords.clear();
        }
    }

    public void clone(NewsItem newsItem) {
        int n;
        newsItem.setAuthor(this.author);
        newsItem.setCategory(this.category);
        newsItem.setDescription(this.description);
        newsItem.setGuid(this.guid);
        newsItem.setRead(this.isRead);
        newsItem.setLink(this.link);
        newsItem.setNewsfeedTitle(this.newsfeedTitle);
        newsItem.setNewsfeedXmlUrl(this.newsfeedXmlUrl);
        newsItem.setNewsfeedHomepage(this.newsFeedHomepage);
        newsItem.setOrigurl(this.origurl);
        newsItem.setPubDate(this.pubDate, false);
        newsItem.setPubDateParsed(this.pubDateParsed);
        newsItem.setPublisher(this.publisher);
        newsItem.setSource(this.source);
        newsItem.setTitle(this.title);
        if (this.comments != null) {
            for (n = 0; n < this.comments.size(); ++n) {
                newsItem.addComment((String)this.comments.get(n));
            }
        }
        if (this.enclosures != null) {
            for (n = 0; n < this.enclosures.size(); ++n) {
                newsItem.insertEnclosure((Enclosure)this.enclosures.get(n));
            }
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCategory() {
        return this.category;
    }

    public Vector getComments() {
        return this.comments;
    }

    public String getDescription() {
        return this.description;
    }

    public Vector getEnclosures() {
        return this.enclosures;
    }

    public String getGuid() {
        return this.guid;
    }

    public Vector getHighlightWords() {
        return this.highlightWords;
    }

    public String getLink() {
        return this.link;
    }

    public Vector getLinkList() {
        return this.linkList;
    }

    public String getNewsfeedHomepage() {
        return this.newsFeedHomepage;
    }

    public String getNewsfeedTitle() {
        return this.newsfeedTitle;
    }

    public String getNewsfeedXmlUrl() {
        return this.newsfeedXmlUrl;
    }

    public String getOrigurl() {
        return this.origurl;
    }

    public String getPubDate() {
        return this.pubDate;
    }

    public Date getPubDateParsed() {
        return this.pubDateParsed;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public boolean getRequiresViewUpdate() {
        return this.updateNewsView;
    }

    public String getSafeXMLFeedUrl() {
        String string = this.getNewsfeedXmlUrl();
        if (string == null) {
            return null;
        }
        if (this.isPartOfAggregation) {
            string = this.getNewsfeedTitle();
        }
        if (string == null) {
            return null;
        }
        String string2 = Category.getLinkForTitle(string);
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public String getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public void insertEnclosure(Enclosure enclosure) {
        if (this.enclosures == null) {
            this.enclosures = new Vector();
        }
        this.enclosures.add(enclosure);
        if (!GlobalSettings.useBrowserForNewsText && enclosure.getUrl() != null) {
            this.parseForLinks(enclosure.getUrl());
        }
    }

    public void insertHighlightWord(String string) {
        if (this.highlightWords == null) {
            this.highlightWords = new Vector();
        }
        if (StringShop.isset(string) && !this.highlightWords.contains(string)) {
            this.highlightWords.add(string);
        }
        if (!this.getRequiresViewUpdate()) {
            this.setRequiresViewUpdate(true);
        }
    }

    public boolean isPartOfAggregation() {
        return this.isPartOfAggregation;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public boolean isSearchCaseSensitive() {
        return this.isSearchCaseSensitive;
    }

    public boolean sameAs(NewsItem newsItem) {
        if (newsItem == null) {
            return false;
        }
        if (this.getTitle() != null && !this.getTitle().equals(newsItem.getTitle())) {
            return false;
        }
        if (this.getTitle() == null && newsItem.getTitle() != null) {
            return false;
        }
        if (this.getLink() != null && !this.getLink().equals(newsItem.getLink())) {
            return false;
        }
        if (this.getLink() == null && newsItem.getLink() != null) {
            return false;
        }
        if (this.getSafeXMLFeedUrl() != null && !this.getSafeXMLFeedUrl().equals(newsItem.getSafeXMLFeedUrl())) {
            return false;
        }
        if (this.getSafeXMLFeedUrl() == null && newsItem.getSafeXMLFeedUrl() != null) {
            return false;
        }
        if (this.getDescription() != null && !this.getDescription().equals(newsItem.getDescription())) {
            return false;
        }
        return this.getDescription() != null || newsItem.getDescription() == null;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void setBaseUri(String string) {
        this.baseUri = string;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public void setDescription(String string) {
        this.description = string;
        if (!GlobalSettings.useBrowserForNewsText) {
            this.parseForLinks(string);
        }
    }

    public void setGuid(String string) {
        this.guid = string;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public void setNewsfeedHomepage(String string) {
        this.newsFeedHomepage = string;
    }

    public void setNewsfeedTitle(String string) {
        this.newsfeedTitle = string;
    }

    public void setNewsfeedXmlUrl(String string) {
        this.newsfeedXmlUrl = string;
    }

    public void setOrigurl(String string) {
        this.origurl = string;
    }

    public void setPubDate(String string, boolean bl) {
        this.pubDate = string;
        if (bl) {
            this.pubDateParsed = DateParser.getDate(string);
        }
    }

    public void setPubDateParsed(Date date) {
        this.pubDateParsed = date;
    }

    public void setPublisher(String string) {
        this.publisher = string;
    }

    public void setRead(boolean bl) {
        this.isRead = bl;
    }

    public void setRequiresViewUpdate(boolean bl) {
        this.updateNewsView = bl;
    }

    public void setSearchCaseSensitive(boolean bl) {
        this.isSearchCaseSensitive = bl;
    }

    public void setSource(String string) {
        this.source = string;
        if (this.linkList != null && !GlobalSettings.useBrowserForNewsText && URLShop.looksLikeURL(string)) {
            this.linkList.add(string);
        } else if (!GlobalSettings.useBrowserForNewsText) {
            this.parseForLinks(string);
        }
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }

    public void setTitle(String string, boolean bl) {
        this.setTitle(string, bl, true);
    }

    public void setTitle(String string, boolean bl, boolean bl2) {
        String string2 = string;
        if (bl2) {
            string = StringShop.stripTags(string);
        }
        if (StringShop.isWhiteSpaceOrEmpty(string)) {
            string = string2;
            bl = false;
            int n = string.lastIndexOf(62, 80);
            if (n > 0) {
                string = string.substring(0, n + 1);
            }
        }
        if (bl) {
            string = StringShop.hrTrim(string, 80);
        }
        this.title = string = Text.normalizeString(string);
    }

    public String toAmphetaRateURL() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = this.getNewsfeedXmlUrl();
        if (this.isPartOfAggregation) {
            string5 = this.getNewsfeedTitle();
        }
        if (Category.getLinkForTitle(string5) != null) {
            string5 = Category.getLinkForTitle(string5);
        }
        string5 = URLShop.urlEncode(string5);
        if (this.getTitle() != null) {
            string = URLShop.urlEncode(this.getTitle()).replaceAll("\\+", "%20");
        }
        if (this.getDescription() != null) {
            string2 = Text.normalizeString(this.getDescription());
        }
        if (this.getGuid() != null) {
            string4 = this.getGuid();
        }
        if (string2.length() > 100) {
            string2 = string2.substring(0, 100);
        }
        string2 = URLShop.urlEncode(string2).replaceAll("\\+", "%20");
        if (this.getLink() == null && string4 != null && RegExShop.isValidURL(string4)) {
            string3 = URLShop.urlEncode(string4);
        } else if (this.getLink() != null) {
            string3 = URLShop.urlEncode(this.getLink());
        }
        if (string.equals("") && string2.equals("")) {
            return null;
        }
        if (string5.equals("")) {
            return null;
        }
        String string6 = "http://amphetarate.sourceforge.net/dinka-add-rating.php?title=" + string + "&xmlurl=" + string5 + "&desc=" + string2 + "&link=" + string3;
        string6 = AmphetaRateThread.isOldUser() ? string6 + "&user=" + GlobalSettings.amphetaRateUserID : string6 + "&alias=" + GlobalSettings.amphetaRateUsername + "&password=" + GlobalSettings.amphetaRatePassword;
        if (StringShop.isset(string4)) {
            string6 = string6 + "&guid=" + URLShop.urlEncode(string4);
        }
        return string6;
    }

    public String toHTML() {
        CharSequence charSequence;
        String string;
        Object object;
        int n;
        String string2;
        FontData[] fontDataArray = FontShop.textFont.getFontData();
        String string3 = fontDataArray[0].getName();
        String string4 = String.valueOf(fontDataArray[0].getHeight());
        String string5 = GlobalSettings.isMac() ? "px" : "pt";
        String string6 = GlobalSettings.isMac() ? "" : "margin:8px; ";
        boolean bl = (fontDataArray[0].getStyle() & 1) != 0;
        boolean bl2 = (fontDataArray[0].getStyle() & 2) != 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        if (GlobalSettings.isWindows()) {
            stringBuffer.append("\n").append("<!-- saved from url=(0014)about:internet -->").append("\n");
        }
        stringBuffer.append("<html><head><title>");
        stringBuffer.append(this.getTitle());
        stringBuffer.append("</title>");
        String string7 = string2 = StringShop.isset(this.baseUri) ? this.baseUri : this.getSafeXMLFeedUrl();
        if (StringShop.isset(string2)) {
            stringBuffer.append("<base href=\"").append(string2).append("\">");
        }
        stringBuffer.append("</head><body style='");
        stringBuffer.append(string6);
        stringBuffer.append("overflow:auto; font-family:");
        stringBuffer.append(string3);
        if (bl) {
            stringBuffer.append("; font-weight:bold");
        }
        if (bl2) {
            stringBuffer.append("; font-style:italic");
        }
        stringBuffer.append("; font-size:");
        stringBuffer.append(string4);
        stringBuffer.append(string5);
        stringBuffer.append(";'>");
        if (StringShop.isset(this.getDescription())) {
            stringBuffer.append(this.getDescription());
        } else {
            stringBuffer.append(GUI.i18n.getTranslation("NEWS_NO_DESCRIPTION"));
        }
        if (this.enclosures != null && this.enclosures.size() > 0) {
            stringBuffer.append("<br /><br /><b>");
            stringBuffer.append(GUI.i18n.getTranslation("NEWS_ITEM_INFO_ENCLOSURE"));
            stringBuffer.append(":</b><br />");
            for (n = 0; n < this.enclosures.size(); ++n) {
                object = (Enclosure)this.enclosures.get(n);
                string = ((Enclosure)object).getUrl();
                try {
                    URL uRL = new URL(string);
                    charSequence = StringShop.createAnchor(string, URLShop.getFile(uRL));
                }
                catch (MalformedURLException malformedURLException) {
                    charSequence = string;
                }
                stringBuffer.append("<br />");
                stringBuffer.append((String)charSequence);
                stringBuffer.append(" (");
                stringBuffer.append(((Enclosure)object).getType());
                stringBuffer.append(" / ");
                stringBuffer.append(((Enclosure)object).getLength(true));
                stringBuffer.append(")");
            }
        }
        if (this.getSource() != null) {
            stringBuffer.append("<br /><br /><b>");
            stringBuffer.append(GUI.i18n.getTranslation("NEWS_ITEM_INFO_SOURCE"));
            stringBuffer.append(":</b>  ");
            stringBuffer.append(URLShop.looksLikeURL(this.getSource()) ? StringShop.createAnchor(this.getSource()) : this.getSource());
        }
        if (this.comments != null && this.comments.size() > 0) {
            stringBuffer.append("<br /><br /><b>");
            stringBuffer.append(GUI.i18n.getTranslation("NEWS_ITEM_INFO_COMMENTS"));
            stringBuffer.append(":</b><br />");
            for (n = 0; n < this.comments.size(); ++n) {
                object = (String)this.comments.get(n);
                if (!StringShop.isset((String)object)) continue;
                stringBuffer.append("<br />").append((String)(URLShop.looksLikeURL((String)object) ? StringShop.createAnchor((String)object) : object));
            }
        }
        stringBuffer.append("</body></html>");
        String string8 = new String(stringBuffer);
        if (this.highlightWords != null) {
            for (int i = 0; i < this.highlightWords.size(); ++i) {
                string = (String)this.highlightWords.get(i);
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("<span style='background-color:rgb(").append(PaintShop.syntaxHighlightColor.getRed());
                ((StringBuffer)charSequence).append(", ").append(PaintShop.syntaxHighlightColor.getGreen()).append(", ");
                ((StringBuffer)charSequence).append(PaintShop.syntaxHighlightColor.getBlue()).append(");'>").append(string).append("</span>");
                if (RegExShop.isInsideTags(string8, string)) continue;
                string8 = StringShop.replaceAll(string8, string, ((StringBuffer)charSequence).toString());
            }
        }
        return string8;
    }

    public String toNewsTip() {
        String string = "mailto:";
        String string2 = GlobalSettings.mailSubject;
        String string3 = GlobalSettings.mailBody;
        String string4 = "\n\n-----\nGet RSSOwl - The Opensource Newsreader - http://www.rssowl.org";
        String string5 = this.getLink();
        String string6 = this.getTitle();
        String string7 = this.getDescription();
        if (string5 == null) {
            string5 = this.getGuid();
        }
        string3 = StringShop.replaceAll(string3, "[TITLE]", string6);
        string2 = StringShop.replaceAll(string2, "[TITLE]", string6);
        if (StringShop.isset(string5)) {
            string3 = StringShop.replaceAll(string3, "[LINK]", string5);
            string2 = StringShop.replaceAll(string2, "[LINK]", string5);
        } else {
            string3 = string3.replaceAll("\\[LINK\\]", GUI.i18n.getTranslation("LABEL_EMPTY_LINK"));
            string2 = string2.replaceAll("\\[LINK\\]", GUI.i18n.getTranslation("LABEL_EMPTY_LINK"));
        }
        if (StringShop.isset(string7)) {
            string3 = StringShop.replaceAll(string3, "[DESCRIPTION]", string7);
            string2 = StringShop.replaceAll(string2, "[DESCRIPTION]", string7);
        } else {
            string3 = string3.replaceAll("\\[DESCRIPTION\\]", "");
            string2 = string2.replaceAll("\\[DESCRIPTION\\]", "");
        }
        string2 = StringShop.isset(this.getAuthor()) ? StringShop.replaceAll(string2, "[AUTHOR]", this.getAuthor()) : string2.replaceAll("\\[AUTHOR\\]", "");
        string3 = StringShop.isset(this.getAuthor()) ? StringShop.replaceAll(string3, "[AUTHOR]", this.getAuthor()) : string3.replaceAll("\\[AUTHOR\\]", "");
        string2 = StringShop.isset(this.getCategory()) ? StringShop.replaceAll(string2, "[CATEGORY]", this.getCategory()) : string2.replaceAll("\\[CATEGORY\\]", "");
        string3 = StringShop.isset(this.getCategory()) ? StringShop.replaceAll(string3, "[CATEGORY]", this.getCategory()) : string3.replaceAll("\\[CATEGORY\\]", "");
        string2 = StringShop.isset(this.getPubDate()) ? StringShop.replaceAll(string2, "[PUBDATE]", this.getPubDate()) : string2.replaceAll("\\[PUBDATE\\]", "");
        string3 = StringShop.isset(this.getPubDate()) ? StringShop.replaceAll(string3, "[PUBDATE]", this.getPubDate()) : string3.replaceAll("\\[PUBDATE\\]", "");
        string2 = StringShop.isset(this.getPublisher()) ? StringShop.replaceAll(string2, "[PUBLISHER]", this.getPublisher()) : string2.replaceAll("\\[PUBLISHER\\]", "");
        string3 = StringShop.isset(this.getPublisher()) ? StringShop.replaceAll(string3, "[PUBLISHER]", this.getPublisher()) : string3.replaceAll("\\[PUBLISHER\\]", "");
        string2 = StringShop.isset(this.getSource()) ? StringShop.replaceAll(string2, "[SOURCE]", this.getSource()) : string2.replaceAll("\\[SOURCE\\]", "");
        string3 = StringShop.isset(this.getSource()) ? StringShop.replaceAll(string3, "[SOURCE]", this.getSource()) : string3.replaceAll("\\[SOURCE\\]", "");
        string3 = string3 + string4;
        string = string + "?body=" + URLShop.mailToUrllEncode(string3) + "&subject=" + URLShop.mailToUrllEncode(string2);
        return string;
    }

    public String toPrintable() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.getTitle() != null) {
            stringBuffer.append(this.getTitle() + "\n");
        }
        if (this.getLink() != null) {
            stringBuffer.append(this.getLink() + "\n");
        }
        stringBuffer.append("\n");
        if (this.getDescription() != null) {
            stringBuffer.append(Text.normalizeString(this.getDescription()));
        }
        if (this.enclosures != null && this.enclosures.size() > 0) {
            string = "\n\n" + GUI.i18n.getTranslation("NEWS_ITEM_INFO_ENCLOSURE") + ":\n";
            stringBuffer.append(string);
            for (int i = 0; i < this.enclosures.size(); ++i) {
                Enclosure enclosure = (Enclosure)this.enclosures.get(i);
                stringBuffer.append("\n" + enclosure.getUrl() + " (" + enclosure.getType() + " / " + enclosure.getLength(true) + ")");
            }
        }
        if (this.getSource() != null) {
            string = "\n\n" + GUI.i18n.getTranslation("NEWS_ITEM_INFO_SOURCE") + ":  " + this.getSource();
            stringBuffer.append(string);
        }
        if (this.comments != null && this.comments.size() > 0) {
            stringBuffer.append("\n\n" + GUI.i18n.getTranslation("NEWS_ITEM_INFO_COMMENTS") + ":\n");
            for (int i = 0; i < this.comments.size(); ++i) {
                if (this.comments.get(i) == null || this.comments.get(i).equals("")) continue;
                stringBuffer.append("\n" + this.comments.get(i));
            }
        }
        return new String(stringBuffer);
    }

    public String toString(SearchDefinition searchDefinition) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = searchDefinition.getScope();
        if (n2 == 1 || n2 == 0) {
            if (StringShop.isset(this.getTitle())) {
                stringBuffer.append(this.getTitle());
            }
            if (n2 == 0 && StringShop.isset(this.getTitle())) {
                stringBuffer.append("\n");
            }
        }
        if (n2 == 2 || n2 == 0) {
            if (StringShop.isset(this.getDescription())) {
                stringBuffer.append(this.getDescription());
            }
            if (this.comments != null) {
                for (n = 0; n < this.comments.size(); ++n) {
                    stringBuffer.append("\n").append(this.comments.get(n));
                }
            }
            if (StringShop.isset(this.getSource())) {
                stringBuffer.append("\n").append(this.getSource());
            }
            if (n2 == 0 && StringShop.isset(this.getDescription())) {
                stringBuffer.append("\n");
            }
        }
        if (n2 == 3) {
            if (this.getPubDateParsed() != null) {
                stringBuffer.append(DateParser.formatDate(this.getPubDateParsed(), true));
            } else if (StringShop.isset(this.getPubDate())) {
                stringBuffer.append(this.getPubDate());
            }
        }
        if (n2 == 4 && StringShop.isset(this.getCategory())) {
            stringBuffer.append(this.getCategory());
        }
        if (n2 == 5 && StringShop.isset(this.getAuthor())) {
            stringBuffer.append(this.getAuthor());
        }
        if ((n2 == 6 || n2 == 0) && this.enclosures != null) {
            for (n = 0; n < this.enclosures.size(); ++n) {
                Enclosure enclosure = (Enclosure)this.enclosures.get(n);
                stringBuffer.append("\n").append(enclosure.getUrl());
                if (!StringShop.isset(enclosure.getType())) continue;
                stringBuffer.append(" ").append(enclosure.getType());
            }
            if (n2 == 0 && this.enclosures.size() > 0) {
                stringBuffer.append("\n");
            }
        }
        if (n2 == 7 && StringShop.isset(this.getNewsfeedTitle())) {
            stringBuffer.append(this.getNewsfeedTitle());
        }
        return StringShop.stripTags(stringBuffer.toString());
    }

    private void parseForLinks(String string) {
        if (StringShop.isset(string) && this.linkList != null) {
            RegExShop.extractLinksFromText(string, this.linkList);
        }
    }
}

