/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.model;

import net.sourceforge.rssowl.controller.NewsTable;
import net.sourceforge.rssowl.controller.panel.BrowserPanel;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.Channel;
import org.eclipse.swt.widgets.Table;

public class TabItemData {
    private static final int TYPE_BROWSER = 0;
    private static final int TYPE_ERROR = 3;
    private static final int TYPE_FEED = 2;
    private static final int TYPE_MESSAGE = 1;
    private Category aggregatedCategory;
    private Channel channel;
    private Table newsHeaderTableWidget;
    private NewsTable newsTable;
    private BrowserPanel rssOwlBrowserPanel;
    private boolean showsUnreadNews;
    private String title;
    private int type;
    private String url;

    private TabItemData(String string, String string2, Category category, NewsTable newsTable, Table table, Channel channel, BrowserPanel browserPanel, int n) {
        this.url = string;
        this.title = string2;
        this.aggregatedCategory = category;
        this.channel = channel;
        this.newsTable = newsTable;
        this.newsHeaderTableWidget = table;
        this.type = n;
        this.rssOwlBrowserPanel = browserPanel;
        this.showsUnreadNews = channel != null ? channel.containsUnreadNews() : false;
    }

    public static TabItemData createBrowserData(BrowserPanel browserPanel) {
        return new TabItemData(null, null, null, null, null, null, browserPanel, 0);
    }

    public static TabItemData createErrorData(String string) {
        return new TabItemData(string, null, null, null, null, null, null, 3);
    }

    public static TabItemData createFeedData(String string, String string2, Channel channel, NewsTable newsTable, Table table) {
        return new TabItemData(string, string2, channel.getAggregatedCategory(), newsTable, table, channel, null, 2);
    }

    public static TabItemData createMessageData(String string) {
        return new TabItemData(string, null, null, null, null, null, null, 1);
    }

    public void dispose() {
        this.channel = null;
        this.newsTable = null;
        this.newsHeaderTableWidget = null;
        if (this.rssOwlBrowserPanel != null) {
            this.rssOwlBrowserPanel.dispose();
        }
        this.rssOwlBrowserPanel = null;
    }

    public Category getAggregatedCategory() {
        return this.aggregatedCategory;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Table getNewsHeaderTable() {
        return this.newsHeaderTableWidget;
    }

    public NewsTable getNewsTable() {
        return this.newsTable;
    }

    public BrowserPanel getRSSOwlBrowserPanel() {
        return this.rssOwlBrowserPanel;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isAggregatedCat() {
        return this.aggregatedCategory != null;
    }

    public boolean isBrowser() {
        return this.type == 0;
    }

    public boolean isError() {
        return this.type == 3;
    }

    public boolean isFeed() {
        return this.type == 2;
    }

    public boolean isMessage() {
        return this.type == 1;
    }

    public boolean isShowsUnreadNews() {
        return this.showsUnreadNews;
    }

    public void setShowsUnreadNews(boolean bl) {
        this.showsUnreadNews = bl;
    }

    public boolean showsCategory(Category category) {
        if (this.aggregatedCategory == null || category == null) {
            return false;
        }
        return this.aggregatedCategory.toCatPath().equals(category.toCatPath());
    }
}

