/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.blowfishj.BlowfishEasy;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.StringShop;

public class CryptoManager {
    public static final String PROXY_DOMAIN_KEY = "PROXY_DOMAIN_KEY";
    public static final String PROXY_PASSWORD_KEY = "PROXY_PASSWORD_KEY";
    public static final String PROXY_USER_KEY = "PROXY_USER_KEY";
    private static CryptoManager instance;
    private BlowfishEasy blowFish = new BlowfishEasy(new char[]{'r', 's', 's', 'o', 'w', 'l', '2', '0', '0', '4', '~'});
    private Hashtable crypta;

    private CryptoManager() {
        this.loadData();
    }

    public static CryptoManager getInstance() {
        if (instance == null) {
            instance = new CryptoManager();
        }
        return instance;
    }

    public void addItem(String string, String string2) {
        if (StringShop.isset(string2)) {
            this.crypta.put(string, string2);
        }
    }

    public String getItem(String string) {
        return (String)this.crypta.get(string);
    }

    public boolean hasItem(String string) {
        return string != null && this.crypta.containsKey(string);
    }

    public String loadProxyDomain() {
        if (this.crypta.containsKey(PROXY_DOMAIN_KEY)) {
            return (String)this.crypta.get(PROXY_DOMAIN_KEY);
        }
        return "";
    }

    public String loadProxyPassword() {
        if (this.crypta.containsKey(PROXY_PASSWORD_KEY)) {
            return (String)this.crypta.get(PROXY_PASSWORD_KEY);
        }
        return "";
    }

    public String loadProxyUser() {
        if (this.crypta.containsKey(PROXY_USER_KEY)) {
            return (String)this.crypta.get(PROXY_USER_KEY);
        }
        return "";
    }

    public void removeItem(String string) {
        if (this.hasItem(string)) {
            this.crypta.remove(string);
        }
    }

    public void saveData() {
        try {
            this.encryptData();
            FileOutputStream fileOutputStream = new FileOutputStream(GlobalSettings.CRYPT_FILE);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.crypta);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            GUI.logger.log("saveData", iOException);
        }
    }

    private void decryptData() {
        Enumeration enumeration = this.crypta.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.crypta.put(string, this.blowFish.decryptString((String)this.crypta.get(string)));
        }
    }

    private void encryptData() {
        Enumeration enumeration = this.crypta.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.crypta.put(string, this.blowFish.encryptString((String)this.crypta.get(string)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() {
        try {
            FileInputStream fileInputStream = new FileInputStream(GlobalSettings.CRYPT_FILE);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.crypta = (Hashtable)objectInputStream.readObject();
            this.decryptData();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            GUI.logger.log(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            GUI.logger.log(classNotFoundException.getMessage());
        }
        finally {
            if (this.crypta == null) {
                this.crypta = new Hashtable();
            }
        }
    }
}

