/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sourceforge.rssowl.util.shop.StringShop;

public final class DateParser {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    private static final DateFormat DATE_LONG_FORMAT = DateFormat.getDateInstance(0);
    private static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    private static final DateFormat DATE_TIME_LONG_FORMAT = DateFormat.getDateTimeInstance(0, 3);
    private static SimpleDateFormat[] dateFormats = null;

    private DateParser() {
    }

    public static String dateToFileName(String string) {
        String string2 = "_";
        string = string.replaceAll(" ", string2);
        string = string.replaceAll("\\.", string2);
        string = string.replaceAll(":", string2);
        string = string.replaceAll("-", string2);
        string = string.replaceAll("/", string2);
        return string;
    }

    public static String formatDate() {
        return DateParser.formatDate(new Date(), false, false);
    }

    public static String formatDate(boolean bl) {
        return DateParser.formatDate(new Date(), false, bl);
    }

    public static String formatDate(Date date, boolean bl) {
        return DateParser.formatDate(date, false, bl);
    }

    public static String formatDate(Date date, boolean bl, boolean bl2) {
        if (bl && bl2) {
            return DATE_TIME_LONG_FORMAT.format(date);
        }
        if (bl2) {
            return DATE_TIME_FORMAT.format(date);
        }
        if (bl) {
            return DATE_LONG_FORMAT.format(date);
        }
        return DATE_FORMAT.format(date);
    }

    public static String formatLongDate(Date date) {
        return DATE_LONG_FORMAT.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDate(String string) {
        Object object;
        if (!StringShop.isset(string)) {
            return null;
        }
        Date date = null;
        if ((string = string.trim()).length() > 10) {
            String string2;
            if ((string.substring(string.length() - 5).indexOf("+") == 0 || string.substring(string.length() - 5).indexOf("-") == 0) && string.substring(string.length() - 5).indexOf(":") == 2) {
                string2 = string.substring(string.length() - 5, string.length() - 4);
                string = string.substring(0, string.length() - 5) + string2 + "0" + string.substring(string.length() - 4);
            }
            if (!((string2 = string.substring(string.length() - 6)).indexOf("-") != 0 && string2.indexOf("+") != 0 || string2.indexOf(":") != 3 || "GMT".equals(string.substring(string.length() - 9, string.length() - 6)))) {
                object = string;
                String string3 = string2.substring(0, 3) + string2.substring(4);
                string = ((String)object).substring(0, ((String)object).length() - 6) + string3;
            }
        }
        int n = 0;
        while (n < dateFormats.length) {
            try {
                object = dateFormats[n];
                synchronized (object) {
                    return dateFormats[n].parse(string);
                }
            }
            catch (ParseException parseException) {
                ++n;
            }
            catch (NumberFormatException numberFormatException) {
                ++n;
            }
        }
        return date;
    }

    static {
        String[] stringArray = new String[]{"EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm z", "EEE, dd MMM yy HH:mm:ss", "EEE, MMM dd yy HH:mm:ss", "EEE dd MMM yyyy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:sszzzz", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm'Z'", "dd-mm-yyyy HH:mm:ss", "dd MMM yyyy HH:mm:ss z", "dd MMM yyyy HH:mm:ss", "dd MMM yyyy HH:mm z", "yyyy-MM-dd", "MMM dd, yyyy"};
        dateFormats = new SimpleDateFormat[stringArray.length];
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        for (int i = 0; i < stringArray.length; ++i) {
            DateParser.dateFormats[i] = new SimpleDateFormat(stringArray[i], Locale.ENGLISH);
            dateFormats[i].setTimeZone(timeZone);
        }
    }
}

