/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;

public class LoggerImpl {
    private static final Logger logger = Logger.getLogger("net.sourceforge.rssowl.controller");
    private static final int MAX_LOG_SIZE = 100000;
    private static boolean useFileHandler = true;
    private String criticalErrorLogPath;

    public LoggerImpl() {
        if (useFileHandler) {
            this.initFileHandler();
            logger.setUseParentHandlers(false);
        } else {
            logger.setUseParentHandlers(true);
        }
        logger.setLevel(Level.WARNING);
    }

    public void info(String string, Throwable throwable) {
        this.log(Level.INFO, "Method: " + string + " Exception: " + throwable.getCause(), throwable);
    }

    public void log(String string) {
        this.log(Level.WARNING, string, null);
    }

    public void log(String string, Throwable throwable) {
        this.log(Level.WARNING, string, throwable);
    }

    public void logCritical(String string, Throwable throwable) {
        Logger logger = Logger.getLogger("net.sourceforge.rssowl");
        logger.setUseParentHandlers(false);
        if (this.criticalErrorLogPath == null) {
            this.criticalErrorLogPath = "log_critical_" + DateParser.dateToFileName(DateParser.formatDate(true)) + ".log";
        }
        try {
            FileHandler fileHandler = new FileHandler(this.criticalErrorLogPath);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            this.log("logCritical", iOException);
        }
        logger.log(Level.WARNING, "Method: " + string + " Exception: " + throwable.getCause(), throwable);
    }

    private void initFileHandler() {
        try {
            FileHandler fileHandler = new FileHandler(GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log", 100000, 1, true);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
            this.criticalErrorLogPath = GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "log_critical_" + DateParser.dateToFileName(DateParser.formatDate(true)) + ".log";
        }
        catch (IOException iOException) {
            this.log("initFileHandler", iOException);
        }
    }

    private void log(Level level, String string, Throwable throwable) {
        if (string == null) {
            logger.log(level, "No Message", throwable);
        } else if (throwable == null) {
            logger.log(level, string);
        } else {
            logger.log(level, "Method: " + string + " Exception: " + throwable.getCause(), throwable);
        }
    }
}

