/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.archive;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.rssowl.util.archive.ArchiveEntry;

public class ArchiveItem {
    private boolean dirty;
    private Hashtable entries;
    private String feedurl;
    private File file;

    public ArchiveItem(String string) {
        this.feedurl = string;
        this.entries = new Hashtable();
        this.dirty = true;
    }

    public void addEntry(ArchiveEntry archiveEntry) {
        this.entries.put(archiveEntry.toID(), archiveEntry);
        this.dirty = true;
    }

    public Hashtable getEntries() {
        return this.entries;
    }

    public String getFeedurl() {
        return this.feedurl;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isNewsRead(String string, String string2, String string3) {
        return this.entries.containsKey(ArchiveEntry.toID(string, string2, string3));
    }

    public void removeEntry(ArchiveEntry archiveEntry) {
        this.removeEntry(archiveEntry.getNewsTitle(), archiveEntry.getNewsLink(), archiveEntry.getNewsdate());
    }

    public void removeEntry(String string, String string2, String string3) {
        String string4 = ArchiveEntry.toID(string, string2, string3);
        this.entries.remove(string4);
        this.dirty = true;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.file != null ? this.file.getName() : "NULL";
        stringBuffer.append("FeedURL: " + this.feedurl + "   FileName: " + string + "\n");
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
        }
        return new String(stringBuffer);
    }
}

