/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.archive;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.dao.NewsfeedFactoryException;
import net.sourceforge.rssowl.dao.feedparser.FeedParser;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FeedCacheManager {
    private static final String CACHE_INDEX = "index.obj";
    private static final long FILE_TIME_TO_LIVE = 172800000L;
    private Hashtable newsFeedLiveCache = new Hashtable();
    private Hashtable newsFeedLocalCache;

    public FeedCacheManager() {
        this.deserializeCache();
        this.cleanUpCache();
    }

    public void cacheNewsfeed(String string, Channel channel) {
        if (channel == null) {
            return;
        }
        Document document = channel.getDocument();
        channel.setDocument(null);
        if (this.isNewsfeedCached(string)) {
            this.unCacheNewsfeed(string, true);
        }
        this.newsFeedLiveCache.put(string, channel);
        if (!GlobalSettings.localCacheFeeds) {
            return;
        }
        try {
            if (document != null) {
                File file = this.saveDocument(document);
                this.newsFeedLocalCache.put(string, file);
            }
        }
        catch (IOException iOException) {
            GUI.logger.log("cacheNewsfeed", iOException);
        }
    }

    public Channel getCachedNewsfeed(String string) {
        if (!this.isNewsfeedCached(string)) {
            return null;
        }
        if (this.newsFeedLiveCache.containsKey(string)) {
            return (Channel)this.newsFeedLiveCache.get(string);
        }
        SAXBuilder sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        XMLShop.setDefaultEntityResolver(sAXBuilder);
        try {
            File file = (File)this.newsFeedLocalCache.get(string);
            Document document = sAXBuilder.build(file);
            FeedParser feedParser = new FeedParser(document, string);
            feedParser.parse();
            return feedParser.getChannel();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (JDOMException jDOMException) {
            return null;
        }
        catch (NewsfeedFactoryException newsfeedFactoryException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean isNewsfeedCached(String string) {
        return this.isNewsfeedCached(string, true);
    }

    public boolean isNewsfeedCached(String string, boolean bl) {
        if (string == null) {
            return false;
        }
        return this.newsFeedLiveCache.containsKey(string) || bl && this.newsFeedLocalCache.containsKey(string);
    }

    public void shutdown() {
        if (GlobalSettings.localCacheFeeds) {
            this.serializeCache();
        } else {
            this.deleteCache();
        }
    }

    public void unCacheNewsfeed(String string, boolean bl) {
        this.newsFeedLiveCache.remove(string);
        if (bl && this.newsFeedLocalCache.containsKey(string)) {
            File file = (File)this.newsFeedLocalCache.get(string);
            file.delete();
            this.newsFeedLocalCache.remove(string);
        }
    }

    private void cleanUpCache() {
        Enumeration enumeration = this.newsFeedLocalCache.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            File file = (File)this.newsFeedLocalCache.get(string);
            arrayList.add(file.getName());
            if (!file.exists()) {
                arrayList2.add(string);
            }
            if (System.currentTimeMillis() - file.lastModified() <= 172800000L) continue;
            this.unCacheNewsfeed(string, false);
            arrayList2.add(string);
            file.delete();
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.newsFeedLocalCache.remove(arrayList2.get(i));
        }
        File[] fileArray = new File(GlobalSettings.CACHE_DIR).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            boolean bl;
            String string = fileArray[i].getName();
            boolean bl2 = bl = string.indexOf("xml") >= 0;
            if (arrayList.contains(fileArray[i].getName()) || !bl) continue;
            fileArray[i].delete();
        }
    }

    private void deleteCache() {
        File[] fileArray = new File(GlobalSettings.CACHE_DIR).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            boolean bl;
            String string = fileArray[i].getName();
            boolean bl2 = bl = string.indexOf("xml") >= 0 || string.indexOf("obj") >= 0;
            if (!bl) continue;
            fileArray[i].delete();
        }
    }

    private void deserializeCache() {
        if (!GlobalSettings.localCacheFeeds) {
            this.newsFeedLocalCache = new Hashtable();
            return;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(GlobalSettings.CACHE_DIR + GlobalSettings.PATH_SEPARATOR + CACHE_INDEX));
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            this.newsFeedLocalCache = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            this.newsFeedLocalCache = new Hashtable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.newsFeedLocalCache = new Hashtable();
        }
    }

    private File saveDocument(Document document) throws IOException {
        File file = File.createTempFile("cache", ".xml", new File(GlobalSettings.CACHE_DIR));
        XMLShop.writeXML(document, file);
        return file;
    }

    private void serializeCache() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(GlobalSettings.CACHE_DIR + GlobalSettings.PATH_SEPARATOR + CACHE_INDEX));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(this.newsFeedLocalCache);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            GUI.logger.log("serializeCache", iOException);
        }
    }
}

