/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.search;

import java.util.ArrayList;
import java.util.Hashtable;
import net.sourceforge.rssowl.controller.GUI;

public class SearchPatternParser {
    public static final String AND = "SEARCH_AND";
    public static final String MUST_CONTAIN_KEY = "MUST_CONTAIN_KEY";
    public static final String MUSTNOT_CONTAIN_KEY = "MUSTNOT_CONTAIN_KEY";
    public static final String NOT = "SEARCH_NOT";
    public static final String OR = "SEARCH_OR";

    private SearchPatternParser() {
    }

    public static String getTranslation(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" ").append(GUI.i18n.getTranslation(string)).append(" ");
        return stringBuffer.toString();
    }

    private static int getClosestKeyword(String string, int n) {
        int n2 = -1;
        int n3 = string.indexOf(SearchPatternParser.getTranslation(AND), n);
        int n4 = string.indexOf(SearchPatternParser.getTranslation(OR), n);
        if (n4 < n3 && n4 > 0 || n3 < 0) {
            n2 = n4;
        } else if (n3 < n4 && n3 > 0 || n4 < 0) {
            n2 = n3;
        }
        if (n2 < 1) {
            n2 = string.length();
        }
        return n2;
    }

    private static ArrayList parseMustAndMayWords(String string) {
        String[] stringArray = string.split(SearchPatternParser.getTranslation(AND));
        ArrayList arrayList = new ArrayList();
        String string2 = SearchPatternParser.getTranslation(OR);
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String[] stringArray2 = stringArray[i].split(string2);
            for (int j = 0; j < stringArray2.length; ++j) {
                arrayList2.add(stringArray2[j]);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    static ArrayList generateRegEx(ArrayList arrayList, boolean bl) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = "";
        String string2 = "";
        if (bl) {
            string = "(\\s|^)";
            string2 = "(\\s|$)";
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            StringBuffer stringBuffer;
            ArrayList arrayList3 = (ArrayList)arrayList.get(i);
            if (arrayList3.size() == 1) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append((String)arrayList3.get(0));
                stringBuffer.append(string2);
                arrayList2.add(stringBuffer.toString());
                continue;
            }
            if (arrayList3.size() <= 1) continue;
            stringBuffer = new StringBuffer(string + "(");
            stringBuffer.append((String)arrayList3.get(0));
            for (int j = 1; j < arrayList3.size(); ++j) {
                stringBuffer.append("|");
                stringBuffer.append((String)arrayList3.get(j));
            }
            stringBuffer.append(")" + string2);
            arrayList2.add(stringBuffer.toString());
        }
        return arrayList2;
    }

    static Hashtable parsePattern(String string) {
        Hashtable hashtable = new Hashtable();
        String string2 = SearchPatternParser.getTranslation(NOT);
        int n = string.indexOf(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n > 0) {
            int n2 = n;
            int n3 = SearchPatternParser.getClosestKeyword(string, n);
            String string3 = string.substring(n2, n3);
            String[] stringArray = string3.split(string2);
            string = string.replaceFirst(string3, "");
            for (int i = 1; i < stringArray.length; ++i) {
                if (arrayList.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
            n = string.indexOf(string2, n + 1);
        }
        ArrayList arrayList2 = SearchPatternParser.parseMustAndMayWords(string);
        hashtable.put(MUST_CONTAIN_KEY, arrayList2);
        hashtable.put(MUSTNOT_CONTAIN_KEY, arrayList);
        return hashtable;
    }
}

