/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class FontShop {
    public static Font dialogBoldFont = null;
    public static Font dialogFont = FontShop.createFont();
    public static Font headerBoldFont = null;
    public static Font headerFont = FontShop.createFont(FontShop.getFontData()[0].getHeight() + 1);
    public static Font tableBoldFont = null;
    public static Font tableFont = FontShop.createFont();
    public static Font textBoldFont = null;
    public static Font textFont = FontShop.createFont(FontShop.getFontData()[0].getHeight() + 1);
    public static Font treeBoldFont = null;
    public static Font treeFont = FontShop.createFont();

    private FontShop() {
    }

    public static Font createFont() {
        FontData[] fontDataArray = FontShop.getFontData();
        return FontShop.createFont(fontDataArray[0].getName(), fontDataArray[0].getHeight(), 0);
    }

    public static Font createFont(int n) {
        FontData[] fontDataArray = FontShop.getFontData();
        return FontShop.createFont(fontDataArray[0].getName(), n, 0);
    }

    public static Font createFont(int n, int n2) {
        FontData[] fontDataArray = FontShop.getFontData();
        return FontShop.createFont(fontDataArray[0].getName(), n, n2);
    }

    public static Font createFont(String string, int n, int n2) {
        FontData[] fontDataArray = FontShop.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            fontDataArray[i].setName(string);
            fontDataArray[i].setHeight(n);
            fontDataArray[i].setLocale(Dictionary.selectedLocale.toString());
            if (n2 == 0) continue;
            fontDataArray[i].setStyle(n2);
        }
        return new Font((Device)GUI.display, fontDataArray);
    }

    public static void disposeFonts() {
        if (FontShop.isset(dialogBoldFont)) {
            dialogBoldFont.dispose();
        }
        if (FontShop.isset(dialogFont)) {
            dialogFont.dispose();
        }
        if (FontShop.isset(headerFont)) {
            headerFont.dispose();
        }
        if (FontShop.isset(tableFont)) {
            tableFont.dispose();
        }
        if (FontShop.isset(tableBoldFont)) {
            tableBoldFont.dispose();
        }
        if (FontShop.isset(textBoldFont)) {
            textBoldFont.dispose();
        }
        if (FontShop.isset(textFont)) {
            textFont.dispose();
        }
        if (FontShop.isset(treeFont)) {
            treeFont.dispose();
        }
        if (FontShop.isset(treeBoldFont)) {
            treeBoldFont.dispose();
        }
        if (FontShop.isset(headerBoldFont)) {
            headerBoldFont.dispose();
        }
    }

    public static FontData[] getFontData() {
        return GUI.display.getSystemFont().getFontData();
    }

    public static FontData[] getFontData(int n) {
        FontData[] fontDataArray = FontShop.getFontData();
        return FontShop.getFontData(fontDataArray[0].getName(), n, 0);
    }

    public static FontData[] getFontData(String string, int n, int n2) {
        FontData[] fontDataArray = FontShop.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            fontDataArray[i].setName(string);
            fontDataArray[i].setHeight(n);
            fontDataArray[i].setLocale(Dictionary.selectedLocale.toString());
            if (n2 == 0) continue;
            fontDataArray[i].setStyle(n2);
        }
        return fontDataArray;
    }

    public static boolean isset(Font font) {
        return font != null && !font.isDisposed();
    }

    public static void setFontForAll(GUI gUI) {
        gUI.getRSSOwlQuickview().updateFonts();
        gUI.getRSSOwlFavoritesTree().updateFonts();
        gUI.getRSSOwlNewsTabFolder().updateFonts();
        gUI.getRSSOwlNewsText().updateFonts();
        gUI.getRSSOwlStatusLine().updateFonts();
        LayoutShop.setLayoutForAll(GUI.shell);
    }

    public static void updateFonts() {
        FontShop.initStyledFonts();
        JFaceResources.getFontRegistry().put("org.eclipse.jface.dialogfont", dialogFont.getFontData());
    }

    private static Font createBoldFont(Font font) {
        FontData[] fontDataArray = font.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            fontDataArray[i].setStyle(1);
            fontDataArray[i].setLocale(Dictionary.selectedLocale.toString());
        }
        return new Font((Device)GUI.display, fontDataArray);
    }

    private static void initStyledFonts() {
        dialogBoldFont = FontShop.createBoldFont(dialogFont);
        tableBoldFont = FontShop.createBoldFont(tableFont);
        textBoldFont = FontShop.createBoldFont(textFont);
        treeBoldFont = FontShop.createBoldFont(treeFont);
        headerBoldFont = FontShop.createBoldFont(headerFont);
    }
}

