/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LayoutShop {
    private LayoutShop() {
    }

    public static void centerShell(Display display, Shell shell) {
        Rectangle rectangle = display.getPrimaryMonitor().getBounds();
        Rectangle rectangle2 = shell.getBounds();
        int n = rectangle.x + (rectangle.width - rectangle2.width) >> 1;
        int n2 = rectangle.y + (rectangle.height - rectangle2.height) >> 1;
        shell.setLocation(n, n2);
    }

    public static FillLayout createFillLayout(int n, int n2) {
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = n2;
        fillLayout.marginWidth = n;
        return fillLayout;
    }

    public static GridLayout createGridLayout(int n) {
        return LayoutShop.createGridLayout(n, 5, 5, 5, 5, false);
    }

    public static GridLayout createGridLayout(int n, int n2) {
        return LayoutShop.createGridLayout(n, n2, 5, 5, 5, false);
    }

    public static GridLayout createGridLayout(int n, int n2, int n3) {
        return LayoutShop.createGridLayout(n, n2, n3, 5, 5, false);
    }

    public static GridLayout createGridLayout(int n, int n2, int n3, boolean bl) {
        return LayoutShop.createGridLayout(n, n2, n3, 5, 5, bl);
    }

    public static GridLayout createGridLayout(int n, int n2, int n3, int n4) {
        return LayoutShop.createGridLayout(n, n2, n3, n4, 5, false);
    }

    public static GridLayout createGridLayout(int n, int n2, int n3, int n4, int n5, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginHeight = n3;
        gridLayout.marginWidth = n2;
        gridLayout.verticalSpacing = n4;
        gridLayout.horizontalSpacing = n5;
        return gridLayout;
    }

    public static void positionShell(Shell shell, boolean bl, int n) {
        Rectangle rectangle = GUI.shell.getBounds();
        Point point = bl ? shell.computeSize(-1, -1, true) : shell.getSize();
        int n2 = Math.max(0, rectangle.x + (rectangle.width - point.x) >> 1);
        int n3 = Math.max(0, rectangle.y + (rectangle.height - point.y) / 3);
        shell.setLocation(n2 + n * 20, n3 + n * 20);
    }

    public static void setDialogSpacer(Composite composite, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            Label label = new Label(composite, 0);
            label.setLayoutData(LayoutDataShop.createGridData(32, n));
            label.setFont(FontShop.dialogFont);
        }
    }

    public static void setLayoutForAll(Control control) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                LayoutShop.setLayoutForAll(controlArray[i]);
            }
            ((Composite)control).layout();
        }
    }
}

