/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.NewsText;
import net.sourceforge.rssowl.controller.panel.BrowserPanel;
import net.sourceforge.rssowl.util.shop.FontShop;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;

public class PrintShop {
    private PrintShop() {
    }

    public static void printNews(String string, String string2) {
        StyledText styledText = PrintShop.getPrintPane(string, string2);
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.header = "\t\t" + GUI.i18n.getTranslation("PRINTED_FROM_RSSOWL");
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.jobName = GUI.i18n.getTranslation("PRINTJOB_NAME");
        PrintDialog printDialog = new PrintDialog(GUI.shell);
        PrinterData printerData = printDialog.open();
        Printer printer = new Printer(printerData);
        if (printerData != null) {
            styledText.print(printer, styledTextPrintOptions).run();
        }
        printer.dispose();
    }

    public static boolean printNewsFromBrowser() {
        NewsText newsText = GUI.rssOwlGui.getRSSOwlNewsText();
        BrowserPanel browserPanel = newsText.getBrowserPanel();
        if (!browserPanel.print()) {
            return PrintShop.printNewsFromText();
        }
        return true;
    }

    public static boolean printNewsFromText() {
        NewsText newsText = GUI.rssOwlGui.getRSSOwlNewsText();
        String string = "";
        if (newsText.getNewsTextTitle().getText() != null) {
            string = newsText.getNewsTextTitle().getText();
        }
        String string2 = newsText.getPrintableNewstext();
        if (string.equals("") && string2.equals("")) {
            return false;
        }
        PrintShop.printNews(string, string2);
        return true;
    }

    private static StyledText getPrintPane(String string, String string2) {
        StyledText styledText = new StyledText(new Shell(), 0);
        styledText.setFont(FontShop.textFont);
        styledText.setText(string2);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = string.length();
        styleRange.fontStyle = 1;
        styledText.setStyleRange(styleRange);
        return styledText;
    }
}

