/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.rssowl.util.shop.StringShop;

public class RegExShop {
    public static final String REGEX_OK = "OK";
    private static final String HTML_ANCHOR_REGEX = "<[a|link]([^>]+)href=('|\")?([^>\"'\\s]+)";
    private static final Pattern HTML_ANCHOR_REGEX_PATTERN = Pattern.compile("<[a|link]([^>]+)href=('|\")?([^>\"'\\s]+)", 2);
    private static final String[] regExSymbols = new String[]{"\\", "+", "-", "?", "*", ".", "[", "]", "(", ")", "{", "}", "^", "$", "|"};
    private static final String URL_REGEX = "(www([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?)|(http|ftp|https):\\/\\/[\\w]+(.[\\w]+)([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?";
    private static final Pattern URL_REGEX_PATTERN = Pattern.compile("(www([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?)|(http|ftp|https):\\/\\/[\\w]+(.[\\w]+)([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?");
    private static final String WHITESPACE_REGEX = "[\\s]+";
    static final String HTML_TAG_REGEX = "<[^>]+>";
    static final Pattern HTML_TAG_REGEX_PATTERN = Pattern.compile("<[^>]+>");
    static final Pattern WHITESPACE_PATTERN = Pattern.compile("[\\s]+");

    private RegExShop() {
    }

    public static String compileRegEx(String string) {
        try {
            Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return patternSyntaxException.getMessage();
        }
        return REGEX_OK;
    }

    public static String escapeRegEx(String string) {
        for (int i = 0; i < regExSymbols.length; ++i) {
            string = StringShop.replaceAll(string, regExSymbols[i], "\\" + regExSymbols[i]);
        }
        return string;
    }

    public static void extractLinksFromHTML(String string, Vector vector) {
        Matcher matcher = HTML_ANCHOR_REGEX_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(3);
            if (!StringShop.isset(string2) || vector.contains(string2)) continue;
            vector.add(string2);
        }
    }

    public static void extractLinksFromText(String string, Vector vector) {
        Matcher matcher = URL_REGEX_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(0);
            if (!StringShop.isset(string2) || vector.contains(string2)) continue;
            vector.add(string2);
        }
    }

    public static boolean isInsideTags(String string, String string2) {
        if (string2.indexOf(60) >= 0 || string2.indexOf(62) >= 0) {
            return true;
        }
        Pattern pattern = Pattern.compile("<[^>]*" + RegExShop.escapeRegEx(string2) + "[^>]*>");
        return pattern.matcher(string).find();
    }

    public static boolean isValidURL(String string) {
        return URL_REGEX_PATTERN.matcher(string).matches();
    }
}

