/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MenuManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class WidgetShop {
    public static int openDialogsCount = 0;

    private WidgetShop() {
    }

    public static Vector calculateStyleRanges(StyledText styledText, Vector vector, Color color, Color color2, int n, boolean bl, boolean bl2) {
        Vector<StyleRange> vector2 = new Vector<StyleRange>();
        String string = styledText.getText();
        if (!bl) {
            string = styledText.getText().toLowerCase();
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n2;
            int n3 = 0;
            String string2 = (String)vector.get(i);
            if (!bl) {
                string2 = string2.toLowerCase();
            }
            while ((n2 = string.indexOf(string2, n3)) > -1) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = n2;
                styleRange.length = string2.length();
                styleRange.fontStyle = n;
                styleRange.foreground = color;
                styleRange.background = color2;
                styleRange.underline = bl2;
                vector2.add(styleRange);
                n3 = styleRange.start + styleRange.length;
            }
        }
        return vector2;
    }

    public static void createWildCardMenu(final Text text, String[] stringArray) {
        Menu menu = new Menu(text);
        for (int i = 0; i < stringArray.length; ++i) {
            final String string = stringArray[i];
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText(stringArray[i]);
            if (!GlobalSettings.isMac()) {
                menuItem.setImage(PaintShop.iconBackward);
            }
            menuItem.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    text.insert(string);
                }
            });
        }
        text.setMenu(menu);
    }

    public static String getShellTitle() {
        String string;
        String string2 = string = GlobalSettings.workOffline ? " - [" + GUI.i18n.getTranslation("MENU_WORK_OFFLINE") + "]" : "";
        if (GlobalSettings.isMac()) {
            return "RSSOwl" + string;
        }
        return "RSSOwl - RSS / RDF / Atom Newsreader" + string;
    }

    public static void highlightText(StyledText styledText, Vector vector) {
        TreeSet<StyleRange> treeSet = new TreeSet<StyleRange>(new Comparator(){

            public int compare(Object object, Object object2) {
                StyleRange styleRange = (StyleRange)object;
                StyleRange styleRange2 = (StyleRange)object2;
                if (styleRange.start < styleRange2.start) {
                    return -1;
                }
                if (styleRange.start > styleRange2.start) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < vector.size(); ++i) {
            StyleRange styleRange = (StyleRange)vector.get(i);
            if (WidgetShop.collides(treeSet, styleRange)) continue;
            treeSet.add(styleRange);
        }
        try {
            styledText.setStyleRanges(treeSet.toArray(new StyleRange[treeSet.size()]));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static boolean collides(TreeSet treeSet, StyleRange styleRange) {
        for (StyleRange styleRange2 : treeSet) {
            if (styleRange2.start >= styleRange.start + styleRange.length || styleRange2.start + styleRange2.length <= styleRange.start) continue;
            return true;
        }
        return false;
    }

    public static void highlightText(StyledText styledText, Vector vector, Color color, Color color2, int n, boolean bl, boolean bl2) {
        WidgetShop.highlightText(styledText, WidgetShop.calculateStyleRanges(styledText, vector, color, color2, n, bl, bl2));
    }

    public static void initMnemonics(Button[] buttonArray) {
        if (!GlobalSettings.shouldShowMnemonics()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (int i = 0; i < buttonArray.length; ++i) {
            String string = buttonArray[i].getText();
            string = string.replaceAll("&", "");
            for (int j = 0; j < string.length(); ++j) {
                if (string.substring(j, j + 1) == null || string.substring(j, j + 1).equals(" ") || arrayList.contains(string.substring(j, j + 1).toLowerCase())) continue;
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, j));
                stringBuffer.append("&").append(string.substring(j, string.length()));
                buttonArray[i].setText(stringBuffer.toString());
                arrayList.add(string.substring(j, j + 1).toLowerCase());
                continue block0;
            }
        }
    }

    public static void initMnemonics(ToolItem[] toolItemArray) {
        if (!GlobalSettings.shouldShowMnemonics()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (int i = 0; i < toolItemArray.length; ++i) {
            String string = toolItemArray[i].getText();
            string = string.replaceAll("&", "");
            for (int j = 0; j < string.length(); ++j) {
                if (string.substring(j, j + 1) == null || string.substring(j, j + 1).equals(" ") || arrayList.contains(string.substring(j, j + 1).toLowerCase())) continue;
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, j));
                stringBuffer.append("&").append(string.substring(j, string.length()));
                toolItemArray[i].setText(stringBuffer.toString());
                arrayList.add(string.substring(j, j + 1).toLowerCase());
                continue block0;
            }
        }
    }

    public static boolean isset(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public static boolean isWidget(Object object) {
        return object != null && object instanceof Widget && WidgetShop.isset((Widget)object);
    }

    public static void setupDropSupport(final Text text, final Runnable runnable) {
        final DropTarget dropTarget = new DropTarget(text, 2);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetAdapter(){

            @Override
            public void drop(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.data != null && StringShop.isset(dropTargetEvent.data.toString())) {
                    Vector vector = new Vector();
                    RegExShop.extractLinksFromText(dropTargetEvent.data.toString(), vector);
                    if (vector.size() > 0) {
                        text.setText(vector.get(0).toString());
                    } else {
                        String string = dropTargetEvent.data.toString();
                        if (string.indexOf("=;=") >= 0) {
                            String[] stringArray = string.split("=;=");
                            text.setText(stringArray[stringArray.length - 1]);
                        } else {
                            text.setText(org.jdom.Text.normalizeString(string));
                        }
                    }
                    text.setFocus();
                    if (runnable != null) {
                        try {
                            runnable.run();
                        }
                        catch (Exception exception) {
                            GUI.logger.log("setupDropSupport()", exception);
                        }
                    }
                } else {
                    dropTargetEvent.feedback = 0;
                }
            }
        });
        text.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent disposeEvent) {
                dropTarget.dispose();
            }
        });
    }

    public static void tweakTextWidget(final Text text) {
        if (!WidgetShop.isset(text)) {
            return;
        }
        text.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClick(MouseEvent mouseEvent) {
                text.selectAll();
            }
        });
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (!((keyEvent.stateMask & 0x40000) == 0 && (keyEvent.stateMask & 0x400000) == 0 || keyEvent.keyCode != 97 && keyEvent.keyCode != 65)) {
                    text.selectAll();
                }
            }
        });
        text.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MenuManager.handleEditMenuState();
            }
        });
    }
}

