/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.dao.ConnectionManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.apache.xerces.util.EncodingMap;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLShop {
    public static final String DOCTYPE_HTML_TRANSITIONAL = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">";
    public static final String NULL_DTD = "http://www.null.dtd";
    public static final String ALLOW_JAVA_ENCODING = "http://apache.org/xml/features/allow-java-encodings";
    private static String[] stripDoubleTags = new String[]{"b", "i", "u", "em", "strong", "li", "ul", "ol", "p", "img", "blockquote", "font", "span", "div", "center", "area", "map", "form"};
    private static String[] stripSingleTags = new String[]{"br", "p"};

    private XMLShop() {
    }

    public static String getTitleFromFeed(String string, boolean bl) throws IOException {
        String string2 = "";
        if (new File(string).exists()) {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            String string3 = XMLShop.getEncodingFromXML(new InputStreamReader(fileInputStream));
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ("utf-8".equals(string3)) {
                string3 = "UTF-8";
            }
            fileInputStream = new FileInputStream(new File(string));
            string2 = StringShop.isset(string3) && XMLShop.isEncodingSupported(string3) ? XMLShop.getTitleFromFeed(new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string3))) : XMLShop.getTitleFromFeed(new BufferedReader(new InputStreamReader(fileInputStream)));
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        } else {
            ConnectionManager connectionManager = new ConnectionManager(string);
            connectionManager.connect(bl);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(connectionManager.getInputStream());
            bufferedInputStream.mark(8192);
            String string4 = XMLShop.getEncodingFromXML(new InputStreamReader(bufferedInputStream));
            if ("utf-8".equalsIgnoreCase(string4)) {
                string4 = "UTF-8";
            }
            bufferedInputStream.reset();
            string2 = StringShop.isset(string4) && XMLShop.isEncodingSupported(string4) ? XMLShop.getTitleFromFeed(new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, string4))) : XMLShop.getTitleFromFeed(new BufferedReader(new InputStreamReader(bufferedInputStream)));
            connectionManager.closeConnection();
        }
        return string2;
    }

    public static InputStream getXMLStream(String string) {
        if (new File(string).exists()) {
            try {
                return new FileInputStream(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                GUI.logger.log("getXMLStream()", fileNotFoundException);
            }
        }
        ConnectionManager connectionManager = new ConnectionManager(string);
        try {
            connectionManager.connect();
            return connectionManager.getInputStream();
        }
        catch (IOException iOException) {
            connectionManager.closeConnection();
            return null;
        }
    }

    public static boolean isEncodingSupported(String string) {
        if (!StringShop.isset(string)) {
            return false;
        }
        if (EncodingMap.getIANA2JavaMapping(string.toUpperCase()) != null) {
            return true;
        }
        return EncodingMap.getJava2IANAMapping(string) != null;
    }

    public static boolean isValidUserXML(Document document) {
        return document != null && document.getRootElement() != null && document.getRootElement().getName().equals("rssowl");
    }

    public static boolean isValidUserXML(InputStream inputStream) {
        SAXBuilder sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        XMLShop.setDefaultEntityResolver(sAXBuilder);
        try {
            return XMLShop.isValidUserXML(sAXBuilder.build(inputStream));
        }
        catch (IOException iOException) {
            return false;
        }
        catch (JDOMException jDOMException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isValidUserXML(String string) {
        try {
            return XMLShop.isValidUserXML(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static void setDefaultEntityResolver(SAXBuilder sAXBuilder) {
        sAXBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String string, String string2) {
                return new InputSource(GUI.class.getResourceAsStream("/usr/entities.dtd"));
            }
        });
    }

    public static String stripSimpleHTMLTags(String string) {
        if (string != null && string.indexOf("<") >= 0) {
            int n;
            for (n = 0; n < stripSingleTags.length; ++n) {
                string = string.replaceAll("<" + stripSingleTags[n] + "[^>]*>", "");
                string = string.replaceAll("<" + stripSingleTags[n] + "[^>]*/>", "");
                string = string.replaceAll("<" + stripSingleTags[n].toUpperCase() + "[^>]*>", "");
                string = string.replaceAll("<" + stripSingleTags[n].toUpperCase() + "[^>]*/>", "");
            }
            for (n = 0; n < stripDoubleTags.length; ++n) {
                string = string.replaceAll("<" + stripDoubleTags[n] + "[^>]*>", "");
                string = string.replaceAll("</" + stripDoubleTags[n] + ">", "");
                string = string.replaceAll("<" + stripDoubleTags[n].toUpperCase() + "[^>]*>", "");
                string = string.replaceAll("</" + stripDoubleTags[n].toUpperCase() + ">", "");
            }
            string = string.replaceAll("<!\\-\\-[^\\-]*\\-\\->", "");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(Document document, File file) {
        XMLOutputter xMLOutputter = new XMLOutputter(XMLShop.getXMLFormat());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            xMLOutputter.output(document, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            GUI.logger.log("writeXML()", iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    GUI.logger.log("writeXML()", iOException);
                }
            }
        }
    }

    public static void writeXML(Document document, String string) {
        XMLShop.writeXML(document, string, false);
    }

    public static void writeXML(Document document, String string, boolean bl) {
        File file = new File(string);
        if (bl) {
            file.deleteOnExit();
        }
        XMLShop.writeXML(document, file);
    }

    private static String getEncodingFromXML(InputStreamReader inputStreamReader) throws IOException {
        String string;
        Pattern pattern;
        Matcher matcher;
        String string2;
        char c;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = (char)inputStreamReader.read()) != '\uffffffff') {
            if (c != '>' && c != '\n' && c != '\r') {
                stringBuffer.append(c);
                continue;
            }
            if (c != '>') break;
            stringBuffer.append(c);
            break;
        }
        if ((string2 = stringBuffer.toString()).indexOf("encoding") >= 0 && (matcher = (pattern = Pattern.compile(string = "<\\?.*encoding=[\"'](.*)[\"'].*\\?>")).matcher(string2)).find()) {
            return matcher.group(1);
        }
        return string3;
    }

    private static String getTitleFromFeed(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = "";
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf("<title") < 0 || string.indexOf("</title>") < 0) continue;
            string2 = string.trim();
            bl = true;
            break;
        }
        if (!bl) {
            return string2;
        }
        String string3 = "<title[^>]*>[^<]*</title>";
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            string2 = matcher.group();
        }
        string2 = XMLShop.parseString(string2);
        return string2;
    }

    private static Format getXMLFormat() {
        Format format = Format.getPrettyFormat();
        if (Charset.isSupported(GlobalSettings.charEncoding) && XMLShop.isEncodingSupported(GlobalSettings.charEncoding)) {
            format.setEncoding(GlobalSettings.charEncoding);
        }
        return format;
    }

    private static String parseString(String string) {
        SAXBuilder sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        XMLShop.setDefaultEntityResolver(sAXBuilder);
        string = "<?xml version=\"1.0\"?><!DOCTYPE Meta SYSTEM \"http://www.null.dtd\">" + string;
        StringReader stringReader = new StringReader(string);
        try {
            Document document = sAXBuilder.build(stringReader);
            return document.getRootElement().getTextNormalize();
        }
        catch (IOException iOException) {
        }
        catch (JDOMException jDOMException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        string = string.replaceAll("<title[^>]*>", "");
        string = string.replaceAll("</title>", "");
        return string;
    }
}

