/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.blowfishj;

import java.security.SecureRandom;
import java.util.Random;
import net.sourceforge.blowfishj.BinConverter;
import net.sourceforge.blowfishj.BlowfishCBC;
import net.sourceforge.blowfishj.SHA1;

public class BlowfishEasy {
    BlowfishCBC m_bfc;
    static SecureRandom _srnd = new SecureRandom();

    public BlowfishEasy(String sPassword) {
        SHA1 sh = null;
        sh = new SHA1();
        int nC = sPassword.length();
        for (int nI = 0; nI < nC; ++nI) {
            sh.update((byte)(sPassword.charAt(nI) & 0xFF));
        }
        sh.finalize();
        byte[] hash = new byte[20];
        sh.getDigest(hash, 0);
        this.m_bfc = new BlowfishCBC(hash, 0, hash.length, 0L);
    }

    public BlowfishEasy(char[] passw) {
        SHA1 sh = null;
        sh = new SHA1();
        int nC = passw.length;
        for (int nI = 0; nI < nC; ++nI) {
            sh.update((byte)(passw[nI] >> 8 & 0xFF));
            sh.update((byte)(passw[nI] & 0xFF));
        }
        sh.finalize();
        byte[] hash = new byte[20];
        sh.getDigest(hash, 0);
        this.m_bfc = new BlowfishCBC(hash, 0, hash.length, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptString(String sPlainText) {
        long lCBCIV;
        SecureRandom secureRandom = _srnd;
        synchronized (secureRandom) {
            lCBCIV = _srnd.nextLong();
        }
        return this.encStr(sPlainText, lCBCIV);
    }

    public String encryptString(String sPlainText, Random rndGen) {
        return this.encStr(sPlainText, rndGen.nextLong());
    }

    private String encStr(String sPlainText, long lNewCBCIV) {
        int nStrLen = sPlainText.length();
        byte[] buf = new byte[(nStrLen << 1 & 0xFFFFFFF8) + 8];
        int nPos = 0;
        for (int nI = 0; nI < nStrLen; ++nI) {
            char cActChar = sPlainText.charAt(nI);
            buf[nPos++] = (byte)(cActChar >> 8 & 0xFF);
            buf[nPos++] = (byte)(cActChar & 0xFF);
        }
        byte bPadVal = (byte)(buf.length - (nStrLen << 1));
        while (nPos < buf.length) {
            buf[nPos++] = bPadVal;
        }
        this.m_bfc.setCBCIV(lNewCBCIV);
        this.m_bfc.encrypt(buf, 0, buf, 0, buf.length);
        byte[] newCBCIV = new byte[8];
        BinConverter.longToByteArray(lNewCBCIV, newCBCIV, 0);
        return BinConverter.bytesToHexStr(newCBCIV, 0, 8) + BinConverter.bytesToHexStr(buf, 0, buf.length);
    }

    public String decryptString(String sCipherText) {
        int nLen = sCipherText.length() >> 1 & 0xFFFFFFF8;
        if (8 > nLen) {
            return null;
        }
        byte[] cbciv = new byte[8];
        int nNumOfBytes = BinConverter.hexStrToBytes(sCipherText, cbciv, 0, 0, 8);
        if (nNumOfBytes < 8) {
            return null;
        }
        this.m_bfc.setCBCIV(cbciv, 0);
        if ((nLen -= 8) == 0) {
            return "";
        }
        byte[] buf = new byte[nLen];
        nNumOfBytes = BinConverter.hexStrToBytes(sCipherText, buf, 16, 0, nLen);
        if (nNumOfBytes < nLen) {
            return null;
        }
        this.m_bfc.decrypt(buf, 0, buf, 0, buf.length);
        int nPadByte = buf[buf.length - 1] & 0xFF;
        if (8 < nPadByte) {
            nPadByte = 0;
        }
        if ((nNumOfBytes -= nPadByte) < 0) {
            return "";
        }
        return BinConverter.byteArrayToStr(buf, 0, nNumOfBytes);
    }

    public void destroy() {
        this.m_bfc.cleanUp();
    }
}

