/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

/**
 * Class for displaying a MessageBox in an easy way in just one method call.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class MessageBoxFactory {

  /** This utility class constructor is hidden */
  private MessageBoxFactory() {
  // Protect default constructor
  }

  /**
   * Show an error message dialog
   * 
   * @param shell The shell
   * @param e The exception
   */
  public static void showError(Shell shell, Exception e) {
    showError(shell, e.getLocalizedMessage());
  }

  /**
   * Show an error message dialog
   * 
   * @param shell The shell
   * @param errorMsg The error message
   */
  public static void showError(Shell shell, String errorMsg) {

    /** Create new Shell in case Shell was disposed before */
    if (shell.isDisposed())
      shell = new Shell(Display.getCurrent());

    MessageBox box = new MessageBox(shell, SWT.ICON_ERROR);
    box.setText(GUI.i18n.getTranslation("MESSAGE_BOX_TITLE_ERROR"));
    box.setMessage(errorMsg);
    box.open();
  }

  /**
   * Show a message box
   * 
   * @param shell The shell
   * @param style Style of the message box
   * @param title Title of the message box
   * @param message Message of the message box
   * @return int Key that the user has clicked
   */
  public static int showMessage(Shell shell, int style, String title, String message) {

    /** Create new Shell in case Shell was disposed before */
    if (shell.isDisposed())
      shell = new Shell(Display.getCurrent());

    MessageBox box = new MessageBox(shell, style);
    box.setText(title);
    box.setMessage(message);
    return box.open();
  }
}