/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.popup;

import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.PaintShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/**
 * The favorite popup appears when right-clicking on any favorite in the tree.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class FavoritePopup {
  private Menu popUpMenu;
  EventManager eventManager;
  Shell shell;

  /**
   * Instantiate a new FavoritePopup
   * 
   * @param shell The shell
   * @param popUpMenu The menu to add this menu to
   * @param eventManager The event manager
   */
  public FavoritePopup(Shell shell, Menu popUpMenu, EventManager eventManager) {
    this.shell = shell;
    this.popUpMenu = popUpMenu;
    this.eventManager = eventManager;

    /** Init the popup */
    initFavMenu();
  }

  /** Init the popup menuStructure for a favorite */
  private void initFavMenu() {

    /** Open the selected favorite */
    MenuItem open = new MenuItem(popUpMenu, SWT.PUSH);
    open.setText(GUI.i18n.getTranslation("BUTTON_OPEN"));
    open.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionHandleTreeItemSelect();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Mark selected favorite read */
    MenuItem markRead = new MenuItem(popUpMenu, SWT.PUSH);
    markRead.setText(GUI.i18n.getTranslation("POP_MARK_FAVORITE_READ"));
    markRead.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionMarkFavoriteRead();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Reload selected favorite */
    MenuItem reload = new MenuItem(popUpMenu, SWT.PUSH);
    reload.setText(GUI.i18n.getTranslation("BUTTON_RELOAD"));
    if (!GlobalSettings.isMac())
      reload.setImage(PaintShop.iconReload);
    reload.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionReloadFeed();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Search in selected favorite */
    MenuItem search = new MenuItem(popUpMenu, SWT.PUSH);
    search.setText(GUI.i18n.getTranslation("SEARCH_DIALOG_TITLE") + "...");
    if (!GlobalSettings.isMac())
      search.setImage(PaintShop.iconFind);
    search.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionSearchInFeed();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** New Menu */
    MenuItem newCatOrFav = new MenuItem(popUpMenu, SWT.CASCADE);
    newCatOrFav.setText(GUI.i18n.getTranslation("POP_NEW"));
    if (!GlobalSettings.isMac())
      newCatOrFav.setImage(PaintShop.iconNew);

    Menu selectNewCatOrFav = new Menu(shell, SWT.DROP_DOWN);
    newCatOrFav.setMenu(selectNewCatOrFav);

    /** Create a new favorite */
    MenuItem cascadeItemNewFav = new MenuItem(selectNewCatOrFav, SWT.PUSH);
    cascadeItemNewFav.setText(GUI.i18n.getTranslation("LABEL_FAVORITE") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemNewFav.setImage(PaintShop.iconAddToFavorites);
    cascadeItemNewFav.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionNewFavorite();
      }
    });

    /** Separator */
    new MenuItem(selectNewCatOrFav, SWT.SEPARATOR);

    /** Create a new Sub category */
    MenuItem cascadeItemNewCat = new MenuItem(selectNewCatOrFav, SWT.PUSH);
    cascadeItemNewCat.setText(GUI.i18n.getTranslation("LABEL_CATEGORY") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemNewCat.setImage(PaintShop.iconAddCategory);
    cascadeItemNewCat.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionNewCategory(true);
      }
    });

    /** Rename selected favorite */
    MenuItem rename = new MenuItem(popUpMenu, SWT.PUSH);
    rename.setText(GUI.i18n.getTranslation("MENU_EDIT_RENAME"));
    rename.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionRenameSelectedItem();
      }
    });

    /** Delete selected favorite */
    MenuItem delete = new MenuItem(popUpMenu, SWT.PUSH);
    delete.setText(GUI.i18n.getTranslation("MENU_EDIT_DELETE"));
    if (!GlobalSettings.isMac())
      delete.setImage(PaintShop.iconDelete);
    delete.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionDeleteFavorite();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Copy favorite's URL */
    MenuItem copyXmlLocation = new MenuItem(popUpMenu, SWT.PUSH);
    copyXmlLocation.setText(GUI.i18n.getTranslation("POP_COPY_NEWS_URL"));
    copyXmlLocation.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionCopyFavoritesXmlLocation();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Import OPML files */
    MenuItem importMenu = new MenuItem(popUpMenu, SWT.CASCADE);
    importMenu.setText(GUI.i18n.getTranslation("POP_IMPORT"));
    if (!GlobalSettings.isMac())
      importMenu.setImage(PaintShop.iconImport);

    Menu selectImport = new Menu(shell, SWT.DROP_DOWN);
    importMenu.setMenu(selectImport);

    /** Import OPML */
    MenuItem cascadeItemImportOPML = new MenuItem(selectImport, SWT.PUSH);
    cascadeItemImportOPML.setText(GUI.i18n.getTranslation("POP_FROM_OPML") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemImportOPML.setImage(PaintShop.iconImportOpml);
    cascadeItemImportOPML.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionImportOPML();
      }
    });

    /** Import Synchronized Blogroll */
    MenuItem cascadeItemImportBlogroll = new MenuItem(selectImport, SWT.PUSH);
    cascadeItemImportBlogroll.setText(GUI.i18n.getTranslation("POP_IMPORT_BLOGROLL") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemImportBlogroll.setImage(PaintShop.iconAddBlogroll);
    cascadeItemImportBlogroll.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionImportBlogroll();
      }
    });

    /** Export to OPML */
    MenuItem export = new MenuItem(popUpMenu, SWT.CASCADE);
    export.setText(GUI.i18n.getTranslation("BUTTON_EXPORT"));
    if (!GlobalSettings.isMac())
      export.setImage(PaintShop.iconExport);

    Menu selectexport = new Menu(shell, SWT.DROP_DOWN);
    export.setMenu(selectexport);

    /** Create an OPML file */
    MenuItem cascadeItemCreateOPML = new MenuItem(selectexport, SWT.PUSH);
    cascadeItemCreateOPML.setText(GUI.i18n.getTranslation("POP_EXPORT_OPML") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemCreateOPML.setImage(PaintShop.iconExportOpml);
    cascadeItemCreateOPML.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionFavoriteToOPML();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Edit selected favorite */
    MenuItem edit = new MenuItem(popUpMenu, SWT.PUSH);
    edit.setText(GUI.i18n.getTranslation("POP_PROPERTIES"));
    edit.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionEditFavorite();
      }
    });
  }
}