/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * Class displays a PropertyPage to configure a blogging tool for RSSOwl
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class BloggerProperties extends PropertyPage {
  Text bloggerArguments;
  Text bloggerPath;

  /**
   * Instatiate a new BloggerProperties PropertyPage
   * 
   * @param parent Composite's parent
   */
  public BloggerProperties(Composite parent) {
    super(parent);
    setRestoreButtonState(false);
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#applyButtonPressed()
   */
  public void applyButtonPressed() {
    GlobalSettings.bloggerArguments = bloggerArguments.getText();
    GlobalSettings.bloggerPath = bloggerPath.getText();
    updatePropertiesChangeManager();
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#updatePropertiesChangeManager()
   */
  public void updatePropertiesChangeManager() {
    propertyChangeManager.setBloggerArguments(bloggerArguments.getText());
    propertyChangeManager.setBloggerPath(bloggerPath.getText());
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#initComponents()
   */
  protected void initComponents() {

    /** Group for the external blogger path components */
    Group externalBloggerGroup = new Group(composite, SWT.NONE);
    externalBloggerGroup.setLayoutData(LayoutDataShop.createGridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.FILL_HORIZONTAL, 2));
    externalBloggerGroup.setText(GUI.i18n.getTranslation("LABEL_SELECT_BLOGGER"));
    externalBloggerGroup.setLayout(new GridLayout(2, false));
    externalBloggerGroup.setFont(FontShop.dialogFont);

    /** Message Label */
    Label messageLabel = new Label(externalBloggerGroup, SWT.WRAP);
    messageLabel.setText(GUI.i18n.getTranslation("DIALOG_SELECT_EXTERNAL_BROWSER") + ": ");
    messageLabel.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    messageLabel.setFont(dialogFont);

    bloggerPath = new Text(externalBloggerGroup, SWT.SINGLE | SWT.BORDER);
    bloggerPath.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    bloggerPath.setFont(dialogFont);
    bloggerPath.setText(propertyChangeManager.getBloggerPath());
    bloggerPath.addModifyListener(new ModifyListener() {

      /** Disable blogger arguments if no blogger is given */
      public void modifyText(ModifyEvent e) {
        bloggerArguments.setEnabled(!bloggerPath.getText().equals(""));

        /** Show error in case path is not valid */
        if (StringShop.isset(bloggerPath.getText()))
          setErrorMessage(FileShop.exists(bloggerPath.getText()) ? null : GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND"));

        /** Reset Error Message */
        else
          setErrorMessage(null);
      }
    });

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(bloggerPath);

    /** Button to search in Filesystem */
    Button searchBlogger = new Button(externalBloggerGroup, SWT.PUSH);
    searchBlogger.setText(GUI.i18n.getTranslation("BUTTON_SEARCH") + "...");
    searchBlogger.setFont(dialogFont);
    searchBlogger.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        String file = FileShop.getFilePath(composite.getShell(), null, null, SWT.OPEN, bloggerPath.getText(), GUI.i18n.getTranslation("MENU_BLOGGER"));

        if (file != null)
          bloggerPath.setText(file);
      }
    });

    /** Apply layoutdata to button */
    setButtonLayoutData(searchBlogger);

    /** Error Label in case the path is not valid */
    errorMessageLabel = new CLabel(externalBloggerGroup, SWT.NONE);
    errorMessageLabel.setFont(dialogFont);
    errorMessageLabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));

    /** Show error label in case a path is not valid */
    if (StringShop.isset(bloggerPath.getText()))
      setErrorMessage(FileShop.exists(bloggerPath.getText()) ? null : GUI.i18n.getTranslation("ERROR_FILE_NOT_FOUND"));

    /** Group for the arguments components */
    Group argumentsGroup = new Group(composite, SWT.NONE);
    argumentsGroup.setLayoutData(LayoutDataShop.createGridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.FILL_HORIZONTAL, 2));
    argumentsGroup.setText(GUI.i18n.getTranslation("GROUP_ARGUMENTS"));
    argumentsGroup.setLayout(new GridLayout(2, false));
    argumentsGroup.setFont(FontShop.dialogFont);

    /** Blogger arguments */
    bloggerArguments = new Text(argumentsGroup, SWT.SINGLE | SWT.BORDER);
    bloggerArguments.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    bloggerArguments.setFont(dialogFont);
    bloggerArguments.setText(propertyChangeManager.getBloggerArguments());

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(bloggerArguments);

    /** Disable blogger arguments if no blogger is given */
    bloggerArguments.setEnabled(!bloggerPath.getText().equals(""));

    WidgetShop.createWildCardMenu(bloggerArguments, new String[] { "[NEWSLINK]", "[FEEDLINK]", "[TITLE]", "[AUTHOR]", "[CATEGORY]", "[DESCRIPTION]", "[PUBDATE]", "[PUBLISHER]", "[SOURCE]" });

    /** Message Label */
    Label argumentsLabel = new Label(argumentsGroup, SWT.WRAP);
    argumentsLabel.setText(GUI.i18n.getTranslation("LABEL_BLOGGER_USAGE"));
    argumentsLabel.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    argumentsLabel.setFont(dialogFont);

    /** Fill with some spacer */
    LayoutShop.setDialogSpacer(composite, 2, 3);

    /** Set Mnemonics to Buttons */
    WidgetShop.initMnemonics(new Button[] { searchBlogger });
  }

  /**
   * This property page does not support the restore action. The restore button
   * is disabled.
   */
  protected void restoreButtonPressed() {
  // Not necessary
  }
}