/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/**
 * A favorite property page holds components to set properties to a favorite in
 * RSSOwl.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public abstract class FavoritePropertyPage {

  /** Holds the Property Page */
  protected Composite composite;

  /** Font to use for the components */
  protected Font dialogFont = FontShop.dialogFont;

  /** Parent of the composite */
  protected Composite parent;

  /** The favorite that is currently edited */
  protected Favorite rssOwlFavorite;

  /**
   * Instantiates a new FavoritePropertyPage
   * 
   * @param parent Composite's parent
   * @param rssOwlFavorite The favorite that will be edited or viewed
   */
  protected FavoritePropertyPage(Composite parent, Favorite rssOwlFavorite) {
    this.parent = parent;
    this.rssOwlFavorite = rssOwlFavorite;
    createComposite();
    initComponents();
  }

  /** Create the composite that holds the PropertyPage */
  protected void createComposite() {
    composite = new Composite(parent, SWT.NONE);
    composite.setLayout(LayoutShop.createGridLayout(2, 0, 10, 10));
    composite.setLayoutData(new GridData(GridData.FILL_BOTH));
  }

  /** Init all components */
  protected abstract void initComponents();
}