/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.model.Favorite;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import java.util.Date;
import java.util.Locale;

/**
 * Display information about the edited favorite
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class ViewFavoriteProperties extends FavoritePropertyPage {

  /**
   * Instatiate a new ViewFavoriteProperties propertypage
   * 
   * @param parent Composite's parent
   * @param rssOwlFavorite The favorite that is currently edited
   */
  public ViewFavoriteProperties(Composite parent, Favorite rssOwlFavorite) {
    super(parent, rssOwlFavorite);
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#initComponents()
   */
  protected void initComponents() {

    /** Favorite Title */
    Label favTitleLabel = new Label(composite, SWT.NONE);
    favTitleLabel.setText(GUI.i18n.getTranslation("LABEL_TITLE") + ": ");
    favTitleLabel.setFont(FontShop.dialogFont);

    Text favTitle = new Text(composite, SWT.READ_ONLY | SWT.BORDER);
    favTitle.setText(rssOwlFavorite.getTitle());
    favTitle.setFont(FontShop.dialogFont);
    favTitle.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(favTitle);

    /** Favorite URL */
    Label favURLLabel = new Label(composite, SWT.NONE);
    favURLLabel.setText(GUI.i18n.getTranslation("LABEL_URL_PATH") + ": ");
    favURLLabel.setFont(FontShop.dialogFont);

    Text favURL = new Text(composite, SWT.READ_ONLY | SWT.BORDER);
    favURL.setText(rssOwlFavorite.getUrl());
    favURL.setFont(FontShop.dialogFont);
    favURL.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(favURL);

    /** Favorite description */
    Label favDescriptionLabel = new Label(composite, SWT.NONE);
    favDescriptionLabel.setText(GUI.i18n.getTranslation("LABEL_DESCRIPTION") + ": ");
    favDescriptionLabel.setLayoutData(new GridData(SWT.BEGINNING, SWT.BEGINNING, false, false));
    favDescriptionLabel.setFont(FontShop.dialogFont);

    Text favDescription = new Text(composite, SWT.READ_ONLY | SWT.BORDER | SWT.MULTI | SWT.V_SCROLL | SWT.WRAP);
    favDescription.setText(rssOwlFavorite.getDescription());
    favDescription.setFont(FontShop.dialogFont);
    favDescription.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_BOTH, 1, SWT.DEFAULT, 50));

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(favDescription);

    /** Favorite Homepage */
    Label favHomepageLabel = new Label(composite, SWT.NONE);
    favHomepageLabel.setText(GUI.i18n.getTranslation("CHANNEL_INFO_HOMEPAGE") + ": ");
    favHomepageLabel.setFont(FontShop.dialogFont);

    final Text favHomepage = new Text(composite, SWT.READ_ONLY | SWT.BORDER);
    favHomepage.setText(rssOwlFavorite.getHomepage());
    favHomepage.setFont(FontShop.dialogFont);
    favHomepage.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

    /** Allow to open Homepage on Click if set */
    if (StringShop.isset(rssOwlFavorite.getHomepage()) && RegExShop.isValidURL(rssOwlFavorite.getHomepage())) {
      favHomepage.setCursor(GUI.display.getSystemCursor(SWT.CURSOR_HAND));
      favHomepage.setToolTipText(GUI.i18n.getTranslation("TOOLTIP_URLOPEN"));

      /** URL openes after click on it */
      favHomepage.addMouseListener(new MouseAdapter() {

        /** Open link if selection is empty */
        public void mouseUp(MouseEvent e) {

          /** User has clicked on the link with not selecting it */
          if (e.button == 1 && favHomepage.getSelectionCount() == 0)
            GUI.rssOwlGui.getEventManager().actionOpenURL(rssOwlFavorite.getHomepage());
        }
      });
    }

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(favHomepage);

    /** Favorite language */
    Label favLanguageLabel = new Label(composite, SWT.NONE);
    favLanguageLabel.setText(GUI.i18n.getTranslation("MENU_LANGUAGE") + ": ");
    favLanguageLabel.setFont(FontShop.dialogFont);

    Text favLanguage = new Text(composite, SWT.READ_ONLY | SWT.BORDER);
    favLanguage.setFont(FontShop.dialogFont);
    favLanguage.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(favLanguage);

    /** Translate language to selected locale */
    if (StringShop.isset(rssOwlFavorite.getLanguage())) {
      if (rssOwlFavorite.getLanguage().split("-").length == 2)
        favLanguage.setText(new Locale(rssOwlFavorite.getLanguage().split("-")[0]).getDisplayLanguage(Dictionary.selectedLocale));
      else
        favLanguage.setText(new Locale(rssOwlFavorite.getLanguage()).getDisplayLanguage(Dictionary.selectedLocale));
    }

    /** Favorite creationDate */
    Label favCreationDateLabel = new Label(composite, SWT.NONE);
    favCreationDateLabel.setText(GUI.i18n.getTranslation("LABEL_CREATED") + ": ");
    favCreationDateLabel.setFont(FontShop.dialogFont);

    Text favCreationDate = new Text(composite, SWT.READ_ONLY | SWT.BORDER);
    favCreationDate.setFont(FontShop.dialogFont);
    favCreationDate.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(favCreationDate);

    if (rssOwlFavorite.getCreationDate() != 0)
      favCreationDate.setText(DateParser.formatDate(new Date(rssOwlFavorite.getCreationDate()), true, true));

    /** Favorite lastVisitDate */
    Label favLastVisitDateLabel = new Label(composite, SWT.NONE);
    favLastVisitDateLabel.setText(GUI.i18n.getTranslation("LABEL_LAST_VISIT") + ": ");
    favLastVisitDateLabel.setFont(FontShop.dialogFont);

    Text favLastVisitDate = new Text(composite, SWT.READ_ONLY | SWT.BORDER);
    favLastVisitDate.setFont(FontShop.dialogFont);
    favLastVisitDate.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(favLastVisitDate);

    if (rssOwlFavorite.getLastVisitDate() != 0)
      favLastVisitDate.setText(DateParser.formatDate(new Date(rssOwlFavorite.getLastVisitDate()), true, true));
  }
}