/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util;

import net.sourceforge.rssowl.util.i18n.Dictionary;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

import java.util.ArrayList;

/**
 * This class holds some settings the user has made in RSSOwl. A lot of Objects
 * in RSSOwl need to access them, thats why they are declared public and static.
 * Also contains some constants that are used in the application.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class GlobalSettings {

  /**
   * Developer Flag indicating state of debug mode. <br />
   * In Debug mode, RSSOwl will print a lot of information helpful for
   * problem-debugging to the console.<br />
   * <br />
   * Set the value of this flag by passing following DWord:
   * "net.sourceforge.rssowl.debug"
   */
  public static boolean _IS_DEBUG = false;

  /**
   * Developer Flag indicating a pre release version. <br />
   * !!! PLEASE DO NOT CHANGE THIS VALUE !!!
   */
  public static final boolean _IS_PRE_RELEASE = false;

  /**
   * AmphetaRate Password (Disabled as of ver. 1.2.3)
   */
  public static String amphetaRatePassword;

  /**
   * AmphetaRate User ID (Disabled as of ver. 1.2.3)
   */
  public static String amphetaRateUserID;

  /**
   * AmphetaRate Username (Disabled as of ver. 1.2.3)
   */
  public static String amphetaRateUsername;

  /**
   * TRUE: Move the Popup in, from right to left <br />
   * FALSE: Just show the Popup
   */
  public static boolean animateNewsPopup;

  /**
   * Dir to write the archive. Has to be writeable
   */
  public static String ARCHIVE_DIR;

  /**
   * TRUE: Close news popup automatically after some time <br />
   * FALSE: Do not close news popup automatically
   */
  public static boolean autoCloseNewsPopup;

  /**
   * TRUE: Sort news based on the sortOrder settings <br />
   * FALSE: Do not sort news, leave it as in the XML document
   */
  public static boolean autoSortNews;

  /**
   * TRUE: Block popups from the internal browser <br />
   * FALSE: Do not block popups from the internal browser<br />
   * <br />
   * Note: This setting is ignored on Linux, since Mozilla is taking care of
   * popups for itself.
   */
  public static boolean blockPopups;

  /**
   * Arguments of the blogger
   */
  public static String bloggerArguments;

  /**
   * Path to the executable of the blogger
   */
  public static String bloggerPath;

  /**
   * Dir to write the cache. Has to be writeable
   */
  public static String CACHE_DIR;

  /**
   * Set the character encoding - Default: UTF-8
   */
  public static String charEncoding = "UTF-8";

  /**
   * TRUE: Check for an updated version of RSSOwl on startup <br />
   * FALSE: Do not check for an updated version of RSSOwl on startup
   */
  public static boolean checkUpdate;

  /**
   * TRUE: Show a confirm dialog when deleting a blogroll <br />
   * FALSE: Do not show a confirm dialog when deleting a blogroll
   */
  public static boolean confirmBlogrollDeletion;

  /**
   * TRUE: Show a confirm dialog when deleting a category <br />
   * FALSE: Do not show a confirm dialog when deleting a category
   */
  public static boolean confirmCategoryDeletion;

  /**
   * TRUE: Show a confirm dialog when deleting a favorite <br />
   * FALSE: Do not show a confirm dialog when deleting a favorite
   */
  public static boolean confirmFavoriteDeletion;

  /**
   * Connection Timeout for all HttpClient connections in seconds
   */
  public static int connectionTimeout;

  /**
   * Weights of the Sashform dividing Favorites-Tree from the rest.
   */
  public static int[] contentSashWeights = new int[] { 25, 75 };

  /**
   * The path to the file that is used to store sensitive user data
   */
  public static String CRYPT_FILE;

  /**
   * Custom Browser executable path
   */
  public static String customBrowser;

  /**
   * Custom Browser arguments
   */
  public static String customBrowserArguments;

  /**
   * The default Sort Order for News
   */
  public static String[] defaultSortOrder = new String[] { "TABLE_HEADER_PUBDATE", "TABLE_HEADER_STATUS", "TABLE_HEADER_NEWSTITLE", "TABLE_HEADER_AUTHOR", "TABLE_HEADER_CATEGORY", "TABLE_HEADER_PUBLISHER", "TABLE_HEADER_FEED" };

  /**
   * TRUE: Open each selected news in browser <br />
   * FALSE: Do not open each selected news in browser
   */
  public static boolean directOpenEachNews;

  /**
   * TRUE: Open news directly in the browser if description is empty <br />
   * FALSE: Do not open news directly in the browser if description is empty
   */
  public static boolean directOpenNews;

  /**
   * TRUE: Display only one tab <br />
   * FALSE: Display multiple tabs
   */
  public static boolean displaySingleTab;

  /**
   * Default Auto reload intervall for new favorites
   */
  public static int favDefaultAutoReloadInterval;

  /**
   * Default boolean value for a new favorite
   */
  public static boolean favDefaultOpenOnStartup;

  /**
   * Default boolean value for a new favorite
   */
  public static boolean favDefaultReloadOnStartup;

  /**
   * TRUE: Focus on new opened tabs <br />
   * FALSE: Do not focus on new opened tabs
   */
  public static boolean focusNewTabs;

  /**
   * TRUE: Format NewsTip mail with HTML tags <br />
   * FALSE: Do not format NewsTip mail with HTML tags
   */
  public static boolean htmlFormatMail;

  /**
   * TRUE: Open category / favorites in Tree with a Double click <br />
   * FALSE: Open category / favorites in Tree with a Single click
   */
  public static boolean isDoubleClickOpen;

  /**
   * TRUE: Show Favorites Tree <br />
   * FALSE: Do not show Favorites tree
   */
  public static boolean isFavoritesTreeShown;

  /**
   * TRUE: Show Quickview window in top of RSSOwl <br />
   * FALSE: Do not show Quickview window
   */
  public static boolean isQuickviewShown;

  /**
   * TRUE: The Application Shell is Maximized<br />
   * FALSE: The Application Shell is not Maximized
   */
  public static boolean isShellMaximized;

  /**
   * TRUE: GUI has three columns to display URL Tree, Newsheader and Newstext
   * <br />
   * FALSE: GUI has two columns, second column is divided into two rows.
   */
  public static boolean isThreeColumnGUI;

  /**
   * TRUE: Show ToolBar window in top of RSSOwl <br />
   * FALSE: Do not show ToolBar window
   */
  public static boolean isToolBarShown;

  /**
   * TRUE: The Tree ToolBar is visible<br />
   * FALSE: The Tree ToolBar is not visible
   */
  public static boolean isTreeToolBarShown;

  /**
   * TRUE: Display the welcome tab <br />
   * FALSE: Do not display the welcome tab
   */
  public static boolean isWelcomeShown;

  /**
   * Selected link color
   */
  public static RGB linkColor;

  /**
   * TRUE: Link Favorites Tree with displayed Feed <br />
   * FALSE: No Linking
   */
  public static boolean linkTreeWithTab;

  /**
   * TRUE: Save loaded feeds to the local cache folder <br />
   * FALSE: Do not save loaded feeds to the local cache folder
   */
  public static boolean localCacheFeeds;

  /**
   * Dir to write the logs. Has to be writeable
   */
  public static String LOGS_DIR;

  /**
   * Body of the NewsTip mail
   */
  public static String mailBody;

  /**
   * String of the NewsTip mail
   */
  public static String mailSubject;

  /**
   * TRUE: Mark all news read on window minimization <br />
   * FALSE: Do not mark all news read on window minimization
   */
  public static boolean markAllReadOnMinimize;

  /**
   * TRUE: Mark news of displayed tab read on tab close <br />
   * FALSE: Do not mark news of displayed tab read on tab close
   */
  public static boolean markFeedReadOnTabClose;

  /**
   * The maximum number of connections at one time
   */
  public static int maxConnectionCount;

  /**
   * Weights of the SashForm dividing Newsheader-Table from Newstext-Panel.
   */
  public static int[] newsSashWeights = new int[] { 60, 40 };

  /**
   * TRUE: Open the browser external <br />
   * FALSE: Use the internal browser in RSSOwl
   */
  public static boolean openBrowserExtern;

  /**
   * TRUE: Open each internal browser in a new tab <br />
   * FALSE: Open each internal browser in the same tab
   */
  public static boolean openNewBrowserWindow;

  /**
   * OS dependant File separator
   */
  public static String PATH_SEPARATOR = System.getProperty("file.separator");

  /**
   * TRUE: Re-Open feeds that were opened on startup <br />
   * FALSE: Do not re-Open feeds that were opened on startup
   */
  public static boolean reopenFeeds;

  /**
   * The path to the file that is used to cache settings for RSSOwl.
   */
  public static String RSSOWL_SETTINGS_FILE;

  /**
   * The path to the file that is used to backup settings for RSSOwl.
   */
  public static String RSSOWL_SETTINGS_BACKUP_FILE;

  /**
   * Save the last selected tree item
   */
  public static String selectedTreeItem = "";

  /**
   * TRUE: On Proxy activation, activate it for all favorites <br />
   * FALSE: On Proxy activation, do not activate it for all favorites
   */
  public static boolean setProxyForAllFavorites;

  /**
   * The Bounds of the Application Shell
   */
  public static Rectangle shellBounds;

  /**
   * TRUE: Display channel info of RSS / RDF feeds <br />
   * FALSE: Do not display channel info of RSS / RDF feeds
   */
  public static boolean showChannelInfo;

  /**
   * TRUE: Show errors in tabs <br />
   * FALSE: Do not show errors in tabs
   */
  public static boolean showErrors;

  /**
   * TRUE: Place application in tray after minimize <br />
   * FALSE: Do not place application in tray after minimize
   */
  public static boolean showSystrayIcon;

  /**
   * TRUE: Show the close button on each CTabItem <br />
   * FALSE: Do not show a close button on the CTabItems
   */
  public static boolean showTabCloseButton;

  /**
   * TRUE: Show the tray popup when unread news are downloaded <br />
   * FALSE: Do not show the tray popup when unread news are downloaded
   */
  public static boolean showTrayPopup;

  /**
   * TRUE: Use simple styled tabs <br />
   * FALSE: Use curved styled tabs
   */
  public static boolean simpleTabs;

  /**
   * Sort order for the News
   */
  public static ArrayList sortOrder;

  /**
   * Selected syntaxhighlight color
   */
  public static RGB syntaxHighlightColor;

  /**
   * TRUE: Tabs in TabFolder are displayed on TOP of the Control <br />
   * FALSE: Tabs in TabFolder are displayed on BOTTOM of the Control
   */
  public static boolean tabPositionIsTop;

  /**
   * Dir to write temp files. Has to be writeable
   */
  public static String TEMP_DIR;

  /**
   * The path to the file that is used to cache exports as XML file.
   */
  public static String TEMP_EXPORT_FILE;

  /**
   * The path to the file that is used to cache feeds as XML file.
   */
  public static String TEMP_FEED_FILE;

  /**
   * The number and order of ToolItems in the ToolBar as colon-seperated String
   * value.
   */
  public static String toolBarItems;

  /**
   * The ToolBar Mode. Either "Icons and Text", "Icons" or "Text".
   */
  public static int toolBarMode;

  /**
   * TRUE: Minimize RSSOwl to tray on exit <br />
   * FALSE: Do not minimize RSSOwl to tray on exit
   */
  public static boolean trayOnExit;

  /**
   * TRUE: Minimize RSSOwl to tray on startup <br />
   * FALSE: Do not minimize RSSOwl to tray on startup
   */
  public static boolean trayOnStartup;

  /**
   * TRUE: Display newstext in internal browser <br />
   * FALSE: Display newstext in Text-Box
   */
  public static boolean useBrowserForNewsText;

  /**
   * TRUE: Use Small Icons for the ToolBar<br />
   * FALSE: Use Big Icons for the ToolBar
   */
  public static boolean useSmallIcons;

  /**
   * Dir to write temporary files. Has to be writeable
   */
  public static String WORKING_DIR;

  /**
   * TRUE: RSSOwl is in offline mode <br />
   * FALSE: RSSOwl is not in offline mode
   */
  public static boolean workOffline;

  /** Flag specifying if OS is Linux */
  private static boolean isLinux = SWT.getPlatform().equalsIgnoreCase("gtk");

  /** Flag specifying if OS is Mac */
  private static boolean isMac = SWT.getPlatform().equalsIgnoreCase("carbon");

  /** Flag specifying if OS is Solaris */
  private static boolean isSolaris = SWT.getPlatform().equalsIgnoreCase("motif");

  /** Flag specifying if OS is Windows */
  private static boolean isWindows = SWT.getPlatform().equalsIgnoreCase("win32");

  /** This utility class constructor is hidden */
  private GlobalSettings() {
  // Protect default constructor
  }

  /**
   * Return TRUE if the platform is Linux
   * 
   * @return boolean TRUE if platform is Linux
   */
  public static boolean isLinux() {
    return isLinux;
  }

  /**
   * Return TRUE if the platform is Mac
   * 
   * @return boolean TRUE if platform is Mac
   */
  public static boolean isMac() {
    return isMac;
  }

  /**
   * Return TRUE if the platform is Solaris
   * 
   * @return boolean TRUE if platform is Solaris
   */
  public static boolean isSolaris() {
    return isSolaris;
  }

  /**
   * Return TRUE if the platform is Windows
   * 
   * @return boolean TRUE if platform is Windows
   */
  public static boolean isWindows() {
    return isWindows;
  }

  /**
   * Check wether mnemonics should be displayed in the current selected
   * language. Currently Korean, Japanese, Chinese Simplified and Chinese
   * Traditional do not require display of Mnmeonics. Also on Mac, they should
   * not be displayed, since not supported by the OS.
   * 
   * @return boolean TRUE if Mnemonics should be displayed
   */
  public static boolean shouldShowMnemonics() {
    String lang = Dictionary.selectedLanguage;
    if (GlobalSettings.isMac() || lang.equals("ko") || lang.equals("ja") || lang.equals("zhcn") || lang.equals("zhtw"))
      return false;
    return true;
  }

  /**
   * Get wether the Internal Browser should be used Currently: win32, gtk and
   * mac supported
   * 
   * @return TRUE if it should be used
   */
  public static boolean useInternalBrowser() {
    return (isWindows() || isLinux() || isMac());
  }

  /**
   * Get wether iText should be used. That library is responsible to generate
   * PDF or RTF from a newsfeed. Mac is not supported, since on Mac its not
   * possible to use SWT and AWT in one application yet.
   * 
   * @return TRUE if it should be used
   */
  public static boolean useIText() {
    return (isWindows() || isLinux() || isSolaris());
  }

  /**
   * Get wether Printing should be used Currently: win32 / carbon / motif
   * supported
   * 
   * @return TRUE if it should be used
   */
  public static boolean usePrinting() {
    return (isWindows() || isSolaris() || isMac());
  }

  /**
   * Get which open-mode RSSOwl should use by default.
   * 
   * @return TRUE if mode should be Single-Click open.
   */
  public static boolean useSingleClickOpen() {
    return (isLinux() || isSolaris());
  }

  /**
   * Get wether system tray is supported Currently: win32 / gtk supported
   * 
   * @return TRUE if it should be used
   */
  public static boolean useSystemTray() {
    return (isWindows() || isLinux());
  }
}