/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.controller.thread.FeedSearchManager;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

/**
 * Abstract clas Dictionary provides information about the selected language,
 * the selected locale and declares a method to get a translation for a given
 * key.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public abstract class Dictionary {

  /**
   * List of languages of the translations that are provided
   */
  public static final Vector languages = new Vector();

  /**
   * List of Locales of the translations that are provided.
   */
  public static final Hashtable locales = new Hashtable();

  /**
   * Let all objects access what the current language is Default language for
   * RSSOwl is english.
   */
  public static String selectedLanguage = "en";

  /**
   * Let all objects access what the current Locale is Default locale for RSSOwl
   * is english.
   */
  public static Locale selectedLocale = new Locale(selectedLanguage);

  /**
   * Hashtable holds the class names that provide translations. The language of
   * the translation is the key for the class name.
   */
  public static final Hashtable translations = new Hashtable();

  /**
   * Register a translation to the dictionary
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   * @param hasLocalSearch TRUE if language has a locale search
   * @param translationClass The translation class Name
   */
  public static void register(String language, String country, boolean hasLocalSearch, String translationClass) {
    locales.put(language, new Locale(language, country));
    languages.add(language);
    translations.put(language, translationClass);

    /** Add to locale search list */
    if (hasLocalSearch)
      FeedSearchManager.addIntoLocaleSearchList(country.toLowerCase());
  }

  /**
   * Return the translated word for the given key
   * 
   * @param word Get translation for this word
   * @return String translated word
   */
  public abstract String getTranslation(String word);
}