/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Bulgarian internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov and Vassil Hristov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nBG extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nBG(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Файл");
    translation.put("MENU_SAVE", "Запиши като");
    translation.put("MENU_TOOLBAR", "Тулбар");
    translation.put("MENU_QUICKVIEW", "Бърз преглед");
    translation.put("MENU_GENERATE_PDF", "Генерирай PDF");
    translation.put("MENU_GENERATE_HTML", "Генерирай HTML");
    translation.put("MENU_GENERATE_RTF", "Генерирай RTF");
    translation.put("MENU_IMPORT", "Внеси настройки");
    translation.put("MENU_EXPORT", "Запамети настройки");
    translation.put("MENU_EXIT", "Изход");
    translation.put("MENU_WINDOW", "Покажи");
    translation.put("MENU_QUICKVIEW", "Бърз преглед");
    translation.put("MENU_PREFERENCES", "Преференции");
    translation.put("MENU_BROWSER", "Браузър");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Избери външен браузър");
    translation.put("MENU_FONT", "Шрифт");
    translation.put("MENU_ENCODING", "Енкодиране на текста");
    translation.put("MENU_LANGUAGE", "Език");
    translation.put("MENU_PROXY", "Прокси");
    translation.put("MENU_MISC", "Други");
    translation.put("MENU_DIRECTOPEN", "Автоотвори празни новини в браузър");
    translation.put("MENU_DIRECTOPENEACH", "Автоотвори всяка новина в браузър");
    translation.put("MENU_SYSTRAY", "RSSOwl като икона когато е минимизиран");
    translation.put("MENU_CHANNELINFO", "Покажи инфо за заглавията");
    translation.put("MENU_OPENNEW_BROWSER", "Винаги отваряй браузъра в нов таб");
    translation.put("MENU_BROWSER_EXTERN", "Отвори браузъра външно");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Показвай новините в браузър");
    translation.put("MENU_CHECK_UPDATE", "Провери нови версии след стартиране");
    translation.put("MENU_INFO", "Помощ");
    translation.put("MENU_ABOUT", "За RSSOwl");
    translation.put("MENU_LICENSE", "Лицензия");
    translation.put("MENU_UPDATE", "Провери за нова версия");
    translation.put("MENU_WELCOME", "Добре дошли");
    translation.put("MENU_DONATE", "Направи дарение");
    translation.put("MENU_TOOLS", "Инструменти");
    translation.put("MENU_MINIMIZE_RSSOWL", "Минимизирай RSSOwl");
    translation.put("MENU_GOTO", "Отиди на");
    translation.put("MENU_NEXT_NEWS", "Следващи новини");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Следващи непрочетени");
    translation.put("MENU_CLOSE", "Затвори");
    translation.put("MENU_CLOSE_ALL", "Затвори всичко");
    translation.put("MENU_PREVIOUS_TAB", "Предишен таб");
    translation.put("MENU_NEXT_TAB", "Следващ таб");
    translation.put("MENU_HOTKEYS", "Макроклавиши");
    translation.put("MENU_NEWSTIP_MAIL", "Форматирай NewsTip поща");
    translation.put("MENU_TELL_FRIENDS", "Кажи на приятел");
    translation.put("MENU_RELOAD", "Презареди");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Генерирай PDF от избраните новини");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Генерирай HTML от избраните новини");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Генерирай RTF от избраните новини");
    translation.put("MENU_MAILING_LIST", "Списък адреси");
    translation.put("MENU_TUTORIAL", "Опекунски");
    translation.put("MENU_COLORS", "Цветове");
    translation.put("MENU_BLOGGER", "Блогър");
    translation.put("MENU_WORKBENCH", "Работно място");
    translation.put("MENU_FEEDSEARCH", "Търсене на новини");
    translation.put("MENU_IMPORT_OPML", "Въведи от OPML");
    translation.put("MENU_VALIDATE", "Провери заглавие");
    translation.put("MENU_DISPLAY_FEED_PDF", "Покажи новините в PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Покажи новините в RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Покажи новините в HTML");
    translation.put("MENU_NEW_FAVORITE", "Ново предпочитание");
    translation.put("MENU_EDIT", "Поправи");
    translation.put("MENU_EDIT_COPY", "Копирай");
    translation.put("MENU_EDIT_PASTE", "Сложи");
    translation.put("MENU_EDIT_SELECT_ALL", "Избери всички");
    translation.put("MENU_EDIT_DELETE", "Изтрий");
    translation.put("MENU_EDIT_CUT", "Махни и запомни");
    translation.put("MENU_FEED_DISCOVERY", "Намери новини във WEB сайт");
    translation.put("MENU_CONNECTION", "Връзка");
    translation.put("MENU_EDIT_RENAME", "Преименовай");
    translation.put("MENU_WORK_OFFLINE", "Работи офлайн");
    translation.put("MENU_WORK_ONLINE", "Работи онлайн");

    /** ToolBar */
    translation.put("TOOL_MARK", "Маркирай");
    translation.put("TOOL_NEXT", "Следващ");
    translation.put("TOOL_SEPARATOR", "Разделител");
    translation.put("TOOL_ICONS_TEXT", "Икони и текст");
    translation.put("TOOL_ICONS", "Икони");
    translation.put("TOOL_TEXT", "Текст");
    translation.put("TOOL_RATE", "Оцени");
    translation.put("TOOL_HISTORY", "Хроника");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Нов");
    translation.put("POP_SUB_CATEGORY", "Субкатегория");
    translation.put("POP_UNSUBSCRIBE", "Спри абонамент");
    translation.put("POP_USEPROXY", "Използвай прокси");
    translation.put("POP_AGGREGATE_FAV", "Подреди предпочитанията");
    translation.put("POP_AUTO_UPDATE", "Авто актуализация");
    translation.put("POP_UPDATE_ONSTARTUP", "При старт");
    translation.put("POP_IMPORT", "Внеси");
    translation.put("POP_FROM_OPML", "От OPML файл");
    translation.put("POP_EXPORT_OPML", "На OPML файл");
    translation.put("POP_COPY", "Копирай");
    translation.put("POP_OPEN_IN_BROWSER", "Отвори избраното в браузър");
    translation.put("POP_MARK_UNREAD", "Маркирай непрочетени");
    translation.put("POP_COPY_NEWS_URL", "Копирай линк");
    translation.put("POP_RATE_NEWS", "Класирай новините");
    translation.put("POP_MAIL_LINK", "Изпрати NewsTip на приятел");
    translation.put("POP_OPEN_STARTUP", "Отвори при старт");
    translation.put("POP_KEEP_CURRENT", "Затвори другите");
    translation.put("POP_KEEP_NEWSFEEDS", "Затвори всичко освен заглавията");
    translation.put("POP_BLOG_NEWS", "Блог новини");
    translation.put("POP_OPEN_EXTERN", "Отвори външно");
    translation.put("POP_MARK_ALL_READ", "Всички като прочетени");
    translation.put("POP_MARK_CATEGORY_READ", "Маркирай категорията като прочетена");
    translation.put("POP_PROPERTIES", "Предпочитания");
    translation.put("POP_TAB_POSITION", "Позиция");
    translation.put("POP_TAB_POS_TOP", "Най-отгоре");
    translation.put("POP_TAB_POS_BOTTOM", "Най-отдолу");
    translation.put("POP_MARK_FAVORITE_READ", "Отбележи предпочитанието като прочетено");
    translation.put("POP_IMPORT_BLOGROLL", "Синхронизиран Blogroll");
    translation.put("POP_SYNCHRONIZE", "Синхронизирай");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Настрой Тулбара");
    translation.put("POP_CLEAR_HISTORY", "Изчисти хрониката");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Непредвидена грешка! RSSOwl прекъсва работа, но сетингите са записани.\nГрешката е записана в '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nИскате ли да изпратите рапорт за грешката до разработчиците на RSSOwl?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Грешка");
    translation.put("ERROR_NO_NEWS_FOUND", "Грешка: няма намерени новини!");
    translation.put("ERROR_CAT_EXISTS", "Категория с това име вече има!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Предпочитание с това заглавие вече има!");
    translation.put("ERROR_FAV_URL_EXISTS", "Предпочитание с този URL вече има!");
    translation.put("ERROR_CONNECTION_FAILED", "Няма връзка!");
    translation.put("ERROR_GRABTITLE_FAILED", "Не намерих заглавието!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl не може да покаже новината.");
    translation.put("ERROR_FILE_NOT_FOUND", "Файла не може да бъде намерен");
    translation.put("ERROR_AUTH_REQUIRED", "Новината е защитена и изисква аутентикация");
    translation.put("ERROR_REASON", "Причина");
    translation.put("ERROR_LOADING_FEED", "Грешка при зареждане на новината \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Статус");
    translation.put("ERROR_WORKING_OFFLINE", "Новината не може да се покаже в офлайн режим");
    translation.put("ERROR_NOT_A_XML", "Файла не е валиден XML документ");
    translation.put("ERROR_NOT_A_RSS", "XML документа не е валидна RSS, RDF или Atom новина");
    translation.put("ERROR_NOT_A_OPML", "XML документа не е OPML файл");
    translation.put("ERROR_SUB_EXISTS", "Вие вече сте абониран за този Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Path");
    translation.put("LABEL_CATEGORY", "Категория");
    translation.put("LABEL_NO_INFOS", "Няма допълнителна информация!");
    translation.put("LABEL_FAVORITE", "Предпочетен");
    translation.put("LABEL_TITLE", "Заглавие");
    translation.put("LABEL_USE_PROXY", "Използвай прокси");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Прокси изисква идентификация");
    translation.put("LABEL_USERNAME", "Логин");
    translation.put("LABEL_PASSWORD", "Парола");
    translation.put("LABEL_PROXY_HOST", "Прокси хост");
    translation.put("LABEL_PROXY_PORT", "Прокси порт");
    translation.put("LABEL_CATEGORY", "Категория");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Всички предпочетени през прокси");
    translation.put("LABEL_NEWS_RATED", "Класирани новини");
    translation.put("LABEL_SEARCH_TOPIC", "Моля въведи търсещ критерий");
    translation.put("LABEL_SEARCH_FINISHED", "Търсенето завърши.");
    translation.put("LABEL_SEARCH_RUNNING", "Търсене...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Интензивно търсене");
    translation.put("LABEL_PREFERED_LANGUAGE", "Предпочитан език");
    translation.put("LABEL_DESCRIPTION", "Описание");
    translation.put("LABEL_CREATED", "Създаден");
    translation.put("LABEL_LAST_VISIT", "Последно посещение");
    translation.put("LABEL_USED_BY", "използван от");
    translation.put("LABEL_NAME", "Име");
    translation.put("LABEL_KEY_SEQUENCE", "Последователност от клавиши");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Последователността от клавиши е грешна!");
    translation.put("LABEL_SIZE", "Размер");
    translation.put("LABEL_STYLE", "Стил");
    translation.put("LABEL_SELECT_ENCODING", "Избери кодиране");
    translation.put("LABEL_MAIL_SUBJECT", "Предмет");
    translation.put("LABEL_MAIL_BODY", "Изложение");
    translation.put("LABEL_MAIL_USAGE", "Използвай [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] и [DESCRIPTION] като ключови думи");
    translation.put("LABEL_EMPTY_LINK", "Няма линк");
    translation.put("LABEL_USE_SYSTEM_FONT", "Използвай системния шрифт");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Поща в HTML формат");
    translation.put("LABEL_CURRENT_COLOR", "Текущ цвят");
    translation.put("LABEL_OPTIONS", "Опции");
    translation.put("LABEL_BLOGGER_USAGE", "Използвай [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] и [TITLE] като ключови думи");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Отвори последното четено заглавие при старт");
    translation.put("LABEL_SELECT_BLOGGER", "Избери външен блогър");
    translation.put("LABEL_SINGLE_CLICK", "Единичен клик");
    translation.put("LABEL_DOUBLE_CLICK", "Двоен клик");
    translation.put("LABEL_SEARCH_RESULTS", "Търсенето за \"%TERM%\" има %NUM% резултати");
    translation.put("LABEL_SEARCH_EMPTY", "Търсенето за \"%TERM%\" няма никакви резултати.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Моля изберете един от двата типа прозорци");
    translation.put("LABEL_TRADITIONAL_TABS", "Традиционни табове");
    translation.put("LABEL_CURVED_TABS", "Табове като крива");
    translation.put("LABEL_READY", "Готов");
    translation.put("LABEL_BROWSER_USAGE", "Използвай [URL] вместо съществуващия URL.");
    translation.put("LABEL_ADDRESS", "URL адрес");
    translation.put("LABEL_FEED_TYPE", "Тип на новината");
    translation.put("LABEL_VALIDATION_FINISHED", "Проверката завърши");
    translation.put("LABEL_VALIDATING", "Проверявам");
    translation.put("LABEL_OVERRIDE_DTD", "Игнориране типа на документа");
    translation.put("LABEL_OLD_ID", "Стар ИД на потребителя (незадължителен)");
    translation.put("LABEL_AMPHETARATE_ID", "ИД на потребителя");
    translation.put("LABEL_NOT_UNSUPPORTED", "Още не се подържа във вашата операционна система");
    translation.put("LABEL_KEY_DEL", "Триене");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Всички стойности тук ще бъдат вземани като начални стойности на всяко ново предпочитание.");
    translation.put("LABEL_RESTART", "Промените изискват рестартиране на RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Добре дошли в RSSOwl - читател на RSS / RDF / Atom новини");
    translation.put("LABEL_FIRST_STEPS", "Първи стъпки");
    translation.put("LABEL_NEWS", "Новини");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Новини за RSSOwl");
    translation.put("LABEL_SUPPORT", "Подръжка");
    translation.put("LABEL_DISCUSSION_FORUM", "Дискусионен форум");
    translation.put("LABEL_PROMOTION", "Реклама");
    translation.put("LABEL_CONTACT", "Контакти");
    translation.put("LABEL_REMEMBER_AUTH", "Запомни потребител и парола");
    translation.put("LABEL_SORT_ORDER", "Сортиране на новините");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl сортира новините по първия елемент в списъка. В случай, че този елемент не съществува RSSOwl продължава със следващия елемент в списъка.");
    translation.put("LABEL_START", "Започни");
    translation.put("LABEL_DOWNLOAD", "Свали");
    translation.put("LABEL_MAX_CONNECTIONS", "Максимален брой връзки");
    translation.put("LABEL_CON_TIMEOUT", "Таймаут на връзката в секунди");
    translation.put("LABEL_DELETE_FAVORITE", "Изтрий предпочитание");
    translation.put("LABEL_DELETE_CATEGORY", "Изтрий категория");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Изтрий Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Регистрацията беше успешна");
    translation.put("LABEL_DOMAIN", "Domain");
    translation.put("LABEL_SHOW", "Показвай");
    translation.put("LABEL_SEARCH_IN", "Търси в");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Отвори");
    translation.put("BUTTON_RELOAD_CAT", "Презареди");
    translation.put("BUTTON_ADD", "Добави");
    translation.put("BUTTON_FILE", "Избери файл");
    translation.put("BUTTON_SEARCH", "Търси");
    translation.put("BUTTON_RELOAD", "Презареди новините");
    translation.put("BUTTON_CANCLE", "Отказ");
    translation.put("BUTTON_EXPORT", "Изведи");
    translation.put("BUTTON_STOP_SEARCH", "Спри търсенето");
    translation.put("BUTTON_CLEAR_RESULTS", "Изчисти резултатите");
    translation.put("BUTTON_EXPORT_TO_OPML", "Запиши като OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Добави в предпочитанията");
    translation.put("BUTTON_ASSIGN", "Назначи");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Възстанови старото");
    translation.put("BUTTON_APPLY", "Приложи");
    translation.put("BUTTON_CHANGE_FONT", "Смени шрифта");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_CHANGE", "Смени");
    translation.put("BUTTON_MARK_ALL_READ", "Всички категории като прочетени");
    translation.put("BUTTON_AGGREGATE_ALL", "Агрегирай всички категории");
    translation.put("BUTTON_RELOAD_ALL", "Презареди всички категории");
    translation.put("BUTTON_SEARCH_ALL", "Търси във всички категории");
    translation.put("BUTTON_DISPLAY_TABS", "Покажи заглавията в табове");
    translation.put("BUTTON_VALIDATE", "Провери");
    translation.put("BUTTON_STOP_VALIDATION", "Спри проверката");
    translation.put("BUTTON_TRAY_STARTUP", "Сложи RSSOwl в системната зона при стартиране");
    translation.put("BUTTON_TRAY_EXIT", "Сложи RSSOwl в системната зона при изход");
    translation.put("BUTTON_SHOW_ERRORS", "Показвай грешките в главния прозорец");
    translation.put("BUTTON_FOCUS_TABS", "Сложи фокуса на нов таб");
    translation.put("BUTTON_CREATE_ACCOUNT", "Създай профил");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Затваряй прозореца за новини автоматично");
    translation.put("BUTTON_CACHE_FEEDS", "Автоматично запиши новините за офлайн четене по-късно");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Отметни всички новини като прочетени при минимизация");
    translation.put("BUTTON_TRAY_POPUP", "Съобщи ми когато има непрочетени новини");
    translation.put("BUTTON_READ_ON_CLOSE", "Отметни новините като прочетени при затваряне на таба");
    translation.put("BUTTON_UP", "Нагоре");
    translation.put("BUTTON_DOWN", "Надолу");
    translation.put("BUTTON_NO_SORT", "Не сортирай новините автоматично");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Отвори в браузъра");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Включи затварящ бутон на табовете");
    translation.put("BUTTON_DELETE_FAVORITE", "при изтриване на предпочитание");
    translation.put("BUTTON_DELETE_CATEGORY", "при изтриване на категория");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "при изтриване на Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Никога повече не питай");
    translation.put("BUTTON_BLOCK_POPUPS", "Блокирай попъп прозорци");
    translation.put("BUTTON_ANIMATE_POPUP", "Анимиран попъп");
    translation.put("BUTTON_REMOVE", "Премахни");
    translation.put("BUTTON_SMALL_ICONS", "Ползвай малки икони");
    translation.put("BUTTON_LINK_TAB", "Свържи с актуалната новина");
    translation.put("BUTTON_CLEAR", "Изчисти");

    /** Header */
    translation.put("HEADER_NEWS", "Заглавие");
    translation.put("HEADER_RSS_FAVORITES", "предпочитания");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Кликнете за да отворите сайта!");
    translation.put("TOOLTIP_PRINT", "Разпечати новините");
    translation.put("TOOLTIP_RATE", "Кликнете за да класирате");
    translation.put("TOOLTIP_GRAB_TITLE", "Вземи заглавието от новините");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Има непрочетени новини");
    translation.put("TOOLTIP_SKIP", "Прескочи");
    translation.put("TOOLTIP_QUICKSEARCH", "Бързо търсене");
    translation.put("TOOLTIP_OPEN_TAB", "Отвори нов таб");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Публикувано на");
    translation.put("TABLE_HEADER_AUTHOR", "Автор");
    translation.put("TABLE_HEADER_CATEGORY", "Категория");
    translation.put("TABLE_HEADER_PUBLISHER", "Издател");
    translation.put("TABLE_HEADER_NEWSTITLE", "Заглавие");
    translation.put("TABLE_HEADER_FEED", "Изложение");
    translation.put("TABLE_HEADER_FEEDURL", "URL на изложението");
    translation.put("TABLE_HEADER_FEEDTITLE", "Заглавие на изложението");
    translation.put("TABLE_HEADER_LINE", "Ред");
    translation.put("TABLE_HEADER_STATUS", "Статус на четене");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Челна страница");
    translation.put("CHANNEL_INFO_PUBDATE", "Дата на публикуване");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Последна промяна на канала");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Главен редактор");
    translation.put("CHANNEL_INFO_WEBMASTER", "Уебмастър");
    translation.put("CHANNEL_INFO_CATEGORY", "Категория");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Време на валидност на канала");
    translation.put("CHANNEL_INFO_RSSVERSION", "Формат");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS генератор");
    translation.put("CHANNEL_INFO_PUBLISHER", "Издател");
    translation.put("CHANNEL_INFO_LANGUAGE", "Език");
    translation.put("CHANNEL_INFO_CREATOR", "Създател");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Модификация");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "пъти");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Източник");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Приложение");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Коментарии");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Внимание");
    translation.put("MESSAGEBOX_FILL_URL", "Моля въведете URL или директория");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Катогория с това име вече има");
    translation.put("MESSAGEBOX_SELECT_CAT", "Моля изберете категория");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Файла същвствува. Да го презапиша ли?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Файла няма RSSOwl сетинги!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Сетингите са въведени успешно!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Новините са празни! Моля изберете новини.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Добави ново предпочитание");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Добави нова категория");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Въведи заглавие");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Въведи url / директория и заглавие");
    translation.put("BASE_AUTH_TITLE", "Желания саит изисква аутентикация!");
    translation.put("BASE_AUTH_MESSAGE", "Въведи логин и парола.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Невалиден RSS е избран в таб фолдера!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Моля потвърдете");
    translation.put("SEARCH_DIALOG_TITLE", "Търсене");
    translation.put("SEARCH_DIALOG_MESSAGE", "Моля използвай И, ИЛИ и БЕЗ за да определиш търсенето");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Търси за");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Само цели думи");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Големи и малки букви имат значение");
    translation.put("SEARCH_DIALOG_REGEX", "Използвай нормална фраза");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Няма нова версия");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Вие използвате най-новата версия на RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Информация");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Редактирай категория");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Редактирай предпочитание");
    translation.put("DIALOG_TITLE_UPDATE", "Има нова RSSOwl версия");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Въведете директорията на програмата");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Не мога да се свържа с http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Трябва първо да създадете AmphetaRate профил!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Категорията няма предпочитания!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Въведете последователност от клавиши");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Не мога да стартирам браузъра!\nМоля определете браузър в 'Преференции'");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Трябва първо да установите блогър!");
    translation.put("DIALOG_TITLE_CATEGORY", "Избери категория");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl не може да намери апликация която да покаже %FORMAT%");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Моля въведете адреса на WEB сайта");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Редактирай Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Не мога да заредя вътрешния браузър!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Добави нов Blogroll");
    translation.put("QUESTION_DEL_FAV", "Сигурен ли сте че искате да изтриете предпочитанието \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Сигурен ли сте че искате да изтриете категорията \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Сигурен ли сте че искате да изтриете този Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Назад");
    translation.put("BROWSER_FORWARD", "Напред");
    translation.put("BROWSER_STOP", "Спри");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Фантастично");
    translation.put("RATE_GOOD", "Добро");
    translation.put("RATE_MODERATE", "Средна работа");
    translation.put("RATE_BAD", "Лошо");
    translation.put("RATE_VERY_BAD", "Отвратително");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "Няма");
    translation.put("UPDATE_INTERVAL_ONE", "всяка 1 минута");
    translation.put("UPDATE_INTERVAL_FIVE", "всеки 5 минути");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "всеки 15 минути");
    translation.put("UPDATE_INTERVAL_THIRTY", "всеки 30 минути");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "всеки 1 час");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "всеки 3 часа");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "всеки 6 часа");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "всеки 12 часа");
    translation.put("UPDATE_INTERVAL_ONEDAY", "всеки 24 часа");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Стрелка нагоре");
    translation.put("LABEL_KEY_ARROW_DOWN", "Стрелка надолу");
    translation.put("LABEL_KEY_ARROW_LEFT", "Стрелка наляво");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Стрелка надясно");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Интервал");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Пауза");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font */
    translation.put("FONT_AREA_TEXT", "Шрифт за текста");
    translation.put("FONT_AREA_DIALOG", "Шрифт за диалога");
    translation.put("FONT_AREA_TREE", "Шрифт за структурата");
    translation.put("FONT_AREA_TABLE", "Шрифт за таблицата");
    translation.put("FONT_AREA_HEADER", "Шрифт за заглавието");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Шрифта за текст се използва за новините, информация за каналите, съобщения и грешки..");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Шрифта за диалог се използва при всички диалози.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Шрифта за структурата се използва за да се покажат предпочитанията.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Шрифта за таблицата се използва при таблицата, която показва новините.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Шрифта за заглавията се използва за да покаже заглавия на новините.");
    translation.put("FONT_STYLE_BOLD", "Надебелен");
    translation.put("FONT_STYLE_ITALIC", "Курсив");
    translation.put("FONT_STYLE_NORMAL", "Нормален");

    /** Groups */
    translation.put("GROUP_COMMAND", "Команда");
    translation.put("GROUP_SELECTED_FONT", "Избран шрифт");
    translation.put("GROUP_FONT_AREA", "Зона на шрифтовете");
    translation.put("GROUP_WINDOW_LAYOUT", "Тип прозорец");
    translation.put("GROUP_LINK_COLOR", "Цвят на линковете");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Цвят за подчертаване на синтакса");
    translation.put("GROUP_ARGUMENTS", "Аргументи");
    translation.put("GROUP_OPEN_MODE", "Начин на отваряне");
    translation.put("GROUP_TAB_LAYOUT", "Подредба на табове");
    translation.put("GROUP_GENERAL", "Общи");
    translation.put("GROUP_TRAY", "Системна зона");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Цвят на резултатите от търсене");
    translation.put("GROUP_EXISTING_ACCOUNT", "Съществуващ профил");
    translation.put("GROUP_NEW_ACCOUNT", "Създай нов профил");
    translation.put("GROUP_NEWS_POPUP", "Прозорец за новини");
    translation.put("GROUP_CONFIRM_DIALOG", "Показване на потвърждаващ диалог");

    /** Languages */
    translation.put("de", "Немски");
    translation.put("da", "Датски");
    translation.put("el", "Гръцки");
    translation.put("en", "Английски");
    translation.put("es", "Испански");
    translation.put("fr", "Френски");
    translation.put("gl", "Галски");
    translation.put("it", "Италиянски");
    translation.put("nl", "Холандски");
    translation.put("pt", "Португалски (Бразилия)");
    translation.put("ru", "Руски");
    translation.put("bg", "Български");
    translation.put("no", "норвежский");
    translation.put("zhcn", "Китайски опростен");
    translation.put("ja", "Японски");
    translation.put("bn", "Бенгалски");
    translation.put("ko", "Корейски");
    translation.put("pl", "Полски");
    translation.put("sv", "Шведски");
    translation.put("tr", "Турски");
    translation.put("uk", "Украински");
    translation.put("fi", "Финландски");
    translation.put("cs", "Чешки");
    translation.put("sl", "Словенски");
    translation.put("zhtw", "Традиционен китайски");
    translation.put("hu", "Унгарски");
    translation.put("th", "Тайландски");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Няма описание!");
    translation.put("PRINTED_FROM_RSSOWL", "Отпечатано от RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Разпечатка новини от RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Покажи RSSOwl");
    translation.put("TAB_WELCOME", "Добре дошли");
    translation.put("DOCUMENT_GENERATED_FROM", "Документа е генериран от RSSOwl");
    translation.put("NO_TITLE", "Няма заглавие");
    translation.put("RSSOWL_TEASER", "RSSOwl е безплатен, отворен соурс RSS / RDF / Atom клиент за новини. Допълнителните му възможности са:\n\n- Запиши новини като PDF, HTML, RTF, OPML\n- Вкарай предпочитания от OPML\n- Търсене в пълния текст с маркиране на резултатите\n- Мощна RSS / RDF / Atom търсеща машина\n- Разглеждане на новините във вътрешен браузър\n- Подреждане на предпочитанията по категории\n- Върви на Windows, Linux, Solaris и Mac\n\nЗа пълен списък на възможностите виж: http://www.rssowl.org/overview\n\nСвали от: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Препоръчани заглавия");
    translation.put("LOAD_FEED", "Зареждане");
    translation.put("SEARCH_FEED", "Търсене");
    translation.put("RELOAD_FEED", "Презареждане");
    translation.put("NEWSFEED_VALID", "Валидно заглавие");
    translation.put("FORMAT_AUTO_DETECT", "Автоматична настройка");
    translation.put("MAIL_ERROR_BODY", "Моля приложете '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' към този емайл и дайте кратко описание какво направи RSSOwl точно преди да се случи грешката. Благодарим Ви!");
    translation.put("OPML_IMPORTED", "Внесени");
    translation.put("ENTIRE_NEWS", "Всички новини");
    translation.put("SEARCH_AND", "И");
    translation.put("SEARCH_OR", "ИЛИ");
    translation.put("SEARCH_NOT", "БЕЗ");
  }
}